/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import java.util.Collection;
import org.bonitasoft.bonita2bar.process.expression.EngineExpressionUtil;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.process.BooleanType;
import org.bonitasoft.bpm.model.process.BusinessObjectData;
import org.bonitasoft.bpm.model.process.BusinessObjectType;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.DateType;
import org.bonitasoft.bpm.model.process.DoubleType;
import org.bonitasoft.bpm.model.process.EnumType;
import org.bonitasoft.bpm.model.process.FloatType;
import org.bonitasoft.bpm.model.process.IntegerType;
import org.bonitasoft.bpm.model.process.JavaObjectData;
import org.bonitasoft.bpm.model.process.JavaType;
import org.bonitasoft.bpm.model.process.LongType;
import org.bonitasoft.bpm.model.process.StringType;
import org.bonitasoft.bpm.model.process.XMLType;
import org.bonitasoft.bpm.model.process.util.ProcessSwitch;
import org.bonitasoft.engine.bpm.process.impl.BusinessDataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.InvalidExpressionException;

public class EngineDataBuilder
extends ProcessSwitch<DataDefinitionBuilder> {
    private final Data data;
    private final FlowElementBuilder builder;
    private Expression expr;

    public EngineDataBuilder(Data data, FlowElementBuilder flowElementBuilder) {
        this.builder = flowElementBuilder;
        this.data = data;
        this.expr = this.createExpression(data);
    }

    private Expression createExpression(Data data) {
        try {
            Expression expression = EngineExpressionUtil.createExpression((AbstractExpression)data.getDefaultValue());
            if (expression == null && data.isMultiple()) {
                return EngineExpressionUtil.createEmptyListExpression();
            }
            return expression;
        }
        catch (InvalidExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Expression getDefaultValueExpression() {
        return this.expr;
    }

    public Data getData() {
        return this.data;
    }

    public DataDefinitionBuilder caseStringType(StringType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addLongTextData(this.data.getName(), this.expr);
    }

    protected DataDefinitionBuilder addCollectionData(String name, Expression defaultValue) {
        return this.builder.addData(name, Collection.class.getName(), defaultValue);
    }

    public DataDefinitionBuilder caseLongType(LongType object) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addLongData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseDoubleType(DoubleType object) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addDoubleData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseIntegerType(IntegerType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addIntegerData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseBooleanType(BooleanType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addBooleanData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseFloatType(FloatType type) {
        throw new UnsupportedOperationException("FloatType is not supported");
    }

    public DataDefinitionBuilder caseEnumType(EnumType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addShortTextData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseJavaType(JavaType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addData(this.data.getName(), ((JavaObjectData)this.data).getClassName(), this.expr);
    }

    public DataDefinitionBuilder caseXMLType(XMLType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addXMLData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseDateType(DateType type) {
        if (this.data.isMultiple()) {
            return this.addCollectionData(this.data.getName(), this.expr);
        }
        return this.builder.addDateData(this.data.getName(), this.expr);
    }

    public DataDefinitionBuilder caseBusinessObjectType(BusinessObjectType object) {
        BusinessObjectData bod = (BusinessObjectData)this.getData();
        if (this.builder instanceof ProcessDefinitionBuilder) {
            BusinessDataDefinitionBuilder businessDataBuilder = ((ProcessDefinitionBuilder)this.builder).addBusinessData(bod.getName(), bod.getClassName(), this.getDefaultValueExpression());
            businessDataBuilder.setMultiple(bod.isMultiple());
            businessDataBuilder.addDescription(bod.getDocumentation());
        }
        return null;
    }
}

