/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.bonitasoft.bonita2bar.process.builder.AbstractProcessBuilder;
import org.bonitasoft.bonita2bar.process.builder.BuildProcessDefinitionException;
import org.bonitasoft.bonita2bar.process.builder.EngineSequenceFlowBuilder;
import org.bonitasoft.bonita2bar.process.builder.ProcessBuilderException;
import org.bonitasoft.bonita2bar.process.builder.TaskContractEngineDefinitionBuilder;
import org.bonitasoft.bonita2bar.process.expression.EngineExpressionUtil;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorParameter;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.ListExpression;
import org.bonitasoft.bpm.model.expression.Operation;
import org.bonitasoft.bpm.model.process.ANDGateway;
import org.bonitasoft.bpm.model.process.AbstractCatchMessageEvent;
import org.bonitasoft.bpm.model.process.AbstractTimerEvent;
import org.bonitasoft.bpm.model.process.Activity;
import org.bonitasoft.bpm.model.process.ActorFilter;
import org.bonitasoft.bpm.model.process.BoundaryEvent;
import org.bonitasoft.bpm.model.process.BoundaryMessageEvent;
import org.bonitasoft.bpm.model.process.BoundarySignalEvent;
import org.bonitasoft.bpm.model.process.BoundaryTimerEvent;
import org.bonitasoft.bpm.model.process.BusinessObjectData;
import org.bonitasoft.bpm.model.process.CallActivity;
import org.bonitasoft.bpm.model.process.ConnectableElement;
import org.bonitasoft.bpm.model.process.Connection;
import org.bonitasoft.bpm.model.process.Correlation;
import org.bonitasoft.bpm.model.process.CorrelationTypeActive;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.DataAware;
import org.bonitasoft.bpm.model.process.Element;
import org.bonitasoft.bpm.model.process.EndErrorEvent;
import org.bonitasoft.bpm.model.process.EndEvent;
import org.bonitasoft.bpm.model.process.EndMessageEvent;
import org.bonitasoft.bpm.model.process.EndSignalEvent;
import org.bonitasoft.bpm.model.process.EndTerminatedEvent;
import org.bonitasoft.bpm.model.process.FlowElement;
import org.bonitasoft.bpm.model.process.InclusiveGateway;
import org.bonitasoft.bpm.model.process.InputMapping;
import org.bonitasoft.bpm.model.process.InputMappingAssignationType;
import org.bonitasoft.bpm.model.process.IntermediateCatchMessageEvent;
import org.bonitasoft.bpm.model.process.IntermediateCatchSignalEvent;
import org.bonitasoft.bpm.model.process.IntermediateCatchTimerEvent;
import org.bonitasoft.bpm.model.process.IntermediateErrorCatchEvent;
import org.bonitasoft.bpm.model.process.IntermediateThrowMessageEvent;
import org.bonitasoft.bpm.model.process.IntermediateThrowSignalEvent;
import org.bonitasoft.bpm.model.process.Lane;
import org.bonitasoft.bpm.model.process.Message;
import org.bonitasoft.bpm.model.process.MultiInstanceType;
import org.bonitasoft.bpm.model.process.MultiInstantiable;
import org.bonitasoft.bpm.model.process.NonInterruptingBoundaryTimerEvent;
import org.bonitasoft.bpm.model.process.OperationContainer;
import org.bonitasoft.bpm.model.process.OutputMapping;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.ReceiveTask;
import org.bonitasoft.bpm.model.process.SearchIndex;
import org.bonitasoft.bpm.model.process.SendTask;
import org.bonitasoft.bpm.model.process.SourceElement;
import org.bonitasoft.bpm.model.process.StartErrorEvent;
import org.bonitasoft.bpm.model.process.StartEvent;
import org.bonitasoft.bpm.model.process.StartMessageEvent;
import org.bonitasoft.bpm.model.process.StartSignalEvent;
import org.bonitasoft.bpm.model.process.StartTimerEvent;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.process.Task;
import org.bonitasoft.bpm.model.process.XORGateway;
import org.bonitasoft.bpm.model.process.util.DataUtil;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.engine.bpm.flownode.GatewayType;
import org.bonitasoft.engine.bpm.flownode.TaskPriority;
import org.bonitasoft.engine.bpm.flownode.TimerType;
import org.bonitasoft.engine.bpm.process.impl.ActivityDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.AutomaticTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.BoundaryEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.CallActivityBuilder;
import org.bonitasoft.engine.bpm.process.impl.CatchMessageEventTriggerDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DescriptionBuilder;
import org.bonitasoft.engine.bpm.process.impl.EndEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.bpm.process.impl.GatewayDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.IntermediateCatchEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.IntermediateThrowEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.MultiInstanceLoopCharacteristicsBuilder;
import org.bonitasoft.engine.bpm.process.impl.ReceiveTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.SendTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.StartEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.SubProcessDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ThrowMessageEventTriggerBuilder;
import org.bonitasoft.engine.bpm.process.impl.UserFilterDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.UserTaskDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.bonitasoft.engine.operation.LeftOperandBuilder;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.OperatorType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineFlowElementBuilder
extends AbstractProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineFlowElementBuilder.class);
    private final FlowElementBuilder builder;
    private TaskContractEngineDefinitionBuilder contractBuilder;

    public EngineFlowElementBuilder(FlowElementBuilder processBuilder, TaskContractEngineDefinitionBuilder contractBuilder, IModelSearch modelSearch) {
        super(modelSearch);
        this.builder = processBuilder;
        this.contractBuilder = contractBuilder;
    }

    public Element caseSubProcessEvent(SubProcessEvent subProcessEvent) {
        SubProcessDefinitionBuilder subProcessBuilder = this.builder.addSubProcess(subProcessEvent.getName(), true).getSubProcessBuilder();
        EngineFlowElementBuilder subProcessSwitch = new EngineFlowElementBuilder((FlowElementBuilder)subProcessBuilder, this.contractBuilder, this.modelSearch);
        List flowElements = this.modelSearch.getAllItemsOfType((EObject)subProcessEvent, FlowElement.class);
        for (FlowElement flowElement : flowElements) {
            subProcessSwitch.doSwitch((EObject)flowElement);
        }
        List sourceElements = this.modelSearch.getAllItemsOfType((EObject)subProcessEvent, SourceElement.class);
        EngineSequenceFlowBuilder sequenceFlowSwitch = new EngineSequenceFlowBuilder((FlowElementBuilder)subProcessBuilder);
        for (SourceElement sourceElement : sourceElements) {
            for (Connection connection : sourceElement.getOutgoing()) {
                sequenceFlowSwitch.doSwitch((EObject)connection);
            }
        }
        return subProcessEvent;
    }

    public Activity caseActivity(Activity activity) {
        AutomaticTaskDefinitionBuilder taskBuilder = this.builder.addAutomaticTask(activity.getName());
        this.handleCommonActivity(activity, (ActivityDefinitionBuilder)taskBuilder);
        return activity;
    }

    public Element caseSendTask(SendTask senTask) {
        try {
            Expression targetProcess = null;
            Message message = null;
            if (!senTask.getEvents().isEmpty()) {
                message = (Message)senTask.getEvents().get(0);
                targetProcess = EngineExpressionUtil.createExpression((AbstractExpression)message.getTargetProcessExpression());
                SendTaskDefinitionBuilder taskBuilder = this.builder.addSendTask(senTask.getName(), message.getName(), targetProcess);
                taskBuilder.setTargetFlowNode(EngineExpressionUtil.createExpression((AbstractExpression)message.getTargetElementExpression()));
                if (message.getMessageContent() != null) {
                    this.addMessageContent(message, taskBuilder);
                }
                if (message.getCorrelation() != null) {
                    this.addCorrelation(message, taskBuilder);
                }
                this.handleCommonActivity((Activity)senTask, (ActivityDefinitionBuilder)taskBuilder);
            }
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return senTask;
    }

    private void addMessageContent(Message message, SendTaskDefinitionBuilder taskBuilder) throws InvalidExpressionException {
        for (ListExpression row : message.getMessageContent().getExpressions()) {
            EList col = row.getExpressions();
            org.bonitasoft.bpm.model.expression.Expression idExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
            org.bonitasoft.bpm.model.expression.Expression messageContentExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
            if (col.size() != 2 || idExp.getContent() == null || idExp.getContent().isEmpty() || messageContentExp.getContent() == null || messageContentExp.getContent().isEmpty()) continue;
            taskBuilder.addMessageContentExpression(EngineExpressionUtil.createExpression((AbstractExpression)idExp), EngineExpressionUtil.createExpression((AbstractExpression)messageContentExp));
        }
    }

    private void addCorrelation(Message message, SendTaskDefinitionBuilder taskBuilder) throws InvalidExpressionException {
        for (ListExpression row : message.getCorrelation().getCorrelationAssociation().getExpressions()) {
            EList col = row.getExpressions();
            if (col.size() != 2) continue;
            org.bonitasoft.bpm.model.expression.Expression correlationKeyExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
            org.bonitasoft.bpm.model.expression.Expression valueExpression = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
            if (correlationKeyExp.getContent() == null || correlationKeyExp.getContent().isEmpty() || valueExpression.getContent() == null || valueExpression.getContent().isEmpty()) continue;
            taskBuilder.addCorrelation(EngineExpressionUtil.createExpression((AbstractExpression)correlationKeyExp), EngineExpressionUtil.createExpression((AbstractExpression)valueExpression));
        }
    }

    public Element caseReceiveTask(ReceiveTask receiveTask) {
        try {
            String messageName = receiveTask.getEvent();
            ReceiveTaskDefinitionBuilder taskBuilder = this.builder.addReceiveTask(receiveTask.getName(), messageName);
            if (messageName != null) {
                for (Operation operation : receiveTask.getMessageContent()) {
                    if (operation.getLeftOperand() == null || !operation.getLeftOperand().hasContent() || operation.getRightOperand() == null || operation.getRightOperand().getContent() == null) continue;
                    taskBuilder.addMessageOperation(EngineExpressionUtil.createOperationForMessageContent(operation));
                }
                if (receiveTask.getCorrelation() != null) {
                    this.addCorrelation(receiveTask, taskBuilder);
                }
            }
            this.handleCommonActivity((Activity)receiveTask, (ActivityDefinitionBuilder)taskBuilder);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return receiveTask;
    }

    private void addCorrelation(ReceiveTask receiveTask, ReceiveTaskDefinitionBuilder taskBuilder) throws InvalidExpressionException {
        for (ListExpression row : receiveTask.getCorrelation().getExpressions()) {
            EList col = row.getExpressions();
            if (col.size() != 2) continue;
            org.bonitasoft.bpm.model.expression.Expression correlationKeyExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
            org.bonitasoft.bpm.model.expression.Expression valueExpression = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
            if (correlationKeyExp.getContent() == null || correlationKeyExp.getContent().isEmpty() || valueExpression.getContent() == null || valueExpression.getContent().isEmpty()) continue;
            taskBuilder.addCorrelation(EngineExpressionUtil.createExpression((AbstractExpression)correlationKeyExp), EngineExpressionUtil.createExpression((AbstractExpression)valueExpression));
        }
    }

    public FlowElement caseStartMessageEvent(StartMessageEvent object) {
        StartEventDefinitionBuilder eventBuilder = this.builder.addStartEvent(object.getName());
        String message = object.getEvent();
        if (message != null) {
            try {
                CatchMessageEventTriggerDefinitionBuilder triggerBuilder = eventBuilder.addMessageEventTrigger(message);
                this.addMessageContent((AbstractCatchMessageEvent)object, triggerBuilder);
                if (this.modelSearch.isInEvenementialSubProcessPool((EObject)object)) {
                    this.addMessageCorrelation((AbstractCatchMessageEvent)object, triggerBuilder);
                }
            }
            catch (InvalidExpressionException e) {
                throw new ProcessBuilderException(e);
            }
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    public FlowElement caseIntermediateCatchMessageEvent(IntermediateCatchMessageEvent object) {
        IntermediateCatchEventDefinitionBuilder eventBuilder = this.builder.addIntermediateCatchEvent(object.getName());
        String message = object.getEvent();
        if (message != null) {
            try {
                CatchMessageEventTriggerDefinitionBuilder triggerBuilder = eventBuilder.addMessageEventTrigger(message);
                this.addMessageContent((AbstractCatchMessageEvent)object, triggerBuilder);
                this.addMessageCorrelation((AbstractCatchMessageEvent)object, triggerBuilder);
            }
            catch (InvalidExpressionException e) {
                throw new ProcessBuilderException(e);
            }
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    private void addMessageContent(AbstractCatchMessageEvent messageEvent, CatchMessageEventTriggerDefinitionBuilder triggerBuilder) throws InvalidExpressionException {
        for (Operation operation : messageEvent.getMessageContent()) {
            if (operation.getLeftOperand() == null || !operation.getLeftOperand().hasContent() || operation.getRightOperand() == null || operation.getRightOperand().getContent() == null) continue;
            triggerBuilder.addOperation(EngineExpressionUtil.createOperationForMessageContent(operation));
        }
    }

    private void addMessageCorrelation(AbstractCatchMessageEvent messageEvent, CatchMessageEventTriggerDefinitionBuilder triggerBuilder) throws InvalidExpressionException {
        if (messageEvent.getCorrelation() != null) {
            for (ListExpression row : messageEvent.getCorrelation().getExpressions()) {
                EList col = row.getExpressions();
                if (col.size() != 2) continue;
                org.bonitasoft.bpm.model.expression.Expression correlationKeyExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
                org.bonitasoft.bpm.model.expression.Expression valueExpression = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
                if (correlationKeyExp.getContent() == null || correlationKeyExp.getContent().isEmpty() || valueExpression.getContent() == null || valueExpression.getContent().isEmpty()) continue;
                triggerBuilder.addCorrelation(EngineExpressionUtil.createExpression((AbstractExpression)correlationKeyExp), EngineExpressionUtil.createExpression((AbstractExpression)valueExpression));
            }
        }
    }

    public FlowElement caseIntermediateThrowMessageEvent(IntermediateThrowMessageEvent object) {
        IntermediateThrowEventDefinitionBuilder eventBuilder = this.builder.addIntermediateThrowEvent(object.getName());
        for (Message message : object.getEvents()) {
            try {
                Correlation correlation;
                ThrowMessageEventTriggerBuilder triggerBuilder = eventBuilder.addMessageEventTrigger(message.getName(), EngineExpressionUtil.createExpression((AbstractExpression)message.getTargetProcessExpression()), EngineExpressionUtil.createExpression((AbstractExpression)message.getTargetElementExpression()));
                if (message.getMessageContent() != null) {
                    this.addThrowMessageContent(message, triggerBuilder);
                }
                if ((correlation = message.getCorrelation()) == null || correlation.getCorrelationType() == CorrelationTypeActive.INACTIVE) continue;
                this.addThrowMessageCorrelation(message, triggerBuilder);
            }
            catch (InvalidExpressionException e) {
                throw new ProcessBuilderException(e);
            }
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    private void addThrowMessageCorrelation(Message message, ThrowMessageEventTriggerBuilder triggerBuilder) throws InvalidExpressionException {
        for (ListExpression row : message.getCorrelation().getCorrelationAssociation().getExpressions()) {
            EList col = row.getExpressions();
            if (col.size() != 2) continue;
            org.bonitasoft.bpm.model.expression.Expression correlationKeyExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
            org.bonitasoft.bpm.model.expression.Expression valueExpression = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
            if (correlationKeyExp.getContent() == null || correlationKeyExp.getContent().isEmpty() || valueExpression.getContent() == null || valueExpression.getContent().isEmpty()) continue;
            triggerBuilder.addCorrelation(EngineExpressionUtil.createExpression((AbstractExpression)correlationKeyExp), EngineExpressionUtil.createExpression((AbstractExpression)valueExpression));
        }
    }

    private void addThrowMessageContent(Message message, ThrowMessageEventTriggerBuilder triggerBuilder) throws InvalidExpressionException {
        for (ListExpression row : message.getMessageContent().getExpressions()) {
            EList col = row.getExpressions();
            org.bonitasoft.bpm.model.expression.Expression idExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
            org.bonitasoft.bpm.model.expression.Expression messageContentExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
            if (col.size() != 2 || idExp.getContent() == null || idExp.getContent().isEmpty() || messageContentExp.getContent() == null || messageContentExp.getContent().isEmpty()) continue;
            triggerBuilder.addMessageContentExpression(EngineExpressionUtil.createExpression((AbstractExpression)idExp), EngineExpressionUtil.createExpression((AbstractExpression)messageContentExp));
        }
    }

    public FlowElement caseEndMessageEvent(EndMessageEvent object) {
        EndEventDefinitionBuilder eventBuilder = this.builder.addEndEvent(object.getName());
        for (Message message : object.getEvents()) {
            try {
                Correlation correlation;
                ThrowMessageEventTriggerBuilder triggerBuilder = eventBuilder.addMessageEventTrigger(message.getName(), EngineExpressionUtil.createExpression((AbstractExpression)message.getTargetProcessExpression()), EngineExpressionUtil.createExpression((AbstractExpression)message.getTargetElementExpression()));
                if (message.getMessageContent() != null) {
                    this.addMessageContent(message, triggerBuilder);
                }
                if ((correlation = message.getCorrelation()) == null || correlation.getCorrelationType() == CorrelationTypeActive.INACTIVE) continue;
                this.addThrowMessageCorrelation(message, triggerBuilder);
            }
            catch (InvalidExpressionException e) {
                throw new ProcessBuilderException(e);
            }
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    private void addMessageContent(Message message, ThrowMessageEventTriggerBuilder triggerBuilder) throws InvalidExpressionException {
        for (ListExpression row : message.getMessageContent().getExpressions()) {
            EList col = row.getExpressions();
            if (col.size() != 2) continue;
            org.bonitasoft.bpm.model.expression.Expression idExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(0);
            org.bonitasoft.bpm.model.expression.Expression messageContentExp = (org.bonitasoft.bpm.model.expression.Expression)col.get(1);
            if (idExp.getContent() == null || idExp.getContent().isEmpty() || messageContentExp.getContent() == null || messageContentExp.getContent().isEmpty()) continue;
            triggerBuilder.addMessageContentExpression(EngineExpressionUtil.createExpression((AbstractExpression)idExp), EngineExpressionUtil.createExpression((AbstractExpression)messageContentExp));
        }
    }

    public Element caseStartSignalEvent(StartSignalEvent object) {
        StartEventDefinitionBuilder eventBuilder = this.builder.addStartEvent(object.getName());
        String signal = object.getSignalCode();
        if (signal != null) {
            eventBuilder.addSignalEventTrigger(signal);
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    public EndSignalEvent caseEndSignalEvent(EndSignalEvent object) {
        EndEventDefinitionBuilder eventBuilder = this.builder.addEndEvent(object.getName());
        String signalCode = object.getSignalCode();
        if (signalCode != null) {
            eventBuilder.addSignalEventTrigger(signalCode);
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    public IntermediateCatchSignalEvent caseIntermediateCatchSignalEvent(IntermediateCatchSignalEvent object) {
        IntermediateCatchEventDefinitionBuilder eventBuilder = this.builder.addIntermediateCatchEvent(object.getName());
        String signal = object.getSignalCode();
        if (signal != null) {
            eventBuilder.addSignalEventTrigger(signal);
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    public IntermediateThrowSignalEvent caseIntermediateThrowSignalEvent(IntermediateThrowSignalEvent object) {
        IntermediateThrowEventDefinitionBuilder eventBuilder = this.builder.addIntermediateThrowEvent(object.getName());
        String signal = object.getSignalCode();
        if (signal != null) {
            eventBuilder.addSignalEventTrigger(signal);
        }
        this.addDescription((DescriptionBuilder)eventBuilder, object.getDocumentation());
        return object;
    }

    public CallActivity caseCallActivity(CallActivity object) {
        org.bonitasoft.bpm.model.expression.Expression version = object.getCalledActivityVersion();
        if (version == null || version.getContent() == null || version.getContent().trim().isEmpty()) {
            version = null;
        }
        try {
            CallActivityBuilder activityBuilder = this.builder.addCallActivity(object.getName(), EngineExpressionUtil.createExpression((AbstractExpression)object.getCalledActivityName()), EngineExpressionUtil.createExpression((AbstractExpression)version));
            this.exportInputMappingsForCallActivity(object, activityBuilder);
            this.exportOutputMappingForCallActivities(object, activityBuilder);
            this.handleCommonActivity((Activity)object, (ActivityDefinitionBuilder)activityBuilder);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return object;
    }

    private void exportInputMappingsForCallActivity(CallActivity callActivity, CallActivityBuilder activityBuilder) throws InvalidExpressionException {
        for (InputMapping mapping : callActivity.getInputMappings()) {
            if (InputMappingAssignationType.DATA == mapping.getAssignationType()) {
                this.exportInputMappingAssignedToDataForCallActivity(activityBuilder, callActivity, mapping);
                continue;
            }
            this.exportInputMappingAssignedToContractInputForCallActivity(activityBuilder, mapping);
        }
    }

    private void exportInputMappingAssignedToContractInputForCallActivity(CallActivityBuilder activityBuilder, InputMapping mapping) throws InvalidExpressionException {
        activityBuilder.addProcessStartContractInput(mapping.getSubprocessTarget(), EngineExpressionUtil.createExpression((AbstractExpression)mapping.getProcessSource()));
    }

    private void exportInputMappingAssignedToDataForCallActivity(CallActivityBuilder activityBuilder, CallActivity callActivity, InputMapping mapping) throws InvalidExpressionException {
        OperationBuilder opBuilder = new OperationBuilder();
        opBuilder.createNewInstance();
        opBuilder.setRightOperand(EngineExpressionUtil.createExpression((AbstractExpression)mapping.getProcessSource()));
        LeftOperandBuilder leftOperandbuilder = new LeftOperandBuilder();
        leftOperandbuilder.createNewInstance();
        String subprocessTarget = mapping.getSubprocessTarget();
        leftOperandbuilder.setName(subprocessTarget);
        Optional<Data> targetData = this.modelSearch.findProcess(callActivity.getCalledActivityName() != null ? callActivity.getCalledActivityName().getContent() : null, callActivity.getCalledActivityVersion() != null ? callActivity.getCalledActivityVersion().getContent() : null).map(DataAware::getData).map(Collection::stream).orElse(Stream.empty()).filter(data -> subprocessTarget.equals(data.getName())).findFirst();
        if (targetData.isPresent()) {
            leftOperandbuilder.setType(targetData.get() instanceof BusinessObjectData ? "BUSINESS_DATA" : "DATA");
        } else {
            EList referencedElements = mapping.getProcessSource().getReferencedElements();
            String type = "DATA";
            if (!referencedElements.isEmpty() && Objects.equals("TYPE_VARIABLE", mapping.getProcessSource().getType())) {
                type = this.getLeftOperandTypeForData((EObject)referencedElements.get(0));
            }
            leftOperandbuilder.setType(type);
        }
        opBuilder.setLeftOperand(leftOperandbuilder.done());
        opBuilder.setType(OperatorType.ASSIGNMENT);
        activityBuilder.addDataInputOperation(opBuilder.done());
    }

    private void exportOutputMappingForCallActivities(CallActivity object, CallActivityBuilder activityBuilder) throws InvalidExpressionException {
        for (OutputMapping mapping : object.getOutputMappings()) {
            Data processTarget = mapping.getProcessTarget();
            if (processTarget == null) {
                LOGGER.warn("Skipping output mapping for call activity {} because target data is null", (Object)object.getName());
                continue;
            }
            OperationBuilder opBuilder = new OperationBuilder();
            opBuilder.createNewInstance();
            Data d = (Data)EcoreUtil.copy((EObject)processTarget);
            d.setName(mapping.getSubprocessSource());
            opBuilder.setRightOperand(EngineExpressionUtil.createVariableExpression(d));
            LeftOperandBuilder leftOperandbuilder = new LeftOperandBuilder();
            leftOperandbuilder.createNewInstance();
            leftOperandbuilder.setName(mapping.getProcessTarget().getName());
            leftOperandbuilder.setType(this.getLeftOperandTypeForData((EObject)mapping.getProcessTarget()));
            opBuilder.setLeftOperand(leftOperandbuilder.done());
            opBuilder.setType(OperatorType.ASSIGNMENT);
            activityBuilder.addDataOutputOperation(opBuilder.done());
        }
    }

    private String getLeftOperandTypeForData(EObject data) {
        if (data instanceof BusinessObjectData) {
            return "BUSINESS_DATA";
        }
        return "DATA";
    }

    public Task caseTask(Task task) {
        String actor = null;
        ActorFilter filter = null;
        if (!task.getFilters().isEmpty()) {
            filter = (ActorFilter)task.getFilters().get(0);
        }
        if (task.isOverrideActorsOfTheLane()) {
            if (task.getActor() != null) {
                actor = task.getActor().getName();
            }
        } else {
            Lane lane = (Lane)this.modelSearch.getDirectParentOfType((EObject)task, Lane.class);
            if (lane != null && lane.getActor() != null) {
                actor = lane.getActor().getName();
            }
            if (lane != null && task.getFilters().isEmpty() && !lane.getFilters().isEmpty()) {
                filter = (ActorFilter)lane.getFilters().get(0);
            }
        }
        try {
            UserTaskDefinitionBuilder taskBuilder = this.builder.addUserTask(task.getName(), actor);
            taskBuilder.addPriority(TaskPriority.values()[task.getPriority()].name());
            this.addExpectedDuration(taskBuilder, task);
            this.addUserFilterToTask(taskBuilder, filter);
            this.addTaskContract(taskBuilder, task);
            this.addContext((Object)taskBuilder, task);
            this.handleCommonActivity((Activity)task, (ActivityDefinitionBuilder)taskBuilder);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return task;
    }

    private void addTaskContract(UserTaskDefinitionBuilder taskBuilder, Task task) {
        if (task != null && task.getContract() != null) {
            this.contractBuilder.setEngineBuilder(taskBuilder);
            try {
                this.contractBuilder.build((EObject)task.getContract());
            }
            catch (BuildProcessDefinitionException e) {
                throw new ProcessBuilderException(e);
            }
        }
    }

    private void addUserFilterToTask(UserTaskDefinitionBuilder taskBuilder, ActorFilter filter) throws InvalidExpressionException {
        if (filter != null) {
            UserFilterDefinitionBuilder filterBuilder = taskBuilder.addUserFilter(filter.getName(), filter.getDefinitionId(), filter.getDefinitionVersion());
            for (ConnectorParameter parameter : filter.getConfiguration().getParameters()) {
                Expression inputExpression = EngineExpressionUtil.createExpression(parameter.getExpression());
                if (inputExpression == null) continue;
                filterBuilder.addInput(parameter.getKey(), inputExpression);
            }
        }
    }

    public StartEvent caseStartEvent(StartEvent startEvent) {
        StartEventDefinitionBuilder eventBuilder = this.builder.addStartEvent(startEvent.getName());
        this.addDescription((DescriptionBuilder)eventBuilder, startEvent.getDocumentation());
        return startEvent;
    }

    public FlowElement caseStartTimerEvent(StartTimerEvent startTimer) {
        StartEventDefinitionBuilder startTimerBuilder = this.builder.addStartEvent(startTimer.getName());
        try {
            Expression startConditionExpression = EngineExpressionUtil.createExpression((AbstractExpression)startTimer.getCondition());
            if (this.modelSearch.isInEvenementialSubProcessPool((EObject)startTimer)) {
                TimerType timerType = this.getTimerType((AbstractTimerEvent)startTimer);
                if (timerType != null) {
                    startTimerBuilder.addTimerEventTriggerDefinition(timerType, startConditionExpression);
                }
            } else {
                TimerType type;
                if (startConditionExpression.getReturnType().equals(String.class.getName())) {
                    type = TimerType.CYCLE;
                } else if (startConditionExpression.getReturnType().equals(Date.class.getName())) {
                    type = TimerType.DATE;
                } else if (startConditionExpression.getReturnType().equals(Long.class.getName())) {
                    type = TimerType.DURATION;
                } else {
                    throw new IllegalArgumentException("Unsupported return type " + startConditionExpression.getReturnType() + " for Start timer condition " + startTimer.getName());
                }
                startTimerBuilder.addTimerEventTriggerDefinition(type, startConditionExpression);
            }
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        this.addDescription((DescriptionBuilder)startTimerBuilder, startTimer.getDocumentation());
        return startTimer;
    }

    public FlowElement caseIntermediateCatchTimerEvent(IntermediateCatchTimerEvent timer) {
        IntermediateCatchEventDefinitionBuilder timerBuilder = this.builder.addIntermediateCatchEvent(timer.getName());
        try {
            TimerType timerType = this.getTimerType((AbstractTimerEvent)timer);
            if (timerType != null) {
                timerBuilder.addTimerEventTriggerDefinition(timerType, EngineExpressionUtil.createExpression((AbstractExpression)timer.getCondition()));
            }
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        this.addDescription((DescriptionBuilder)timerBuilder, timer.getDocumentation());
        return timer;
    }

    private TimerType getTimerType(AbstractTimerEvent timer) {
        if (this.isDuration(timer)) {
            return TimerType.DURATION;
        }
        String timerConditionReturnType = timer.getCondition().getReturnType();
        try {
            if (Number.class.isAssignableFrom(Class.forName(timerConditionReturnType))) {
                return TimerType.DURATION;
            }
            if (Date.class.getName().equals(timerConditionReturnType)) {
                return TimerType.DATE;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Timer condition return type '%s' is not supported.", timerConditionReturnType), e);
        }
        return null;
    }

    private boolean isDuration(AbstractTimerEvent timer) {
        org.bonitasoft.bpm.model.expression.Expression exp = timer.getCondition();
        if (exp != null) {
            return EngineFlowElementBuilder.isDuration(exp.getContent());
        }
        return false;
    }

    private static boolean isDuration(String event) {
        long r = -1L;
        try {
            r = Long.parseLong(event);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return String.valueOf(r).equals(event);
    }

    public FlowElement caseEndEvent(EndEvent endEvent) {
        EndEventDefinitionBuilder eventBuilder = this.builder.addEndEvent(endEvent.getName());
        this.addDescription((DescriptionBuilder)eventBuilder, endEvent.getDocumentation());
        return endEvent;
    }

    public Element caseStartErrorEvent(StartErrorEvent startErrorEvent) {
        StartEventDefinitionBuilder eventBuilder = this.builder.addStartEvent(startErrorEvent.getName());
        eventBuilder.addErrorEventTrigger(startErrorEvent.getErrorCode());
        this.addDescription((DescriptionBuilder)eventBuilder, startErrorEvent.getDocumentation());
        return startErrorEvent;
    }

    public Element caseEndErrorEvent(EndErrorEvent endErrorEvent) {
        EndEventDefinitionBuilder eventBuilder = this.builder.addEndEvent(endErrorEvent.getName());
        eventBuilder.addErrorEventTrigger(endErrorEvent.getErrorCode());
        this.addDescription((DescriptionBuilder)eventBuilder, endErrorEvent.getDocumentation());
        return endErrorEvent;
    }

    public FlowElement caseEndTerminatedEvent(EndTerminatedEvent endTerminatedEvent) {
        EndEventDefinitionBuilder eventBuilder = this.builder.addEndEvent(endTerminatedEvent.getName());
        eventBuilder.addTerminateEventTrigger();
        this.addDescription((DescriptionBuilder)eventBuilder, endTerminatedEvent.getDocumentation());
        return endTerminatedEvent;
    }

    public FlowElement caseANDGateway(ANDGateway gateway) {
        GatewayDefinitionBuilder gatewayBuilder = this.builder.addGateway(gateway.getName(), GatewayType.PARALLEL);
        try {
            this.addDisplayTitle(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayDescription(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayDescriptionAfterCompletion(gatewayBuilder, (FlowElement)gateway);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return gateway;
    }

    public FlowElement caseInclusiveGateway(InclusiveGateway gateway) {
        GatewayDefinitionBuilder gatewayBuilder = this.builder.addGateway(gateway.getName(), GatewayType.INCLUSIVE);
        try {
            this.addDisplayTitle(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayDescription(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayDescriptionAfterCompletion(gatewayBuilder, (FlowElement)gateway);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return gateway;
    }

    public FlowElement caseXORGateway(XORGateway gateway) {
        GatewayDefinitionBuilder gatewayBuilder = this.builder.addGateway(gateway.getName(), GatewayType.EXCLUSIVE);
        try {
            this.addDisplayTitle(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayTitle(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayDescription(gatewayBuilder, (FlowElement)gateway);
            this.addDisplayDescriptionAfterCompletion(gatewayBuilder, (FlowElement)gateway);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return gateway;
    }

    private void handleCommonActivity(Activity activity, ActivityDefinitionBuilder taskBuilder) {
        try {
            this.addData((FlowElementBuilder)taskBuilder, (DataAware)activity);
            this.addOperation(taskBuilder, (OperationContainer)activity);
            this.addConnector((FlowElementBuilder)taskBuilder, (ConnectableElement)activity);
            this.addKPIBinding((FlowElementBuilder)taskBuilder, (ConnectableElement)activity);
            this.addDisplayTitle(taskBuilder, (FlowElement)activity);
            this.addDescription((DescriptionBuilder)taskBuilder, activity.getDocumentation());
            this.addDisplayDescription(taskBuilder, (FlowElement)activity);
            this.addDisplayDescriptionAfterCompletion(taskBuilder, (FlowElement)activity);
            this.addMultiInstantiation(taskBuilder, activity);
            this.addBoundaryEvents(taskBuilder, activity);
            this.addDescription((DescriptionBuilder)taskBuilder, activity.getDocumentation());
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
    }

    private void addBoundaryEvents(ActivityDefinitionBuilder taskBuilder, Activity activity) throws InvalidExpressionException {
        for (BoundaryEvent boundaryEvent : activity.getBoundaryIntermediateEvents()) {
            BoundaryEventDefinitionBuilder boundaryEventBuilder = taskBuilder.addBoundaryEvent(boundaryEvent.getName(), !(boundaryEvent instanceof NonInterruptingBoundaryTimerEvent));
            if (boundaryEvent instanceof IntermediateErrorCatchEvent) {
                String errorCode = ((IntermediateErrorCatchEvent)boundaryEvent).getErrorCode();
                if (errorCode != null && errorCode.trim().isEmpty()) {
                    errorCode = null;
                }
                boundaryEventBuilder.addErrorEventTrigger(errorCode);
                continue;
            }
            if (boundaryEvent instanceof BoundaryMessageEvent) {
                CatchMessageEventTriggerDefinitionBuilder catchMessageEventTriggerDefinitionBuilder = boundaryEventBuilder.addMessageEventTrigger(((BoundaryMessageEvent)boundaryEvent).getEvent());
                this.addMessageContent((AbstractCatchMessageEvent)((BoundaryMessageEvent)boundaryEvent), catchMessageEventTriggerDefinitionBuilder);
                this.addMessageCorrelation((AbstractCatchMessageEvent)((BoundaryMessageEvent)boundaryEvent), catchMessageEventTriggerDefinitionBuilder);
                continue;
            }
            if (boundaryEvent instanceof BoundaryTimerEvent) {
                TimerType timerType = this.getTimerType((AbstractTimerEvent)((BoundaryTimerEvent)boundaryEvent));
                if (timerType == null) continue;
                boundaryEventBuilder.addTimerEventTriggerDefinition(timerType, EngineExpressionUtil.createExpression((AbstractExpression)((AbstractTimerEvent)boundaryEvent).getCondition()));
                continue;
            }
            if (!(boundaryEvent instanceof BoundarySignalEvent)) continue;
            boundaryEventBuilder.addSignalEventTrigger(((BoundarySignalEvent)boundaryEvent).getSignalCode());
        }
    }

    private void addMultiInstantiation(ActivityDefinitionBuilder taskBuilder, Activity activity) throws InvalidExpressionException {
        MultiInstanceType multiInstanceType = activity.getType();
        switch (multiInstanceType) {
            case NONE: {
                break;
            }
            case STANDARD: {
                this.addStandardLoop(taskBuilder, (MultiInstantiable)activity);
                break;
            }
            case PARALLEL: 
            case SEQUENTIAL: {
                this.configureMultiInstantiation(taskBuilder, (MultiInstantiable)activity);
                break;
            }
        }
    }

    private void addExpectedDuration(UserTaskDefinitionBuilder taskBuilder, Task task) throws InvalidExpressionException {
        org.bonitasoft.bpm.model.expression.Expression duration = task.getExpectedDuration();
        if (duration != null && duration.hasContent()) {
            taskBuilder.addExpectedDuration(EngineExpressionUtil.createExpression((AbstractExpression)duration));
        }
    }

    private void addDisplayDescription(ActivityDefinitionBuilder builder, FlowElement flowElement) throws InvalidExpressionException {
        Expression exp = EngineExpressionUtil.createExpression((AbstractExpression)flowElement.getDynamicDescription());
        if (exp != null) {
            builder.addDisplayDescription(exp);
        }
    }

    private void addDisplayDescriptionAfterCompletion(ActivityDefinitionBuilder builder, FlowElement flowElement) throws InvalidExpressionException {
        Expression exp = EngineExpressionUtil.createExpression((AbstractExpression)flowElement.getStepSummary());
        if (exp != null) {
            builder.addDisplayDescriptionAfterCompletion(exp);
        }
    }

    private void addDisplayTitle(ActivityDefinitionBuilder builder, FlowElement flowElement) throws InvalidExpressionException {
        Expression exp = EngineExpressionUtil.createExpression((AbstractExpression)flowElement.getDynamicLabel());
        if (exp != null) {
            builder.addDisplayName(exp);
        }
    }

    private void addDisplayDescription(GatewayDefinitionBuilder builder, FlowElement flowElement) throws InvalidExpressionException {
        Expression exp = EngineExpressionUtil.createExpression((AbstractExpression)flowElement.getDynamicDescription());
        if (exp != null) {
            builder.addDisplayDescription(exp);
        }
    }

    private void addDisplayTitle(GatewayDefinitionBuilder builder, FlowElement flowElement) throws InvalidExpressionException {
        Expression exp = EngineExpressionUtil.createExpression((AbstractExpression)flowElement.getDynamicLabel());
        if (exp != null) {
            builder.addDisplayName(exp);
        }
    }

    private void addDisplayDescriptionAfterCompletion(GatewayDefinitionBuilder builder, FlowElement flowElement) throws InvalidExpressionException {
        Expression exp = EngineExpressionUtil.createExpression((AbstractExpression)flowElement.getStepSummary());
        if (exp != null) {
            builder.addDisplayDescriptionAfterCompletion(exp);
        }
    }

    private void addOperation(ActivityDefinitionBuilder builder, OperationContainer activity) throws InvalidExpressionException {
        for (Operation operation : activity.getOperations()) {
            if (operation.getLeftOperand() == null || !operation.getLeftOperand().hasContent() || operation.getRightOperand() == null || operation.getRightOperand().getContent() == null) continue;
            if ("SEARCH_INDEX_TYPE".equals(operation.getLeftOperand().getType())) {
                this.addSearchIndexOperation(builder, activity, operation);
                continue;
            }
            builder.addOperation(EngineExpressionUtil.createOperation(operation));
        }
    }

    private void addSearchIndexOperation(ActivityDefinitionBuilder builder, OperationContainer activity, Operation operation) throws InvalidExpressionException {
        Pool pool = null;
        if (activity.eContainer() instanceof Pool) {
            pool = (Pool)activity.eContainer();
        } else if (activity.eContainer().eContainer() instanceof Pool) {
            pool = (Pool)activity.eContainer().eContainer();
        }
        EList searchIndexList = new ArrayList();
        if (pool != null) {
            searchIndexList = pool.getSearchIndexes();
        }
        int idx = 1;
        for (SearchIndex searchIdx : searchIndexList) {
            if (searchIdx.getName().getContent().equals(operation.getLeftOperand().getName())) {
                builder.addOperation(EngineExpressionUtil.createOperation(operation, EngineExpressionUtil.createLeftOperandIndex(idx)));
                break;
            }
            ++idx;
        }
    }

    private void addStandardLoop(ActivityDefinitionBuilder builder, MultiInstantiable multiInstantiable) throws InvalidExpressionException {
        builder.addLoop(multiInstantiable.getTestBefore().booleanValue(), EngineExpressionUtil.createExpression((AbstractExpression)multiInstantiable.getLoopCondition()), EngineExpressionUtil.createExpression((AbstractExpression)multiInstantiable.getLoopMaximum()));
    }

    private void configureMultiInstantiation(ActivityDefinitionBuilder taskBuilder, MultiInstantiable activity) throws InvalidExpressionException {
        org.bonitasoft.bpm.model.expression.Expression completionCondition = activity.getCompletionCondition();
        if (activity.isUseCardinality()) {
            this.configureCardinalityMultiInstance(taskBuilder, activity, completionCondition);
        } else {
            this.configureCollectionMultiInstance(taskBuilder, activity, completionCondition);
        }
    }

    private void configureCollectionMultiInstance(ActivityDefinitionBuilder taskBuilder, MultiInstantiable activity, org.bonitasoft.bpm.model.expression.Expression completionCondition) throws InvalidExpressionException {
        Data collectionDataToMultiInstantiate = activity.getCollectionDataToMultiInstantiate();
        org.bonitasoft.bpm.model.expression.Expression iteratorExpression = activity.getIteratorExpression();
        if ("MULTIINSTANCE_ITERATOR_TYPE".equals(iteratorExpression.getType()) && iteratorExpression.getName() != null && !iteratorExpression.getName().isEmpty() && activity instanceof DataAware) {
            this.addDataForMultiInstanceIterator(taskBuilder, iteratorExpression, collectionDataToMultiInstantiate);
        }
        if (collectionDataToMultiInstantiate != null) {
            this.addMultiInstanceCollection(taskBuilder, activity, completionCondition, collectionDataToMultiInstantiate, iteratorExpression);
        }
    }

    private void addMultiInstanceCollection(ActivityDefinitionBuilder taskBuilder, MultiInstantiable activity, org.bonitasoft.bpm.model.expression.Expression completionCondition, Data collectionDataToMultiInstantiate, org.bonitasoft.bpm.model.expression.Expression iteratorExpression) throws InvalidExpressionException {
        MultiInstanceLoopCharacteristicsBuilder multiInstanceBuilder = taskBuilder.addMultiInstance(activity.getType() == MultiInstanceType.SEQUENTIAL, collectionDataToMultiInstantiate.getName());
        if (completionCondition != null && completionCondition.getContent() != null && !completionCondition.getContent().isEmpty()) {
            multiInstanceBuilder.addCompletionCondition(EngineExpressionUtil.createExpression((AbstractExpression)completionCondition));
        }
        if (iteratorExpression.getName() != null && !iteratorExpression.getName().isEmpty()) {
            multiInstanceBuilder.addDataInputItemRef(iteratorExpression.getName());
        }
        if (activity.isStoreOutput()) {
            Data listDataContainingOutputResults;
            Data outputData = activity.getOutputData();
            if (outputData != null) {
                multiInstanceBuilder.addDataOutputItemRef(outputData.getName());
            }
            if ((listDataContainingOutputResults = activity.getListDataContainingOutputResults()) != null) {
                multiInstanceBuilder.addLoopDataOutputRef(listDataContainingOutputResults.getName());
            }
        }
    }

    private void configureCardinalityMultiInstance(ActivityDefinitionBuilder taskBuilder, MultiInstantiable activity, org.bonitasoft.bpm.model.expression.Expression completionCondition) throws InvalidExpressionException {
        org.bonitasoft.bpm.model.expression.Expression cardinality = activity.getCardinalityExpression();
        if (cardinality != null && cardinality.getContent() != null && !cardinality.getContent().isEmpty()) {
            MultiInstanceLoopCharacteristicsBuilder multiInstanceBuilder = taskBuilder.addMultiInstance(activity.getType() == MultiInstanceType.SEQUENTIAL, EngineExpressionUtil.createExpression((AbstractExpression)cardinality));
            if (completionCondition != null && completionCondition.getContent() != null && !completionCondition.getContent().isEmpty()) {
                multiInstanceBuilder.addCompletionCondition(EngineExpressionUtil.createExpression((AbstractExpression)completionCondition));
            }
            if (activity.isStoreOutput()) {
                Data listDataContainingOutputResults;
                Data outputData = activity.getOutputData();
                if (outputData != null) {
                    multiInstanceBuilder.addDataOutputItemRef(outputData.getName());
                }
                if ((listDataContainingOutputResults = activity.getListDataContainingOutputResults()) != null) {
                    multiInstanceBuilder.addLoopDataOutputRef(listDataContainingOutputResults.getName());
                }
            }
        }
    }

    private void addDataForMultiInstanceIterator(ActivityDefinitionBuilder taskBuilder, org.bonitasoft.bpm.model.expression.Expression iteratorExpression, Data collectionDataToMultiInstantiate) {
        if (collectionDataToMultiInstantiate instanceof BusinessObjectData) {
            taskBuilder.addBusinessData(iteratorExpression.getName(), iteratorExpression.getReturnType());
        } else {
            FlowElement parentFlowElement = (FlowElement)this.modelSearch.getDirectParentOfType((EObject)iteratorExpression, FlowElement.class);
            if (parentFlowElement instanceof DataAware && !this.isDataAlreadyExists(iteratorExpression, (DataAware)parentFlowElement)) {
                taskBuilder.addData(iteratorExpression.getName(), iteratorExpression.getReturnType(), null);
            }
        }
    }

    private boolean isDataAlreadyExists(org.bonitasoft.bpm.model.expression.Expression iteratorExpression, DataAware parentFlowElement) {
        return parentFlowElement.getData().stream().anyMatch(data -> Objects.equals(data.getName(), iteratorExpression.getName()) && Objects.equals(DataUtil.getTechnicalTypeFor((Data)data), iteratorExpression.getReturnType()));
    }
}

