/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import org.bonitasoft.bonita2bar.process.builder.BuildProcessDefinitionException;
import org.bonitasoft.bonita2bar.process.builder.DocumentGroovyScriptExpressionFactory;
import org.bonitasoft.bonita2bar.process.builder.IDefinitionBuildable;
import org.bonitasoft.bonita2bar.process.builder.ProcessBuilderException;
import org.bonitasoft.bonita2bar.process.expression.EngineExpressionUtil;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.process.Document;
import org.bonitasoft.engine.bpm.process.impl.DocumentListDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.InvalidExpressionException;

public class MultipleDocumentEngineDefinitionBuilder
implements IDefinitionBuildable {
    private final Document document;
    private final ProcessDefinitionBuilder builder;
    private final DocumentGroovyScriptExpressionFactory scriptFactory;

    public MultipleDocumentEngineDefinitionBuilder(Document document, ProcessDefinitionBuilder builder, DocumentGroovyScriptExpressionFactory scriptFactory) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        if (!document.isMultiple()) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.builder = builder;
        this.scriptFactory = scriptFactory;
    }

    @Override
    public void build() throws BuildProcessDefinitionException {
        DocumentListDefinitionBuilder documentListBuilder = this.builder.addDocumentListDefinition(this.document.getName());
        documentListBuilder.addDescription(this.document.getDocumentation());
        try {
            switch (this.document.getDocumentType()) {
                case CONTRACT: {
                    this.addContractInputInitialContent(documentListBuilder);
                    break;
                }
                case INTERNAL: 
                case EXTERNAL: {
                    this.addScriptInitialContent(documentListBuilder);
                    break;
                }
            }
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
    }

    private void addContractInputInitialContent(DocumentListDefinitionBuilder documentListBuilder) throws InvalidExpressionException {
        if (this.document.getContractInput() != null) {
            documentListBuilder.addInitialValue(EngineExpressionUtil.createExpression((AbstractExpression)this.scriptFactory.createMultipleDocumentInitialContentScriptExpression(this.document.getContractInput())));
        }
    }

    private void addScriptInitialContent(DocumentListDefinitionBuilder documentListBuilder) throws InvalidExpressionException {
        Expression initialMultipleContent = this.document.getInitialMultipleContent();
        if (initialMultipleContent != null && initialMultipleContent.hasContent()) {
            documentListBuilder.addInitialValue(EngineExpressionUtil.createExpression((AbstractExpression)initialMultipleContent));
        }
    }
}

