/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import org.bonitasoft.bonita2bar.process.builder.BuildProcessDefinitionException;
import org.bonitasoft.bonita2bar.process.builder.DocumentGroovyScriptExpressionFactory;
import org.bonitasoft.bonita2bar.process.builder.IDefinitionBuildable;
import org.bonitasoft.bonita2bar.process.builder.ProcessBuilderException;
import org.bonitasoft.bonita2bar.process.expression.EngineExpressionUtil;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.process.Document;
import org.bonitasoft.engine.bpm.process.impl.DocumentDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.InvalidExpressionException;

public class SingleDocumentEngineDefinitionBuilder
implements IDefinitionBuildable {
    private final Document document;
    private final ProcessDefinitionBuilder builder;
    private final DocumentGroovyScriptExpressionFactory scriptFactory;

    public SingleDocumentEngineDefinitionBuilder(Document document, ProcessDefinitionBuilder builder, DocumentGroovyScriptExpressionFactory scriptFactory) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        if (document.isMultiple()) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.builder = builder;
        this.scriptFactory = scriptFactory;
    }

    @Override
    public void build() throws BuildProcessDefinitionException {
        try {
            DocumentDefinitionBuilder documentBuilder = this.builder.addDocumentDefinition(this.document.getName());
            documentBuilder.addDescription(this.document.getDocumentation());
            this.addDocumentMimeType(this.document, documentBuilder);
            this.addDocumentInitialContent(this.document, documentBuilder);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
    }

    private void addDocumentMimeType(Document document, DocumentDefinitionBuilder documentBuilder) {
        Expression mimeType = document.getMimeType();
        if (mimeType != null && mimeType.hasContent()) {
            documentBuilder.addMimeType(mimeType.getContent());
        }
    }

    private void addDocumentInitialContent(Document document, DocumentDefinitionBuilder documentBuilder) throws InvalidExpressionException {
        switch (document.getDocumentType()) {
            case INTERNAL: {
                this.addLocalFileContent(document, documentBuilder);
                break;
            }
            case EXTERNAL: {
                this.addUrlContent(document, documentBuilder);
                break;
            }
            case CONTRACT: {
                this.addContractInputContent(document, documentBuilder);
                break;
            }
        }
    }

    private void addContractInputContent(Document document, DocumentDefinitionBuilder documentBuilder) throws InvalidExpressionException {
        if (document.getContractInput() != null) {
            documentBuilder.addInitialValue(EngineExpressionUtil.createExpression((AbstractExpression)this.scriptFactory.createSingleDocumentInitialContentScriptExpression(document.getContractInput())));
        }
    }

    private void addUrlContent(Document document, DocumentDefinitionBuilder documentBuilder) {
        Expression url = document.getUrl();
        if (url != null && url.hasContent()) {
            documentBuilder.addUrl(url.getContent());
        }
    }

    private void addLocalFileContent(Document document, DocumentDefinitionBuilder documentBuilder) {
        String defaultValueIdOfDocumentStore = document.getDefaultValueIdOfDocumentStore();
        if (defaultValueIdOfDocumentStore != null && !defaultValueIdOfDocumentStore.isEmpty()) {
            documentBuilder.addFile(defaultValueIdOfDocumentStore);
            documentBuilder.addContentFileName(defaultValueIdOfDocumentStore);
        }
    }
}

