/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.expression;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.bonita2bar.process.expression.ComparisonExpressionConverter;
import org.bonitasoft.bonita2bar.process.expression.IExpressionConverter;
import org.bonitasoft.bpm.connector.model.definition.Output;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.ListExpression;
import org.bonitasoft.bpm.model.expression.TableExpression;
import org.bonitasoft.bpm.model.parameter.Parameter;
import org.bonitasoft.bpm.model.process.BusinessObjectData;
import org.bonitasoft.bpm.model.process.ContractInput;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.Document;
import org.bonitasoft.bpm.model.process.util.DataUtil;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.LeftOperandBuilder;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.OperatorType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EngineExpressionUtil {
    public static final String PAGEFLOW_DATASOURCE = "PAGEFLOW";
    private static List<IExpressionConverter> converters;

    private EngineExpressionUtil() {
    }

    public static Operation createOperation(org.bonitasoft.bpm.model.expression.Operation operation) throws InvalidExpressionException {
        return EngineExpressionUtil.createOperation(operation, EngineExpressionUtil.createLeftOperand(operation.getLeftOperand()));
    }

    public static void addConverter(IExpressionConverter converter) {
        if (converters == null) {
            converters = new ArrayList<IExpressionConverter>();
        }
        converters.add(converter);
    }

    public static boolean hasConverter(Class<?> converterType) {
        if (converters == null) {
            return false;
        }
        return converters.stream().anyMatch(converterType::isInstance);
    }

    public static Operation createOperation(org.bonitasoft.bpm.model.expression.Operation operation, LeftOperand leftOperand) throws InvalidExpressionException {
        OperationBuilder builder = new OperationBuilder();
        builder.createNewInstance();
        builder.setType(EngineExpressionUtil.getEngineOperator(operation));
        builder.setOperator(operation.getOperator().getExpression());
        EList operatorInputTypes = operation.getOperator().getInputTypes();
        if (!operatorInputTypes.isEmpty()) {
            builder.setOperatorInputType((String)operatorInputTypes.get(0));
        }
        builder.setRightOperand(EngineExpressionUtil.createExpression((AbstractExpression)operation.getRightOperand()));
        builder.setLeftOperand(leftOperand);
        return builder.done();
    }

    public static OperatorType getEngineOperator(org.bonitasoft.bpm.model.expression.Operation operation) {
        String type = operation.getOperator().getType();
        return EngineExpressionUtil.getEngineOperator(type);
    }

    public static OperatorType getEngineOperator(String type) {
        if (OperatorType.DOCUMENT_CREATE_UPDATE.name().equals(type)) {
            return OperatorType.ASSIGNMENT;
        }
        if ("DOCUMENT_LIST_SET".equals(type)) {
            return OperatorType.ASSIGNMENT;
        }
        if (OperatorType.STRING_INDEX.name().equals(type)) {
            return OperatorType.ASSIGNMENT;
        }
        if ("CREATE_BUSINESS_DATA".equals(type)) {
            return OperatorType.ASSIGNMENT;
        }
        if ("BUSINESS_DATA_JAVA_SETTER".equals(type)) {
            return OperatorType.JAVA_METHOD;
        }
        if ("ATTACH_EXISTING_BUSINESS_DATA".equals(type)) {
            return OperatorType.ASSIGNMENT;
        }
        return OperatorType.valueOf((String)type);
    }

    public static Operation createOperation(org.bonitasoft.bpm.model.expression.Operation operation, boolean isExternal) throws InvalidExpressionException {
        return EngineExpressionUtil.createOperation(operation, EngineExpressionUtil.createLeftOperand(operation.getLeftOperand(), isExternal));
    }

    public static String getOperatorType(org.bonitasoft.bpm.model.expression.Operation operation) {
        if ("JAVA_METHOD".equals(operation.getOperator().getType()) && operation.getLeftOperand() != null && !operation.getLeftOperand().getReferencedElements().isEmpty() && operation.getLeftOperand().getReferencedElements().get(0) instanceof BusinessObjectData) {
            return "BUSINESS_DATA_JAVA_SETTER";
        }
        if ("ASSIGNMENT".equals(operation.getOperator().getType()) && operation.getLeftOperand() != null && !operation.getLeftOperand().getReferencedElements().isEmpty() && operation.getLeftOperand().getReferencedElements().get(0) instanceof BusinessObjectData) {
            return "ATTACH_EXISTING_BUSINESS_DATA";
        }
        return operation.getOperator().getType();
    }

    public static Operation createOperationForMessageContent(org.bonitasoft.bpm.model.expression.Operation operation) throws InvalidExpressionException {
        OperationBuilder builder = new OperationBuilder();
        builder.createNewInstance();
        builder.setType(EngineExpressionUtil.getEngineOperator(operation));
        builder.setOperator(operation.getOperator().getExpression());
        EList operatorInputTypes = operation.getOperator().getInputTypes();
        if (!operatorInputTypes.isEmpty()) {
            builder.setOperatorInputType((String)operatorInputTypes.get(0));
        }
        Expression rightOperand = (Expression)EcoreUtil.copy((EObject)operation.getRightOperand());
        rightOperand.setType("TYPE_VARIABLE");
        if (!operatorInputTypes.isEmpty()) {
            rightOperand.setReturnType((String)operatorInputTypes.get(0));
        } else {
            rightOperand.setReturnType(operation.getLeftOperand().getReturnType());
        }
        builder.setRightOperand(EngineExpressionUtil.createExpression((AbstractExpression)rightOperand));
        builder.setLeftOperand(EngineExpressionUtil.createLeftOperand(operation.getLeftOperand()));
        return builder.done();
    }

    private static List<org.bonitasoft.engine.expression.Expression> createDependenciesList(Expression expression) throws InvalidExpressionException {
        ArrayList<org.bonitasoft.engine.expression.Expression> result = new ArrayList<org.bonitasoft.engine.expression.Expression>();
        if (expression.getType().equals("TYPE_READ_ONLY_SCRIPT") || expression.getType().equals("TYPE_PATTERN") || expression.getType().equals("TYPE_JAVA_METHOD_CALL") || expression.getType().equals("TYPE_XPATH_READ")) {
            ExpressionBuilder expBuilder = new ExpressionBuilder();
            for (EObject element : expression.getReferencedElements()) {
                EngineExpressionUtil.addDependencyExpression(result, expBuilder, element);
            }
        }
        return result;
    }

    private static void addDependencyExpression(List<org.bonitasoft.engine.expression.Expression> result, ExpressionBuilder expBuilder, EObject element) throws InvalidExpressionException {
        if (element instanceof Data) {
            result.add(EngineExpressionUtil.createVariableExpression((Data)element));
        } else if (element instanceof Output) {
            result.add(EngineExpressionUtil.createConnectorOutputExpression((Output)element));
        } else if (element instanceof Parameter) {
            result.add(EngineExpressionUtil.createParameterExpression((Parameter)element));
        } else if (element instanceof Expression) {
            result.add(EngineExpressionUtil.createExpression((AbstractExpression)((Expression)element)));
        } else if (element instanceof Document) {
            if (((Document)element).isMultiple()) {
                result.add(expBuilder.createDocumentListExpression(((Document)element).getName()));
            } else {
                result.add(expBuilder.createDocumentReferenceExpression(((Document)element).getName()));
            }
        } else if (element instanceof ContractInput) {
            result.add(expBuilder.createContractInputExpression(((ContractInput)element).getName(), EngineExpressionUtil.getContractInputReturnType((ContractInput)element)));
        }
    }

    private static String getContractInputReturnType(ContractInput input) {
        if (input == null) {
            return null;
        }
        String returnType = input.getJavaType();
        if (input.isMultiple()) {
            returnType = List.class.getName();
        }
        return returnType;
    }

    private static org.bonitasoft.engine.expression.Expression createParameterExpression(Parameter parameter) throws InvalidExpressionException {
        ExpressionBuilder exp = new ExpressionBuilder();
        exp.createNewInstance(parameter.getName());
        exp.setContent(parameter.getName());
        exp.setExpressionType(ExpressionType.TYPE_PARAMETER);
        exp.setReturnType(parameter.getTypeClassname());
        return exp.done();
    }

    public static LeftOperand createLeftOperand(Expression leftOperand) {
        return EngineExpressionUtil.createLeftOperand(leftOperand, false);
    }

    public static LeftOperand createLeftOperand(Expression leftOperand, boolean isExternal) {
        LeftOperandBuilder builder = new LeftOperandBuilder();
        builder.createNewInstance();
        builder.setName(leftOperand.getName());
        builder.setType(EngineExpressionUtil.getLeftOperandType(leftOperand, isExternal));
        return builder.done();
    }

    public static String getLeftOperandType(Expression leftOperand, boolean external) {
        if (external) {
            return "EXTERNAL_DATA";
        }
        String leftOperandType = leftOperand.getType();
        if ("TYPE_DOCUMENT".equals(leftOperandType) || "DOCUMENT_REF_TYPE".equals(leftOperandType)) {
            return EngineExpressionUtil.getLeftOperandDocumentType(leftOperand);
        }
        if ("TYPE_VARIABLE".equals(leftOperandType)) {
            return EngineExpressionUtil.getLeftOperandVariableType(leftOperand, external);
        }
        if ("SEARCH_INDEX_TYPE".equals(leftOperandType)) {
            return "SEARCH_INDEX";
        }
        return leftOperand.getType();
    }

    private static String getLeftOperandDocumentType(Expression leftOperand) {
        EObject referencedElement;
        if (!leftOperand.getReferencedElements().isEmpty() && (referencedElement = (EObject)leftOperand.getReferencedElements().get(0)) instanceof Document) {
            if (((Document)referencedElement).isMultiple()) {
                return "DOCUMENT_LIST";
            }
            return "DOCUMENT";
        }
        return "DOCUMENT";
    }

    private static String getLeftOperandVariableType(Expression leftOperand, boolean external) {
        EObject referencedElement;
        EList referencedElements = leftOperand.getReferencedElements();
        if (referencedElements != null && !referencedElements.isEmpty() && (referencedElement = (EObject)referencedElements.get(0)) instanceof Data) {
            Data data = (Data)referencedElement;
            if (data.isTransient()) {
                return "TRANSIENT_DATA";
            }
            if (data instanceof BusinessObjectData) {
                return "BUSINESS_DATA";
            }
            if (external || PAGEFLOW_DATASOURCE.equals(data.getDatasourceId())) {
                return "EXTERNAL_DATA";
            }
        }
        return "DATA";
    }

    public static LeftOperand createLeftOperandIndex(int i) {
        LeftOperandBuilder builder = new LeftOperandBuilder();
        builder.createNewInstance();
        builder.setName(String.valueOf(i));
        builder.setType("SEARCH_INDEX");
        return builder.done();
    }

    public static org.bonitasoft.engine.expression.Expression createExpression(AbstractExpression expression) throws InvalidExpressionException {
        if (expression == null) {
            return null;
        }
        if (expression instanceof Expression) {
            return EngineExpressionUtil.buildSimpleEngineExpressionWithName(((Expression)expression).getName(), (Expression)expression);
        }
        if (expression instanceof ListExpression) {
            return EngineExpressionUtil.buildListEngineExpression(expression);
        }
        if (expression instanceof TableExpression) {
            return EngineExpressionUtil.buildTableEngineExpression(expression);
        }
        throw new IllegalArgumentException("Unsupported expression convertion");
    }

    protected static org.bonitasoft.engine.expression.Expression buildTableEngineExpression(AbstractExpression expression) throws InvalidExpressionException {
        ExpressionBuilder exp = new ExpressionBuilder();
        ArrayList expressions = new ArrayList();
        StringBuilder expressionNames = new StringBuilder("Table of expression containing the following expressions: [");
        for (ListExpression listExpression : ((TableExpression)expression).getExpressions()) {
            ArrayList<org.bonitasoft.engine.expression.Expression> engineExpressionList = new ArrayList<org.bonitasoft.engine.expression.Expression>();
            expressionNames.append("(");
            for (Expression simpleExpression : listExpression.getExpressions()) {
                org.bonitasoft.engine.expression.Expression createExpression = EngineExpressionUtil.createExpression((AbstractExpression)simpleExpression);
                if (createExpression == null) continue;
                engineExpressionList.add(createExpression);
                expressionNames.append(createExpression.getName());
                expressionNames.append(",");
            }
            expressionNames.append(")");
            expressions.add(engineExpressionList);
        }
        expressionNames.append("].");
        return exp.createListOfListExpression(expressionNames.toString(), expressions);
    }

    protected static org.bonitasoft.engine.expression.Expression buildListEngineExpression(AbstractExpression expression) throws InvalidExpressionException {
        ExpressionBuilder exp = new ExpressionBuilder();
        ArrayList<org.bonitasoft.engine.expression.Expression> expressions = new ArrayList<org.bonitasoft.engine.expression.Expression>();
        StringBuilder expressionNames = new StringBuilder("List of expression containing the following expressions: (");
        for (Expression simpleExpression : ((ListExpression)expression).getExpressions()) {
            org.bonitasoft.engine.expression.Expression createExpression = EngineExpressionUtil.createExpression((AbstractExpression)simpleExpression);
            if (createExpression != null) {
                expressions.add(createExpression);
                expressionNames.append(createExpression.getName());
                expressionNames.append(",");
                continue;
            }
            org.bonitasoft.engine.expression.Expression nullExpression = EngineExpressionUtil.createNullExpression();
            expressions.add(nullExpression);
            expressionNames.append(nullExpression.getName());
            expressionNames.append(",");
        }
        expressionNames.append(").");
        return exp.createListExpression(expressionNames.toString(), expressions);
    }

    private static org.bonitasoft.engine.expression.Expression buildSimpleEngineExpressionWithName(String name, Expression expression) throws InvalidExpressionException {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        if ((name == null || name.isEmpty()) && ((name = expression.getName()) == null || name.isEmpty())) {
            name = "<empty-name>";
        }
        return EngineExpressionUtil.buildSimpleEngineExpression(expressionBuilder.createNewInstance(name), expression);
    }

    private static org.bonitasoft.engine.expression.Expression buildSimpleEngineExpression(ExpressionBuilder expressionBuilder, Expression expression) throws InvalidExpressionException {
        if (!expression.hasContent()) {
            return null;
        }
        IExpressionConverter converter = EngineExpressionUtil.getConverter(expression);
        if (converter != null) {
            return converter.convert(expression);
        }
        String type = expression.getType();
        if ("TYPE_PATTERN".equals(type)) {
            return EngineExpressionUtil.createPatternExpression(expressionBuilder, expression);
        }
        if ("TYPE_DOCUMENT".equals(type)) {
            return EngineExpressionUtil.createDocumentReferenceExpression(expressionBuilder, expression);
        }
        if ("TYPE_DOCUMENT_LIST".equals(type)) {
            return expressionBuilder.createDocumentListExpression(expression.getName());
        }
        if ("DOCUMENT_REF_TYPE".equals(type)) {
            return EngineExpressionUtil.createEngineExpressionForDocumentRef(expressionBuilder, expression);
        }
        if ("TYPE_XPATH_READ".equals(type)) {
            return EngineExpressionUtil.createXPATHExpression(expressionBuilder, expression);
        }
        if ("TYPE_QUERY_BUSINESS_DATA".equals(type)) {
            return EngineExpressionUtil.createQueryExpression(expressionBuilder, expression);
        }
        expressionBuilder.setContent(expression.getContent().replace("\r", "\n"));
        ExpressionType engineExpressionType = EngineExpressionUtil.toEngineExpressionType(expression);
        expressionBuilder.setExpressionType(engineExpressionType);
        expressionBuilder.setInterpreter(ExpressionType.TYPE_READ_ONLY_SCRIPT.equals((Object)engineExpressionType) ? expression.getInterpreter() : "");
        expressionBuilder.setReturnType(expression.getReturnType());
        expressionBuilder.setDependencies(EngineExpressionUtil.createDependenciesList(expression));
        return expressionBuilder.done();
    }

    private static org.bonitasoft.engine.expression.Expression createDocumentReferenceExpression(ExpressionBuilder expressionBuilder, Expression expression) throws InvalidExpressionException {
        Document document;
        EList referencedElements = expression.getReferencedElements();
        if (!referencedElements.isEmpty() && (document = (Document)referencedElements.get(0)).isMultiple()) {
            return expressionBuilder.createDocumentListExpression(expression.getName());
        }
        return expressionBuilder.createDocumentReferenceExpression(expression.getName());
    }

    private static IExpressionConverter getConverter(Expression expression) {
        if (converters == null) {
            converters = new ArrayList<IExpressionConverter>();
            converters.add(new ComparisonExpressionConverter());
        }
        for (IExpressionConverter converter : converters) {
            if (!converter.appliesTo(expression)) continue;
            return converter;
        }
        return null;
    }

    private static org.bonitasoft.engine.expression.Expression createEngineExpressionForDocumentRef(ExpressionBuilder expressionBuilder, Expression expression) throws InvalidExpressionException {
        EObject referencedElement;
        String content = expression.getContent();
        EList referencedElements = expression.getReferencedElements();
        if (!referencedElements.isEmpty() && (referencedElement = (EObject)referencedElements.get(0)) instanceof Document && ((Document)referencedElement).isMultiple()) {
            return expressionBuilder.createDocumentListExpression(expression.getName());
        }
        return EngineExpressionUtil.createConstantExpression(content, content, String.class.getName());
    }

    private static org.bonitasoft.engine.expression.Expression createQueryExpression(ExpressionBuilder expressionBuilder, Expression simpleExpression) throws InvalidExpressionException {
        ArrayList<org.bonitasoft.engine.expression.Expression> dependencies = new ArrayList<org.bonitasoft.engine.expression.Expression>();
        for (EObject param : simpleExpression.getReferencedElements()) {
            org.bonitasoft.engine.expression.Expression paramExpression;
            EList referencedElements;
            if (!(param instanceof Expression) || (referencedElements = ((Expression)param).getReferencedElements()).isEmpty() || (paramExpression = EngineExpressionUtil.buildSimpleEngineExpressionWithName(((Expression)param).getName(), (Expression)referencedElements.get(0))) == null) continue;
            dependencies.add(paramExpression);
        }
        return expressionBuilder.createQueryBusinessDataExpression(simpleExpression.getName(), simpleExpression.getName(), simpleExpression.getReturnType(), dependencies.toArray(new org.bonitasoft.engine.expression.Expression[dependencies.size()]));
    }

    private static org.bonitasoft.engine.expression.Expression createNullExpression() throws InvalidExpressionException {
        return new ExpressionBuilder().createGroovyScriptExpression("ExpressionNotDefinedSetAsNull", "null", Object.class.getName());
    }

    public static org.bonitasoft.engine.expression.Expression createPatternExpression(ExpressionBuilder exp, Expression simpleExpression) throws InvalidExpressionException {
        exp.createNewInstance("<pattern-expression>");
        exp.setContent(simpleExpression.getContent());
        ExpressionType engineExpressionType = EngineExpressionUtil.toEngineExpressionType(simpleExpression);
        exp.setExpressionType(engineExpressionType);
        if (ExpressionType.TYPE_READ_ONLY_SCRIPT == engineExpressionType) {
            exp.setInterpreter(simpleExpression.getInterpreter());
        } else {
            exp.setInterpreter("");
        }
        exp.setReturnType(simpleExpression.getReturnType());
        List<org.bonitasoft.engine.expression.Expression> dependenciesList = EngineExpressionUtil.createDependenciesList(simpleExpression);
        ArrayList<org.bonitasoft.engine.expression.Expression> toRemove = new ArrayList<org.bonitasoft.engine.expression.Expression>();
        for (org.bonitasoft.engine.expression.Expression expression : dependenciesList) {
            if (simpleExpression.getContent().contains("${" + expression.getName() + "}")) continue;
            toRemove.add(expression);
        }
        dependenciesList.removeAll(toRemove);
        exp.setDependencies(dependenciesList);
        return exp.done();
    }

    static ExpressionType toEngineExpressionType(Expression expression) {
        String type = expression.getType();
        if ("CONNECTOR_OUTPUT_TYPE".equals(type)) {
            return ExpressionType.TYPE_INPUT;
        }
        if ("DOCUMENT_REF_TYPE".equals(type)) {
            return EngineExpressionUtil.toEngineExpressionTypeFoDocumentRef(expression);
        }
        if ("MULTIINSTANCE_ITERATOR_TYPE".equals(type)) {
            return ExpressionType.TYPE_VARIABLE;
        }
        if ("TYPE_VARIABLE".equals(type) && !expression.getReferencedElements().isEmpty()) {
            EObject reference = (EObject)expression.getReferencedElements().get(0);
            if (!(reference instanceof Data)) {
                throw new IllegalArgumentException(String.format("Incompatible expression type found. Expecting a %s but found a %s for expression %s", Data.class.getSimpleName(), reference.getClass().getSimpleName(), expression.getName()));
            }
            Data data = (Data)reference;
            String ds = data.getDatasourceId();
            if (PAGEFLOW_DATASOURCE.equals(ds)) {
                return ExpressionType.TYPE_INPUT;
            }
            if (data.isTransient()) {
                return ExpressionType.TYPE_TRANSIENT_VARIABLE;
            }
            if (data instanceof BusinessObjectData) {
                return ExpressionType.TYPE_BUSINESS_DATA;
            }
        }
        return ExpressionType.valueOf((String)expression.getType());
    }

    private static ExpressionType toEngineExpressionTypeFoDocumentRef(Expression expression) {
        EObject referencedElement;
        if (!expression.getReferencedElements().isEmpty() && (referencedElement = (EObject)expression.getReferencedElements().get(0)) instanceof Document && ((Document)referencedElement).isMultiple()) {
            return ExpressionType.TYPE_DOCUMENT_LIST;
        }
        return ExpressionType.TYPE_CONSTANT;
    }

    private static org.bonitasoft.engine.expression.Expression createConnectorOutputExpression(Output element) throws InvalidExpressionException {
        ExpressionBuilder exp = new ExpressionBuilder();
        exp.createNewInstance(element.getName());
        exp.setContent(element.getName());
        exp.setExpressionType(ExpressionType.TYPE_INPUT);
        exp.setReturnType(element.getType());
        return exp.done();
    }

    private static org.bonitasoft.engine.expression.Expression createXPATHExpression(ExpressionBuilder exp, Expression expression) throws InvalidExpressionException {
        exp.createNewInstance(expression.getName()).setExpressionType(ExpressionType.TYPE_XPATH_READ).setContent(expression.getContent());
        exp.setReturnType(expression.getReturnType());
        exp.setDependencies(EngineExpressionUtil.createDependenciesList(expression));
        return exp.done();
    }

    public static org.bonitasoft.engine.expression.Expression createVariableExpression(Data element) throws InvalidExpressionException {
        String datasourceId = element.getDatasourceId();
        ExpressionType type = ExpressionType.TYPE_VARIABLE;
        if (element instanceof BusinessObjectData) {
            type = ExpressionType.TYPE_BUSINESS_DATA;
        }
        if (PAGEFLOW_DATASOURCE.equals(datasourceId)) {
            type = ExpressionType.TYPE_INPUT;
        }
        if (element.isTransient()) {
            type = ExpressionType.TYPE_TRANSIENT_VARIABLE;
        }
        ExpressionBuilder exp = new ExpressionBuilder();
        exp.createNewInstance(element.getName());
        exp.setContent(element.getName());
        exp.setExpressionType(type);
        exp.setReturnType(DataUtil.getTechnicalTypeFor((Data)element));
        return exp.done();
    }

    public static org.bonitasoft.engine.expression.Expression createEmptyListExpression() throws InvalidExpressionException {
        ExpressionBuilder exp = new ExpressionBuilder();
        exp.createNewInstance("<empty-name>");
        exp.setContent("[]");
        exp.setExpressionType(ExpressionType.TYPE_READ_ONLY_SCRIPT);
        exp.setInterpreter("GROOVY");
        exp.setReturnType(List.class.getName());
        exp.setDependencies(new ArrayList());
        return exp.done();
    }

    private static org.bonitasoft.engine.expression.Expression createConstantExpression(String name, String content, String returnType) throws InvalidExpressionException {
        ExpressionBuilder exp = new ExpressionBuilder();
        exp.createNewInstance(name);
        exp.setContent(content);
        exp.setExpressionType(ExpressionType.TYPE_CONSTANT);
        exp.setReturnType(returnType);
        return exp.done();
    }
}

