/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.bonitasoft.bonita2bpmn.transfo.ConnectorTransformationXSLProvider;
import org.bonitasoft.bonita2bpmn.transfo.ModelRegistry;
import org.bonitasoft.bpm.connector.model.definition.ConnectorDefinition;
import org.bonitasoft.bpm.connector.model.definition.DocumentRoot;
import org.bonitasoft.bpm.model.util.FileUtil;
import org.eclipse.emf.ecore.resource.Resource;
import org.omg.spec.bpmn.model.ModelFactory;
import org.omg.spec.bpmn.model.TImport;
import org.omg.spec.bpmn.model.TInterface;
import org.omg.spec.bpmn.model.TItemDefinition;
import org.omg.spec.bpmn.model.TMessage;
import org.omg.spec.bpmn.model.TOperation;

public class ConnectorDefinitionTransformer {
    static final String XMLNS_HTTP_BONITASOFT_COM_BONITA_CONNECTOR_DEFINITION = "bonitaConnector";
    private Path connectorDefFolder;
    private Templates xslTemplate;
    private Supplier<List<ConnectorDefinition>> connectorDefContextProvider;
    private ConnectorTransformationXSLProvider connectorXSLProvider;
    private ModelRegistry modelRegistry;

    ConnectorDefinitionTransformer(Path connectorDefFolder, Supplier<List<ConnectorDefinition>> connectorDefContextProvider, ConnectorTransformationXSLProvider connectorXSLProvider, ModelRegistry modelRegistry) {
        this.connectorDefFolder = connectorDefFolder;
        this.connectorDefContextProvider = connectorDefContextProvider;
        this.connectorXSLProvider = connectorXSLProvider;
        this.modelRegistry = modelRegistry;
    }

    public String generateConnectorInputItemDef(String connectorDefId) {
        return connectorDefId + "ConnectorInput";
    }

    public String generateConnectorOutputItemDef(String connectorDefId) {
        return connectorDefId + "ConnectorOutput";
    }

    public void handleBonitaConnectorDefinition(String connectorDefId) {
        try {
            Path connectorDefFile = this.createXSDForConnectorDef(connectorDefId);
            this.addConnectorDefInXsdIfNotYetIncluded(connectorDefFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create xsd for connector.", e);
        }
        TMessage tMessageInputBonitaConnector = this.createConnectorDefInput(connectorDefId);
        TMessage tMessageOutputBonitaConnector = this.createConnectorDefOutput(connectorDefId);
        String interfaceId = connectorDefId + "_Bonita_Connector_Interface";
        this.modelRegistry.getDefinitions().getRootElement().stream().filter(TInterface.class::isInstance).map(TInterface.class::cast).filter(i -> interfaceId.equals(i.getId())).findFirst().ifPresentOrElse(id -> {}, () -> {
            TInterface tInterfaceBonitaConnector = ModelFactory.eINSTANCE.createTInterface();
            tInterfaceBonitaConnector.setName(interfaceId);
            tInterfaceBonitaConnector.setId(interfaceId);
            TOperation tOperationConnector = ModelFactory.eINSTANCE.createTOperation();
            tOperationConnector.setId("Exec" + connectorDefId);
            tOperationConnector.setName("Exec" + connectorDefId);
            tOperationConnector.setInMessageRef(QName.valueOf(tMessageInputBonitaConnector.getId()));
            tOperationConnector.setOutMessageRef(QName.valueOf(tMessageOutputBonitaConnector.getId()));
            tInterfaceBonitaConnector.getOperation().add((Object)tOperationConnector);
            this.modelRegistry.getDefinitions().getRootElement().add((Object)tInterfaceBonitaConnector);
        });
    }

    private Path generateXSDForConnector(Path connectorToTransformWC, Path xsdFile) throws IOException {
        Object xsltSource22;
        if (this.xslTemplate == null) {
            TransformerFactory transFact = TransformerFactory.newInstance();
            File xsltFileoriginal = this.connectorXSLProvider.getConnectorXSLFile();
            xsltSource22 = new StreamSource(xsltFileoriginal);
            try {
                this.xslTemplate = transFact.newTemplates((Source)xsltSource22);
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e);
            }
        }
        String content = Files.readString(connectorToTransformWC, StandardCharsets.UTF_8);
        content = content.replaceAll("xmlns:definition=\"http://www.bonitasoft.org/ns/connector/definition/6.1\"", "xmlns=\"http://www.bonitasoft.org/ns/connector/definition/6.1\" xmlns:definition=\"http://www.bonitasoft.org/ns/connector/definition/6.1\"");
        Files.writeString(connectorToTransformWC, (CharSequence)content, new OpenOption[0]);
        StreamSource xmlSource = new StreamSource(connectorToTransformWC.toFile());
        if (!Files.exists(this.connectorDefFolder, new LinkOption[0])) {
            Files.createDirectories(this.connectorDefFolder, new FileAttribute[0]);
        }
        try {
            Path path;
            block19: {
                xsltSource22 = null;
                Object var6_9 = null;
                OutputStream stream = Files.newOutputStream(xsdFile, new OpenOption[0]);
                try {
                    StreamResult result = new StreamResult(stream);
                    Transformer transformer = this.xslTemplate.newTransformer();
                    transformer.setParameter("indent", true);
                    transformer.transform(xmlSource, result);
                    path = xsdFile;
                    if (stream == null) break block19;
                }
                catch (Throwable xsltSource22) {
                    try {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            throw xsltSource22;
                        }
                        catch (Throwable throwable) {
                            if (xsltSource22 == null) {
                                xsltSource22 = throwable;
                            } else if (xsltSource22 != throwable) {
                                ((Throwable)xsltSource22).addSuppressed(throwable);
                            }
                            throw xsltSource22;
                        }
                    }
                    catch (TransformerException e) {
                        throw new IOException(e);
                    }
                }
                stream.close();
            }
            return path;
        }
        finally {
            Files.delete(connectorToTransformWC);
        }
    }

    private Path createXSDForConnectorDef(String connectorDefId) throws IOException {
        Path tmpDir = Files.createDirectories(Paths.get("2bpmnExport", new String[0]), new FileAttribute[0]);
        Path connectorDefFile = this.connectorDefContextProvider.get().stream().filter(def -> Objects.equals(def.getId(), connectorDefId)).map(def -> {
            try {
                return this.createTmpDefinitionFile((ConnectorDefinition)def, tmpDir);
            }
            catch (IOException e) {
                this.modelRegistry.addError(e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
        try {
            if (connectorDefFile != null) {
                Path path = this.generateXSDForConnector(connectorDefFile, this.connectorDefFolder.resolve(connectorDefId + ".xsd"));
                return path;
            }
            this.modelRegistry.addError("The connector with id " + connectorDefId + " was not found.");
            return null;
        }
        finally {
            FileUtil.deleteDir((Path)tmpDir);
        }
    }

    private Path createTmpDefinitionFile(ConnectorDefinition definition, Path tmpDir) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        options.put("XML_VERSION", "1.0");
        Path tmpFile = Files.createTempFile(tmpDir, definition.getId(), ".def", new FileAttribute[0]);
        Resource resource = definition.eResource();
        DocumentRoot docRoot = (DocumentRoot)resource.getContents().get(0);
        docRoot.getXMLNSPrefixMap().clear();
        Throwable throwable = null;
        Object var8_9 = null;
        try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
            resource.save(os, options);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tmpFile;
    }

    private void addConnectorDefInXsdIfNotYetIncluded(Path connectorDefFile) {
        if (connectorDefFile != null) {
            boolean alreadyImported = false;
            String locationImport = String.valueOf(this.connectorDefFolder.getFileName()) + "/" + connectorDefFile.getFileName().toString();
            for (TImport imported : this.modelRegistry.getDefinitions().getImport()) {
                if (!imported.getLocation().equals(locationImport)) continue;
                alreadyImported = true;
                break;
            }
            if (!alreadyImported) {
                TImport tImportBonitaConnector = ModelFactory.eINSTANCE.createTImport();
                tImportBonitaConnector.setImportType("http://www.w3.org/2001/XMLSchema");
                tImportBonitaConnector.setLocation(locationImport);
                tImportBonitaConnector.setNamespace("http://www.bonitasoft.org/studio/connector/definition/6.1");
                this.modelRegistry.getDefinitions().getImport().add((Object)tImportBonitaConnector);
            }
        }
    }

    private TMessage createConnectorDefOutput(String connectorDefId) {
        String itemDefConnectorOutput = this.generateConnectorOutputItemDef(connectorDefId);
        this.modelRegistry.getDefinitions().getRootElement().stream().filter(e -> itemDefConnectorOutput.equals(e.getId())).findFirst().ifPresentOrElse(e -> {}, () -> {
            TItemDefinition tItemDefinitionBonitaConnectorOutput = ModelFactory.eINSTANCE.createTItemDefinition();
            tItemDefinitionBonitaConnectorOutput.setStructureRef(QName.valueOf("bonitaConnector:" + connectorDefId + "OutputType"));
            tItemDefinitionBonitaConnectorOutput.setId(itemDefConnectorOutput);
            this.modelRegistry.getDefinitions().getRootElement().add((Object)tItemDefinitionBonitaConnectorOutput);
        });
        String outputId = connectorDefId + "ConnectorMessageOutput";
        return this.modelRegistry.getDefinitions().getRootElement().stream().filter(TMessage.class::isInstance).map(TMessage.class::cast).filter(e -> outputId.equals(e.getId())).findFirst().orElseGet(() -> {
            TMessage tMessageOutputBonitaConnector = ModelFactory.eINSTANCE.createTMessage();
            tMessageOutputBonitaConnector.setItemRef(QName.valueOf(itemDefConnectorOutput));
            tMessageOutputBonitaConnector.setId(outputId);
            this.modelRegistry.getDefinitions().getRootElement().add((Object)tMessageOutputBonitaConnector);
            return tMessageOutputBonitaConnector;
        });
    }

    private TMessage createConnectorDefInput(String connectorDefId) {
        String itemDefConnectorInput = this.generateConnectorInputItemDef(connectorDefId);
        this.modelRegistry.getDefinitions().getRootElement().stream().filter(e -> itemDefConnectorInput.equals(e.getId())).findFirst().ifPresentOrElse(e -> {}, () -> {
            TItemDefinition tItemDefinitionBonitaConnectorInput = ModelFactory.eINSTANCE.createTItemDefinition();
            tItemDefinitionBonitaConnectorInput.setStructureRef(QName.valueOf("bonitaConnector:" + connectorDefId + "InputType"));
            tItemDefinitionBonitaConnectorInput.setId(itemDefConnectorInput);
            this.modelRegistry.getDefinitions().getRootElement().add((Object)tItemDefinitionBonitaConnectorInput);
        });
        String id = connectorDefId + "ConnectorMessageInput";
        return this.modelRegistry.getDefinitions().getRootElement().stream().filter(TMessage.class::isInstance).map(TMessage.class::cast).filter(e -> id.equals(e.getId())).findFirst().orElseGet(() -> {
            TMessage tMessageInputBonitaConnector = ModelFactory.eINSTANCE.createTMessage();
            tMessageInputBonitaConnector.setItemRef(QName.valueOf(itemDefConnectorInput));
            tMessageInputBonitaConnector.setId(id);
            this.modelRegistry.getDefinitions().getRootElement().add((Object)tMessageInputBonitaConnector);
            return tMessageInputBonitaConnector;
        });
    }
}

