/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.bonitasoft.bonita2bpmn.transfo.ConnectorDefinitionTransformer;
import org.bonitasoft.bonita2bpmn.transfo.ModelRegistry;
import org.bonitasoft.bonita2bpmn.transfo.data.DataIOTransformer;
import org.bonitasoft.bonita2bpmn.transfo.expression.FormalExpressionFunctionFactory;
import org.bonitasoft.bonita2bpmn.util.Strings;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorParameter;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.Operation;
import org.bonitasoft.bpm.model.process.ANDGateway;
import org.bonitasoft.bpm.model.process.AbstractTimerEvent;
import org.bonitasoft.bpm.model.process.Activity;
import org.bonitasoft.bpm.model.process.Actor;
import org.bonitasoft.bpm.model.process.CallActivity;
import org.bonitasoft.bpm.model.process.CatchLinkEvent;
import org.bonitasoft.bpm.model.process.Connector;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.EndErrorEvent;
import org.bonitasoft.bpm.model.process.EndEvent;
import org.bonitasoft.bpm.model.process.EndMessageEvent;
import org.bonitasoft.bpm.model.process.EndSignalEvent;
import org.bonitasoft.bpm.model.process.EndTerminatedEvent;
import org.bonitasoft.bpm.model.process.InclusiveGateway;
import org.bonitasoft.bpm.model.process.InputMapping;
import org.bonitasoft.bpm.model.process.IntermediateCatchMessageEvent;
import org.bonitasoft.bpm.model.process.IntermediateCatchSignalEvent;
import org.bonitasoft.bpm.model.process.IntermediateCatchTimerEvent;
import org.bonitasoft.bpm.model.process.IntermediateThrowMessageEvent;
import org.bonitasoft.bpm.model.process.IntermediateThrowSignalEvent;
import org.bonitasoft.bpm.model.process.LinkEvent;
import org.bonitasoft.bpm.model.process.Message;
import org.bonitasoft.bpm.model.process.MultiInstanceType;
import org.bonitasoft.bpm.model.process.MultiInstantiable;
import org.bonitasoft.bpm.model.process.OutputMapping;
import org.bonitasoft.bpm.model.process.ReceiveTask;
import org.bonitasoft.bpm.model.process.ScriptTask;
import org.bonitasoft.bpm.model.process.SendTask;
import org.bonitasoft.bpm.model.process.ServiceTask;
import org.bonitasoft.bpm.model.process.SignalEvent;
import org.bonitasoft.bpm.model.process.StartErrorEvent;
import org.bonitasoft.bpm.model.process.StartEvent;
import org.bonitasoft.bpm.model.process.StartMessageEvent;
import org.bonitasoft.bpm.model.process.StartSignalEvent;
import org.bonitasoft.bpm.model.process.StartTimerEvent;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.process.Task;
import org.bonitasoft.bpm.model.process.ThrowLinkEvent;
import org.bonitasoft.bpm.model.process.XORGateway;
import org.bonitasoft.bpm.model.process.util.ProcessSwitch;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.omg.spec.bpmn.model.ModelFactory;
import org.omg.spec.bpmn.model.TActivity;
import org.omg.spec.bpmn.model.TAssignment;
import org.omg.spec.bpmn.model.TCallActivity;
import org.omg.spec.bpmn.model.TCatchEvent;
import org.omg.spec.bpmn.model.TDataInput;
import org.omg.spec.bpmn.model.TDataInputAssociation;
import org.omg.spec.bpmn.model.TDataOutput;
import org.omg.spec.bpmn.model.TDataOutputAssociation;
import org.omg.spec.bpmn.model.TEndEvent;
import org.omg.spec.bpmn.model.TErrorEventDefinition;
import org.omg.spec.bpmn.model.TExclusiveGateway;
import org.omg.spec.bpmn.model.TExpression;
import org.omg.spec.bpmn.model.TFlowElement;
import org.omg.spec.bpmn.model.TFormalExpression;
import org.omg.spec.bpmn.model.TInclusiveGateway;
import org.omg.spec.bpmn.model.TInputOutputSpecification;
import org.omg.spec.bpmn.model.TIntermediateCatchEvent;
import org.omg.spec.bpmn.model.TIntermediateThrowEvent;
import org.omg.spec.bpmn.model.TItemDefinition;
import org.omg.spec.bpmn.model.TLinkEventDefinition;
import org.omg.spec.bpmn.model.TLoopCharacteristics;
import org.omg.spec.bpmn.model.TMultiInstanceLoopCharacteristics;
import org.omg.spec.bpmn.model.TOutputSet;
import org.omg.spec.bpmn.model.TParallelGateway;
import org.omg.spec.bpmn.model.TPerformer;
import org.omg.spec.bpmn.model.TReceiveTask;
import org.omg.spec.bpmn.model.TScriptTask;
import org.omg.spec.bpmn.model.TSendTask;
import org.omg.spec.bpmn.model.TServiceTask;
import org.omg.spec.bpmn.model.TSignal;
import org.omg.spec.bpmn.model.TSignalEventDefinition;
import org.omg.spec.bpmn.model.TStandardLoopCharacteristics;
import org.omg.spec.bpmn.model.TStartEvent;
import org.omg.spec.bpmn.model.TSubProcess;
import org.omg.spec.bpmn.model.TTask;
import org.omg.spec.bpmn.model.TTerminateEventDefinition;
import org.omg.spec.bpmn.model.TThrowEvent;
import org.omg.spec.bpmn.model.TTimerEventDefinition;
import org.omg.spec.bpmn.model.TUserTask;

public class TFlowElementSwitch
extends ProcessSwitch<TFlowElement> {
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd/HH/mm/ss";
    private static final String DISPLAY_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    static final String EVENTDEF_PREFIX = "eventdef-";
    private IModelSearch modelSearch;
    private ConnectorDefinitionTransformer connectorDefinitionTransformer;
    private FormalExpressionFunctionFactory formalExpressionTransformerFactory;
    private ModelRegistry modelRegistry;

    TFlowElementSwitch(IModelSearch modelSearch, ConnectorDefinitionTransformer connectorDefinitionTransformer, FormalExpressionFunctionFactory formalExpressionTransformerFactory, ModelRegistry modelRegistry) {
        this.modelSearch = modelSearch;
        this.connectorDefinitionTransformer = connectorDefinitionTransformer;
        this.formalExpressionTransformerFactory = formalExpressionTransformerFactory;
        this.modelRegistry = modelRegistry;
    }

    public TActivity caseActivity(Activity object) {
        TTask task = ModelFactory.eINSTANCE.createTTask();
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)task);
        return task;
    }

    public TServiceTask caseServiceTask(ServiceTask object) {
        TServiceTask serviceTask = ModelFactory.eINSTANCE.createTServiceTask();
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)serviceTask);
        if (!object.getConnectors().isEmpty()) {
            this.handleConnectorOnServiceTask(object, serviceTask);
        }
        return serviceTask;
    }

    public TScriptTask caseScriptTask(ScriptTask object) {
        TScriptTask scriptTask = ModelFactory.eINSTANCE.createTScriptTask();
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)scriptTask);
        return scriptTask;
    }

    public TSendTask caseSendTask(SendTask object) {
        TSendTask sendTask = ModelFactory.eINSTANCE.createTSendTask();
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)sendTask);
        return sendTask;
    }

    public TReceiveTask caseReceiveTask(ReceiveTask object) {
        TReceiveTask receiveTask = ModelFactory.eINSTANCE.createTReceiveTask();
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)receiveTask);
        return receiveTask;
    }

    public TUserTask caseTask(Task object) {
        TUserTask userTask = ModelFactory.eINSTANCE.createTUserTask();
        Actor actor = object.getActor();
        if (actor != null) {
            EList resourceRoles = userTask.getResourceRole();
            TPerformer role = ModelFactory.eINSTANCE.createTPerformer();
            role.setResourceRef(QName.valueOf(this.modelSearch.getEObjectID((EObject)actor)));
            role.setId(EcoreUtil.generateUUID());
            resourceRoles.add((Object)role);
        }
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)userTask);
        return userTask;
    }

    public TCallActivity caseCallActivity(CallActivity object) {
        TCallActivity callActivity = ModelFactory.eINSTANCE.createTCallActivity();
        Expression calledActivityName = object.getCalledActivityName();
        if (calledActivityName != null && "TYPE_CONSTANT".equals(calledActivityName.getType()) && calledActivityName.getContent() != null) {
            Expression calledVersion = object.getCalledActivityVersion();
            String version = null;
            if (calledVersion != null && calledVersion.getContent() != null && !calledVersion.getContent().isEmpty()) {
                version = calledVersion.getContent();
            }
            this.modelSearch.findProcess(calledActivityName.getContent(), version).ifPresent(calledProcess -> callActivity.setCalledElement(QName.valueOf(this.modelSearch.getEObjectID((EObject)calledProcess))));
        }
        this.handleMultiInstance((MultiInstantiable)object, (TActivity)callActivity);
        this.dataMappingWithCallActivity(object, callActivity);
        return callActivity;
    }

    public TParallelGateway caseANDGateway(ANDGateway object) {
        return ModelFactory.eINSTANCE.createTParallelGateway();
    }

    public TInclusiveGateway caseInclusiveGateway(InclusiveGateway object) {
        return ModelFactory.eINSTANCE.createTInclusiveGateway();
    }

    public TExclusiveGateway caseXORGateway(XORGateway object) {
        return ModelFactory.eINSTANCE.createTExclusiveGateway();
    }

    public TSubProcess caseSubProcessEvent(SubProcessEvent object) {
        TSubProcess eventSubProc = ModelFactory.eINSTANCE.createTSubProcess();
        eventSubProc.setTriggeredByEvent(true);
        return eventSubProc;
    }

    public TStartEvent caseStartTimerEvent(StartTimerEvent object) {
        TStartEvent event = ModelFactory.eINSTANCE.createTStartEvent();
        TTimerEventDefinition eventDef = ModelFactory.eINSTANCE.createTTimerEventDefinition();
        Expression conditionExpression = object.getCondition();
        if (conditionExpression != null && conditionExpression.hasContent()) {
            this.createTimerExpression(eventDef, conditionExpression);
        }
        eventDef.setId(EVENTDEF_PREFIX + object.getName());
        event.getEventDefinition().add((Object)eventDef);
        this.modelRegistry.addError(String.format("Timer definition for event %s not exported", object.getName()));
        return event;
    }

    public TStartEvent caseStartErrorEvent(StartErrorEvent object) {
        TStartEvent event = ModelFactory.eINSTANCE.createTStartEvent();
        TErrorEventDefinition eventDef = ModelFactory.eINSTANCE.createTErrorEventDefinition();
        event.getEventDefinition().add((Object)eventDef);
        String errorCode = object.getErrorCode();
        String eventDefId = errorCode != null ? errorCode + EcoreUtil.generateUUID() : EcoreUtil.generateUUID();
        eventDef.setId(eventDefId);
        if (errorCode != null) {
            eventDef.setErrorRef(QName.valueOf(errorCode));
        }
        return event;
    }

    public TStartEvent caseStartMessageEvent(StartMessageEvent object) {
        TStartEvent event = ModelFactory.eINSTANCE.createTStartEvent();
        String eventId = object.getEvent() != null && !object.getEvent().isBlank() ? object.getEvent() : EcoreUtil.generateUUID();
        event.getEventDefinitionRef().add((Object)QName.valueOf(eventId));
        this.modelRegistry.addMessage(eventId);
        return event;
    }

    public TStartEvent caseStartSignalEvent(StartSignalEvent object) {
        TStartEvent event = ModelFactory.eINSTANCE.createTStartEvent();
        TSignal tSignal = this.getOrCreateTSignal((SignalEvent)object);
        TSignalEventDefinition eventDef = ModelFactory.eINSTANCE.createTSignalEventDefinition();
        eventDef.setSignalRef(QName.valueOf(tSignal.getId()));
        event.getEventDefinition().add((Object)eventDef);
        eventDef.setId(object.getName());
        return event;
    }

    public TStartEvent caseStartEvent(StartEvent object) {
        return ModelFactory.eINSTANCE.createTStartEvent();
    }

    public TEndEvent caseEndErrorEvent(EndErrorEvent object) {
        TEndEvent bpmnEnd = ModelFactory.eINSTANCE.createTEndEvent();
        TErrorEventDefinition eventDef = ModelFactory.eINSTANCE.createTErrorEventDefinition();
        bpmnEnd.getEventDefinition().add((Object)eventDef);
        String errorCode = object.getErrorCode();
        String eventDefId = errorCode != null ? errorCode + EcoreUtil.generateUUID() : EcoreUtil.generateUUID();
        eventDef.setId(eventDefId);
        if (errorCode != null) {
            eventDef.setErrorRef(QName.valueOf(errorCode));
        }
        return bpmnEnd;
    }

    public TEndEvent caseEndMessageEvent(EndMessageEvent object) {
        TEndEvent bpmnEnd = ModelFactory.eINSTANCE.createTEndEvent();
        for (Message eventObject : object.getEvents()) {
            String eventId = eventObject.getName() != null && !eventObject.getName().isBlank() ? eventObject.getName() : EcoreUtil.generateUUID();
            bpmnEnd.getEventDefinitionRef().add((Object)QName.valueOf(eventId));
            this.modelRegistry.addMessage(eventId);
        }
        return bpmnEnd;
    }

    public TEndEvent caseEndSignalEvent(EndSignalEvent object) {
        TEndEvent event = ModelFactory.eINSTANCE.createTEndEvent();
        this.addSignalEventDefinition((SignalEvent)object, (TThrowEvent)event);
        return event;
    }

    public TEndEvent caseEndTerminatedEvent(EndTerminatedEvent object) {
        TEndEvent event = ModelFactory.eINSTANCE.createTEndEvent();
        TTerminateEventDefinition eventDef = ModelFactory.eINSTANCE.createTTerminateEventDefinition();
        event.getEventDefinition().add((Object)eventDef);
        eventDef.setId(EcoreUtil.generateUUID());
        return event;
    }

    public TEndEvent caseEndEvent(EndEvent object) {
        return ModelFactory.eINSTANCE.createTEndEvent();
    }

    public TIntermediateCatchEvent caseIntermediateCatchMessageEvent(IntermediateCatchMessageEvent object) {
        TIntermediateCatchEvent bpmnEvent = ModelFactory.eINSTANCE.createTIntermediateCatchEvent();
        String event = object.getEvent() != null && !object.getEvent().isBlank() ? object.getEvent() : EcoreUtil.generateUUID();
        bpmnEvent.getEventDefinitionRef().add((Object)QName.valueOf(event));
        this.modelRegistry.addMessage(event);
        return bpmnEvent;
    }

    public TIntermediateThrowEvent caseIntermediateThrowMessageEvent(IntermediateThrowMessageEvent object) {
        TIntermediateThrowEvent event = ModelFactory.eINSTANCE.createTIntermediateThrowEvent();
        for (Message bonitaEventDef : object.getEvents()) {
            String eventId = bonitaEventDef.getName() != null && !bonitaEventDef.getName().isBlank() ? bonitaEventDef.getName() : EcoreUtil.generateUUID();
            event.getEventDefinitionRef().add((Object)QName.valueOf(eventId));
            this.modelRegistry.addMessage(eventId);
        }
        return event;
    }

    public TIntermediateCatchEvent caseIntermediateCatchSignalEvent(IntermediateCatchSignalEvent object) {
        TIntermediateCatchEvent bpmnEvent = ModelFactory.eINSTANCE.createTIntermediateCatchEvent();
        this.addSignalEventDefinition((SignalEvent)object, (TCatchEvent)bpmnEvent);
        return bpmnEvent;
    }

    public TIntermediateThrowEvent caseIntermediateThrowSignalEvent(IntermediateThrowSignalEvent object) {
        TIntermediateThrowEvent bpmnEvent = ModelFactory.eINSTANCE.createTIntermediateThrowEvent();
        this.addSignalEventDefinition((SignalEvent)object, (TThrowEvent)bpmnEvent);
        return bpmnEvent;
    }

    public TIntermediateCatchEvent caseCatchLinkEvent(CatchLinkEvent object) {
        TIntermediateCatchEvent bpmnEvent = ModelFactory.eINSTANCE.createTIntermediateCatchEvent();
        TLinkEventDefinition bpmnLinkEvent = this.createTLinkEventDefinition((LinkEvent)object);
        bpmnEvent.getEventDefinition().add((Object)bpmnLinkEvent);
        return bpmnEvent;
    }

    public TIntermediateThrowEvent caseThrowLinkEvent(ThrowLinkEvent object) {
        TIntermediateThrowEvent bpmnEvent = ModelFactory.eINSTANCE.createTIntermediateThrowEvent();
        TLinkEventDefinition bpmnLinkEvent = this.createTLinkEventDefinition((LinkEvent)object);
        bpmnEvent.getEventDefinition().add((Object)bpmnLinkEvent);
        return bpmnEvent;
    }

    public TIntermediateCatchEvent caseIntermediateCatchTimerEvent(IntermediateCatchTimerEvent object) {
        TIntermediateCatchEvent bpmnEvent = ModelFactory.eINSTANCE.createTIntermediateCatchEvent();
        TTimerEventDefinition eventDef = this.createTimerEventDef((AbstractTimerEvent)object);
        bpmnEvent.getEventDefinition().add((Object)eventDef);
        return bpmnEvent;
    }

    public TTimerEventDefinition createTimerEventDef(AbstractTimerEvent bonitaEvent) {
        TTimerEventDefinition eventDef = ModelFactory.eINSTANCE.createTTimerEventDefinition();
        Expression conditionExpression = bonitaEvent.getCondition();
        if (conditionExpression != null && conditionExpression.hasContent()) {
            this.createTimerExpression(eventDef, conditionExpression);
        }
        eventDef.setId(EVENTDEF_PREFIX + Strings.slugify(bonitaEvent.getName()));
        return eventDef;
    }

    private void createTimerExpression(TTimerEventDefinition eventDef, Expression conditionExpression) {
        String condition = conditionExpression.getContent();
        TExpression expression = ModelFactory.eINSTANCE.createTExpression();
        FeatureMapUtil.addText((FeatureMap)expression.getMixed(), (String)condition);
        if (TFlowElementSwitch.isDuration(condition)) {
            eventDef.setTimeDuration(expression);
        } else if (TFlowElementSwitch.isDate(condition)) {
            eventDef.setTimeDate(expression);
        } else {
            eventDef.setTimeCycle(expression);
        }
    }

    private void dataMappingWithCallActivity(CallActivity callActivity, TCallActivity tCallActivity) {
        TDataInputAssociation dia = ModelFactory.eINSTANCE.createTDataInputAssociation();
        dia.setId(EcoreUtil.generateUUID());
        tCallActivity.getDataInputAssociation().add((Object)dia);
        for (InputMapping im : callActivity.getInputMappings()) {
            TAssignment inputAssignment = ModelFactory.eINSTANCE.createTAssignment();
            Expression processSource = im.getProcessSource();
            if (processSource == null) continue;
            inputAssignment.setFrom(this.createBPMNExpressionFromString(processSource.getName()));
            String dataTo = this.getDataReferenceValue(callActivity, im.getSubprocessTarget());
            if (dataTo == null) continue;
            inputAssignment.setTo(this.createBPMNExpressionFromString(dataTo));
            dia.getAssignment().add((Object)inputAssignment);
        }
        TDataOutputAssociation doa = ModelFactory.eINSTANCE.createTDataOutputAssociation();
        doa.setId(EcoreUtil.generateUUID());
        tCallActivity.getDataOutputAssociation().add((Object)doa);
        for (OutputMapping om : callActivity.getOutputMappings()) {
            TAssignment outputAssignment = ModelFactory.eINSTANCE.createTAssignment();
            String dataFrom = this.getDataReferenceValue(callActivity, om.getSubprocessSource());
            outputAssignment.setFrom(this.createBPMNExpressionFromString(dataFrom));
            Data processTarget = om.getProcessTarget();
            if (processTarget == null) continue;
            TItemDefinition dataTo = this.modelRegistry.getDataScope().get(processTarget);
            outputAssignment.setTo(this.createBPMNExpressionFromString(dataTo != null ? dataTo.getId() : processTarget.getName()));
            doa.getAssignment().add((Object)outputAssignment);
        }
    }

    private void handleConnectorOnServiceTask(ServiceTask activity, TServiceTask serviceTask) {
        EList connectors = activity.getConnectors();
        if (!connectors.isEmpty()) {
            Connector connector = (Connector)connectors.get(0);
            this.connectorDefinitionTransformer.handleBonitaConnectorDefinition(connector.getDefinitionId());
            serviceTask.setImplementation((Object)"BonitaConnector");
            serviceTask.setOperationRef(QName.valueOf("Exec" + connector.getDefinitionId()));
            TDataInput dataInput = DataIOTransformer.fillIOSpecificationWithNewDataInput((TActivity)serviceTask, QName.valueOf(this.connectorDefinitionTransformer.generateConnectorInputItemDef(connector.getDefinitionId())));
            TDataOutput dataOutput = this.fillIOSpecificationWithNewDataOutput(serviceTask, QName.valueOf(this.connectorDefinitionTransformer.generateConnectorOutputItemDef(connector.getDefinitionId())));
            this.handleConnectorInput(serviceTask, connector, dataInput);
            this.handleConnectorOutput(serviceTask, connector, dataInput, dataOutput);
        }
    }

    private void handleConnectorInput(TServiceTask serviceTask, Connector connector, TDataInput dataInput) {
        TDataInputAssociation tDataInputAssociation = ModelFactory.eINSTANCE.createTDataInputAssociation();
        EList inputAssignments = tDataInputAssociation.getAssignment();
        for (ConnectorParameter cp : connector.getConfiguration().getParameters()) {
            TAssignment inputAssignment = ModelFactory.eINSTANCE.createTAssignment();
            if (!(cp.getExpression() instanceof Expression) || ((Expression)cp.getExpression()).getContent() == null) continue;
            inputAssignment.setFrom((TExpression)this.convertExpression((Expression)cp.getExpression()));
            inputAssignment.setTo(this.createBPMNExpressionFromString("getDataInput('" + dataInput.getId() + "')/bonitaConnector:" + cp.getKey()));
            inputAssignments.add((Object)inputAssignment);
        }
        if (!tDataInputAssociation.getAssignment().isEmpty()) {
            serviceTask.getDataInputAssociation().add((Object)tDataInputAssociation);
            tDataInputAssociation.setTargetRef(dataInput.getId());
        }
    }

    private void handleConnectorOutput(TServiceTask serviceTask, Connector connector, TDataInput dataInput, TDataOutput dataOutput) {
        TDataOutputAssociation tDataOutputAssociation = ModelFactory.eINSTANCE.createTDataOutputAssociation();
        EList outputAssignments = tDataOutputAssociation.getAssignment();
        for (Operation opm : connector.getOutputs()) {
            if (!opm.getRightOperand().hasName() || !opm.getRightOperand().hasContent()) continue;
            TAssignment outputAssignment = ModelFactory.eINSTANCE.createTAssignment();
            if ("CONNECTOR_OUTPUT_TYPE".equals(opm.getRightOperand().getType())) {
                outputAssignment.setFrom(this.createBPMNExpressionFromString("getDataOutput('" + dataInput.getId() + "')/bonitaConnector:" + opm.getRightOperand().getName()));
            } else {
                outputAssignment.setFrom((TExpression)this.convertExpression(opm.getRightOperand()));
            }
            if (opm.getLeftOperand().hasContent()) {
                outputAssignment.setTo((TExpression)this.convertExpression(opm.getLeftOperand()));
            }
            outputAssignments.add((Object)outputAssignment);
        }
        if (!tDataOutputAssociation.getAssignment().isEmpty()) {
            serviceTask.getDataOutputAssociation().add((Object)tDataOutputAssociation);
            tDataOutputAssociation.setTargetRef(dataOutput.getId());
        }
    }

    private TDataOutput fillIOSpecificationWithNewDataOutput(TServiceTask serviceTask, QName dataItemDefinitionIdAsQname) {
        TInputOutputSpecification tInputOutputAssociation = serviceTask.getIoSpecification();
        if (tInputOutputAssociation == null) {
            tInputOutputAssociation = ModelFactory.eINSTANCE.createTInputOutputSpecification();
            tInputOutputAssociation.setId(EcoreUtil.generateUUID());
            serviceTask.setIoSpecification(tInputOutputAssociation);
        }
        return this.fillIOSpecificationWithNewDataOutput(dataItemDefinitionIdAsQname, tInputOutputAssociation);
    }

    private TDataOutput fillIOSpecificationWithNewDataOutput(QName dataItemDefinitionIdAsQname, TInputOutputSpecification tInputOutputAssociation) {
        TDataOutput tDataOutput = ModelFactory.eINSTANCE.createTDataOutput();
        tDataOutput.setItemSubjectRef(dataItemDefinitionIdAsQname);
        tDataOutput.setId(EcoreUtil.generateUUID());
        TOutputSet tOutputSet = ModelFactory.eINSTANCE.createTOutputSet();
        tOutputSet.setId(EcoreUtil.generateUUID());
        tOutputSet.getDataOutputRefs().add((Object)tDataOutput.getId());
        EList dataOutput = tInputOutputAssociation.getDataOutput();
        EList outputSet = tInputOutputAssociation.getOutputSet();
        outputSet.add((Object)tOutputSet);
        dataOutput.add((Object)tDataOutput);
        return tDataOutput;
    }

    private TExpression createBPMNExpressionFromString(String value) {
        TExpression fromExpression = ModelFactory.eINSTANCE.createTExpression();
        fromExpression.setId(EcoreUtil.generateUUID());
        FeatureMapUtil.addText((FeatureMap)fromExpression.getMixed(), (String)(value == null ? "" : value));
        return fromExpression;
    }

    private String getDataReferenceValue(CallActivity callActivity, String bonitaReferenceString) {
        String result = bonitaReferenceString;
        Expression calledActivityName = callActivity.getCalledActivityName();
        if (calledActivityName != null && calledActivityName.getType().equals("TYPE_CONSTANT") && calledActivityName.getContent() != null) {
            String version = null;
            Expression calledActivityVersion = callActivity.getCalledActivityVersion();
            if (calledActivityVersion != null && calledActivityVersion.getType().equals("TYPE_CONSTANT") && calledActivityVersion.getContent() != null) {
                version = calledActivityVersion.getContent();
            }
            result = this.modelSearch.findProcess(calledActivityName.getContent(), version).flatMap(calledProcess -> calledProcess.getData().stream().filter(data -> Objects.equals(data.getName(), bonitaReferenceString)).map(data -> this.modelSearch.getEObjectID((EObject)data)).findFirst()).orElse(null);
        }
        return result;
    }

    private void handleMultiInstance(MultiInstantiable multiInstantiable, TActivity res) {
        MultiInstanceType multiInstanceType = multiInstantiable.getType();
        TStandardLoopCharacteristics loopCharacteristics = null;
        if (MultiInstanceType.STANDARD.equals((Object)multiInstanceType)) {
            Expression loopMaximum;
            loopCharacteristics = ModelFactory.eINSTANCE.createTStandardLoopCharacteristics();
            loopCharacteristics.setTestBefore(multiInstantiable.getTestBefore().booleanValue());
            Expression loopCondition = multiInstantiable.getLoopCondition();
            if (loopCondition != null) {
                loopCharacteristics.setLoopCondition((TExpression)this.convertExpression(loopCondition));
            }
            if ((loopMaximum = multiInstantiable.getLoopMaximum()) != null && "TYPE_CONSTANT".equals(loopMaximum.getType()) && loopMaximum.getContent() != null && !loopMaximum.getContent().isEmpty()) {
                loopCharacteristics.setLoopMaximum(new BigInteger(loopMaximum.getContent()));
            }
        } else if (MultiInstanceType.PARALLEL.equals((Object)multiInstanceType) || MultiInstanceType.SEQUENTIAL.equals((Object)multiInstanceType)) {
            Expression cardinalityExpression;
            loopCharacteristics = ModelFactory.eINSTANCE.createTMultiInstanceLoopCharacteristics();
            ((TMultiInstanceLoopCharacteristics)loopCharacteristics).setIsSequential(MultiInstanceType.SEQUENTIAL.equals((Object)multiInstanceType));
            Expression completionCondition = multiInstantiable.getCompletionCondition();
            if (completionCondition != null) {
                ((TMultiInstanceLoopCharacteristics)loopCharacteristics).setCompletionCondition((TExpression)this.convertExpression(completionCondition));
            }
            if ((cardinalityExpression = multiInstantiable.getCardinalityExpression()) != null) {
                ((TMultiInstanceLoopCharacteristics)loopCharacteristics).setLoopCardinality((TExpression)this.convertExpression(cardinalityExpression));
            }
        }
        if (loopCharacteristics != null) {
            loopCharacteristics.setId(EcoreUtil.generateUUID());
            res.setLoopCharacteristics((TLoopCharacteristics)loopCharacteristics);
        }
    }

    private TLinkEventDefinition createTLinkEventDefinition(LinkEvent bonitaEvent) {
        TLinkEventDefinition eventDef = ModelFactory.eINSTANCE.createTLinkEventDefinition();
        eventDef.setId(EcoreUtil.generateUUID());
        this.modelRegistry.putLink(bonitaEvent, eventDef);
        return eventDef;
    }

    private TSignalEventDefinition addSignalEventDefinition(SignalEvent bonitaEvent, TThrowEvent bpmnEvent) {
        TSignalEventDefinition eventDef = this.createSignalEvent(bonitaEvent);
        bpmnEvent.getEventDefinition().add((Object)eventDef);
        return eventDef;
    }

    private TSignalEventDefinition createSignalEvent(SignalEvent bonitaEvent) {
        TSignalEventDefinition eventDef = ModelFactory.eINSTANCE.createTSignalEventDefinition();
        eventDef.setId(EcoreUtil.generateUUID());
        TSignal tSignal = this.getOrCreateTSignal(bonitaEvent);
        eventDef.setSignalRef(QName.valueOf(tSignal.getId()));
        return eventDef;
    }

    private TSignalEventDefinition addSignalEventDefinition(SignalEvent bonitaEvent, TCatchEvent bpmnEvent) {
        TSignalEventDefinition eventDef = this.createSignalEvent(bonitaEvent);
        bpmnEvent.getEventDefinition().add((Object)eventDef);
        return eventDef;
    }

    TSignal getOrCreateTSignal(SignalEvent signalEvent) {
        String signalCode = signalEvent.getSignalCode();
        TSignal tSignal = null;
        if (signalCode != null) {
            tSignal = this.modelRegistry.getSignalCode().get(signalCode);
            if (tSignal == null) {
                tSignal = ModelFactory.eINSTANCE.createTSignal();
                tSignal.setId(EcoreUtil.generateUUID());
                tSignal.setName(signalCode);
                this.modelRegistry.putSignalCode(signalCode, tSignal);
                this.modelRegistry.addSignal(tSignal);
            }
        } else {
            tSignal = ModelFactory.eINSTANCE.createTSignal();
            tSignal.setId(EcoreUtil.generateUUID());
            this.modelRegistry.addSignal(tSignal);
        }
        return tSignal;
    }

    private TFormalExpression convertExpression(Expression bonitaExpression) {
        return this.formalExpressionTransformerFactory.newFormalExpressionFunction(this.modelRegistry.getDataScope(), bonitaExpression.getType(), this.modelSearch).apply(bonitaExpression);
    }

    private static boolean isDate(String event) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.US);
        sdf.setLenient(false);
        boolean displayDate = true;
        boolean systemDate = true;
        try {
            sdf.parse(event);
        }
        catch (Exception e) {
            systemDate = false;
        }
        sdf = new SimpleDateFormat(DISPLAY_DATE_FORMAT, Locale.US);
        try {
            sdf.parse(event);
        }
        catch (Exception e) {
            displayDate = false;
        }
        return systemDate || displayDate;
    }

    private static boolean isDuration(String event) {
        long r = -1L;
        try {
            r = Long.parseLong(event);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return String.valueOf(r).equals(event);
    }
}

