/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.util;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;

public class Strings {
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");
    private static final Pattern EDGESDHASHES = Pattern.compile("(^-)|(-$)");

    private Strings() {
    }

    public static boolean hasText(String string) {
        return string != null && !string.isBlank();
    }

    public static String slugify(String input) {
        String nowhitespace = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        slug = EDGESDHASHES.matcher(slug).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH);
    }
}

