/**
 * Copyright (C) 2011 Bonitasoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2.0 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.bonitasoft.bonita2bpmn.extension;

import java.util.List;

import org.bonitasoft.bpm.model.process.Lane;
import org.bonitasoft.bpm.model.process.MainProcess;
import org.bonitasoft.bpm.model.process.Pool;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;

/**
 * @author Romain Bioteau
 */
public interface IBonitaModelExporter {

    Diagram getDiagram();

    MainProcess getMainProcess();

    List<Pool> getPools();

    List<Lane> getLanes(Pool pool);

    Node getElementNotationNode(EObject element);

    Bounds getBounds(Node view);

    Location getLocation(Node view);

    Edge getElementNotationEdge(EObject connection);

    String getEObjectID(EObject eObject);

    Pool getParentPool(Lane lane);

}
