/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import org.bonitasoft.bonita2bpmn.transfo.CustomRectilinearRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;

public class CustomAnchor
extends SlidableAnchor {
    public CustomAnchor(IFigure targetFigure) {
        super(targetFigure);
    }

    public CustomAnchor(IFigure targetFigure, PrecisionPoint p) {
        super(targetFigure, p);
    }

    public Point getOrthogonalLocation(Point orthoReference) {
        int orientation;
        PrecisionPoint preciseOrthoReference;
        PrecisionPoint ownReference;
        block12: {
            PrecisionRectangle bounds;
            block11: {
                ownReference = new PrecisionPoint(this.getReferencePoint());
                bounds = new PrecisionRectangle(CustomRectilinearRouter.getAnchorableFigureBounds(this.getOwner()));
                this.getOwner().translateToAbsolute((Translatable)bounds);
                bounds.expand(1.0E-6, 1.0E-6);
                preciseOrthoReference = new PrecisionPoint(orthoReference);
                orientation = 0;
                if (!bounds.contains((Point)preciseOrthoReference)) break block11;
                int side = CustomAnchor.getClosestSide((Point)ownReference, (Rectangle)bounds);
                switch (side) {
                    case 1: 
                    case 4: {
                        ownReference.setPreciseY(preciseOrthoReference.preciseY());
                        orientation = 64;
                        break block12;
                    }
                    case 8: 
                    case 32: {
                        ownReference.setPreciseX(preciseOrthoReference.preciseX());
                        orientation = 128;
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Position %s not supported", side));
                    }
                }
            }
            if (preciseOrthoReference.preciseX() >= bounds.preciseX() && preciseOrthoReference.preciseX() <= bounds.preciseX() + bounds.preciseWidth()) {
                ownReference.setPreciseX(preciseOrthoReference.preciseX());
                orientation = 128;
            } else if (preciseOrthoReference.preciseY() >= bounds.preciseY() && preciseOrthoReference.preciseY() <= bounds.preciseY() + bounds.preciseHeight()) {
                ownReference.setPreciseY(preciseOrthoReference.preciseY());
                orientation = 64;
            }
        }
        ownReference.updateInts();
        Point location = this.getLocation((Point)ownReference, (Point)preciseOrthoReference);
        if (location == null) {
            location = this.getLocation(orthoReference);
            orientation = 0;
        }
        if (orientation != 0) {
            PrecisionPoint loc = new PrecisionPoint(location);
            if (orientation == 128) {
                loc.setPreciseX(preciseOrthoReference.preciseX());
            } else {
                loc.setPreciseY(preciseOrthoReference.preciseY());
            }
            loc.updateInts();
            location = loc;
        }
        return location;
    }

    private static int getClosestSide(Point p, Rectangle r) {
        double diff = Math.abs(r.preciseX() + r.preciseWidth() - p.preciseX());
        int side = 4;
        double currentDiff = Math.abs(r.preciseX() - p.preciseX());
        if (currentDiff < diff) {
            diff = currentDiff;
            side = 1;
        }
        if ((currentDiff = Math.abs(r.preciseY() + r.preciseHeight() - p.preciseY())) < diff) {
            diff = currentDiff;
            side = 32;
        }
        if ((currentDiff = Math.abs(r.preciseY() - p.preciseY())) < diff) {
            side = 8;
        }
        return side;
    }
}

