/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.bonita2bpmn.transfo.data.DataScope;
import org.bonitasoft.bpm.model.process.LinkEvent;
import org.omg.spec.bpmn.model.TDefinitions;
import org.omg.spec.bpmn.model.TLinkEventDefinition;
import org.omg.spec.bpmn.model.TSignal;

public class ModelRegistry {
    private final Set<String> messages = new HashSet<String>();
    private final DataScope dataScope;
    private final Set<TSignal> signals = new HashSet<TSignal>();
    private final Map<String, TSignal> signalCode = new HashMap<String, TSignal>();
    private final TDefinitions definitions;
    private final List<String> errors = new ArrayList<String>();
    private final Map<LinkEvent, TLinkEventDefinition> linkEvents = new HashMap<LinkEvent, TLinkEventDefinition>();

    public ModelRegistry(TDefinitions definitions, DataScope dataScope) {
        this.definitions = definitions;
        this.dataScope = dataScope;
    }

    public DataScope getDataScope() {
        return this.dataScope;
    }

    public TDefinitions getDefinitions() {
        return this.definitions;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Map<LinkEvent, TLinkEventDefinition> getLinkEvents() {
        return this.linkEvents;
    }

    public Set<TSignal> getSignals() {
        return this.signals;
    }

    public Set<String> getMessages() {
        return this.messages;
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public void addMessage(String eventId) {
        this.messages.add(eventId);
    }

    public void putLink(LinkEvent linkEvent, TLinkEventDefinition eventDef) {
        this.linkEvents.put(linkEvent, eventDef);
    }

    public Map<String, TSignal> getSignalCode() {
        return this.signalCode;
    }

    public void addSignal(TSignal tSignal) {
        this.signals.add(tSignal);
    }

    public void putSignalCode(String code, TSignal tSignal) {
        this.signalCode.put(code, tSignal);
    }
}

