/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo.expression;

import java.util.Objects;
import java.util.function.Predicate;
import org.bonitasoft.bonita2bpmn.transfo.data.DataScope;
import org.bonitasoft.bonita2bpmn.transfo.expression.FormalExpressionFunction;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.omg.spec.bpmn.model.TFormalExpression;
import org.omg.spec.bpmn.model.TItemDefinition;

public class VariableFormalExpressionTransformer
extends FormalExpressionFunction {
    private static final String DATA_OBJECT_PATTERN = "getDataObject('%s')";
    private static final String ACTIVITY_PROPERTY_PATTERN = "getActivityProperty('%s','%s')";
    private static final String EXPRESSION_TYPE = "TYPE_VARIABLE";
    public static final Predicate<String> IS_SUPPORTED_TYPE = "TYPE_VARIABLE"::equals;
    private final DataScope dataScope;
    private IModelSearch modelSearch;

    public VariableFormalExpressionTransformer(DataScope dataScope, IModelSearch modelSearch) {
        this.dataScope = dataScope;
        this.modelSearch = modelSearch;
    }

    @Override
    protected TFormalExpression addContent(Expression bonitaExpression, TFormalExpression formalExpression) {
        Objects.requireNonNull(bonitaExpression);
        Objects.requireNonNull(formalExpression);
        if (!IS_SUPPORTED_TYPE.test(bonitaExpression.getType())) {
            throw new IllegalArgumentException(String.format("Expression type is invalid. Expected %s but was %s", EXPRESSION_TYPE, bonitaExpression.getType()));
        }
        EList referencedElements = bonitaExpression.getReferencedElements();
        if (referencedElements.isEmpty()) {
            throw new IllegalArgumentException(String.format("Missing referenced elements for variable expression %s", bonitaExpression.getName()));
        }
        Data bonitaData = Objects.requireNonNull((Data)referencedElements.get(0));
        TItemDefinition bpmnData = this.dataScope.get(this.resolveData(bonitaData.getName(), (EObject)bonitaExpression));
        FeatureMapUtil.addText((FeatureMap)formalExpression.getMixed(), (String)this.createContentFor(bpmnData, bonitaData, bonitaExpression.getContent()));
        return formalExpression;
    }

    private String createContentFor(TItemDefinition bpmnData, Data bonitaData, String expressionContent) {
        if (bonitaData.isTransient()) {
            return this.createContentForTransientData(bpmnData, bonitaData, expressionContent);
        }
        return this.createContentForData(bpmnData, expressionContent);
    }

    private String createContentForData(TItemDefinition bpmnData, String expressionContent) {
        return String.format(DATA_OBJECT_PATTERN, bpmnData != null ? bpmnData.getId() : expressionContent);
    }

    private String createContentForTransientData(TItemDefinition bpmnData, Data bonitaData, String expressionContent) {
        AbstractProcess parentProcess = (AbstractProcess)this.modelSearch.getDirectParentOfType((EObject)bonitaData, AbstractProcess.class);
        return String.format(ACTIVITY_PROPERTY_PATTERN, parentProcess.getName(), bpmnData != null ? bpmnData.getId() : expressionContent);
    }

    private Data resolveData(String referencedDataName, EObject context) {
        return this.modelSearch.getAccessibleData(context).stream().filter(data -> Objects.equals(data.getName(), referencedDataName)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No data found in scope with name '%s'", referencedDataName)));
    }
}

