/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.bonitasoft.bonita2bpmn.extension.IBonitaModelExporter;
import org.bonitasoft.bonita2bpmn.transfo.CustomAnchor;
import org.bonitasoft.bonita2bpmn.transfo.CustomRectilinearRouter;
import org.bonitasoft.bonita2bpmn.transfo.LabelHelper;
import org.bonitasoft.bpm.model.process.BoundaryEvent;
import org.bonitasoft.bpm.model.process.Connection;
import org.bonitasoft.bpm.model.process.Element;
import org.bonitasoft.bpm.model.process.Event;
import org.bonitasoft.bpm.model.process.Gateway;
import org.bonitasoft.bpm.model.process.Lane;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.SequenceFlow;
import org.bonitasoft.bpm.model.process.SourceElement;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.process.TargetElement;
import org.bonitasoft.bpm.model.process.TextAnnotationAttachment;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.omg.spec.bpmn.di.BPMNDiagram;
import org.omg.spec.bpmn.di.BPMNEdge;
import org.omg.spec.bpmn.di.BPMNLabel;
import org.omg.spec.bpmn.di.BPMNLabelStyle;
import org.omg.spec.bpmn.di.BPMNShape;
import org.omg.spec.bpmn.di.DiFactory;
import org.omg.spec.bpmn.model.TBoundaryEvent;
import org.omg.spec.dd.dc.Bounds;
import org.omg.spec.dd.dc.DcFactory;
import org.omg.spec.dd.dc.DcPackage;
import org.omg.spec.dd.dc.Font;
import org.omg.spec.dd.dc.Point;
import org.omg.spec.dd.di.Shape;

public class BPMNShapeFactory {
    private static final int HORIZONTAL_SPACING = 50;
    private static final double TWO_PI = Math.PI * 2;
    private static final int NB_POINTS_DRAW_CIRCLE = 50;
    private static final int GATEWAY_WIDTH = 43;
    private static final int EVENT_WIDTH = 30;
    private static final int BOUNDARY_EVENT_WIDTH = 25;
    private IBonitaModelExporter modelExporter;
    private BPMNDiagram bpmnDiagram;

    public BPMNShapeFactory(IBonitaModelExporter modelExporter, BPMNDiagram bpmnDiagram) {
        this.modelExporter = modelExporter;
        this.bpmnDiagram = bpmnDiagram;
    }

    public BPMNShape createPool(String participantId, Pool pool) {
        BPMNShape processShape = DiFactory.eINSTANCE.createBPMNShape();
        processShape.setBpmnElement(QName.valueOf(participantId));
        Node poolNode = this.modelExporter.getElementNotationNode((EObject)pool);
        org.eclipse.gmf.runtime.notation.Bounds bounds = this.modelExporter.getBounds(poolNode);
        Bounds processBounds = DcFactory.eINSTANCE.createBounds();
        processBounds.setHeight((double)this.computePoolHeight(pool));
        processBounds.setWidth((double)bounds.getWidth());
        processBounds.setX((double)bounds.getX());
        processBounds.setY((double)this.computePoolY(this.modelExporter.getPools(), pool, this.modelExporter));
        processShape.setBounds(processBounds);
        processShape.setId(this.modelExporter.getEObjectID((EObject)poolNode));
        processShape.setIsHorizontal(true);
        return processShape;
    }

    private int computePoolHeight(Pool pool) {
        List lanes = pool.getElements().stream().filter(Lane.class::isInstance).map(Lane.class::cast).collect(Collectors.toList());
        Node poolNode = this.modelExporter.getElementNotationNode((EObject)pool);
        org.eclipse.gmf.runtime.notation.Bounds bounds = this.modelExporter.getBounds(poolNode);
        return lanes.isEmpty() ? bounds.getHeight() : lanes.stream().map(this.modelExporter::getElementNotationNode).map(this.modelExporter::getBounds).mapToInt(Size::getHeight).sum();
    }

    private int computePoolY(List<Pool> pools, Pool pool, IBonitaModelExporter modelExporter) {
        int index = modelExporter.getPools().indexOf(pool);
        int y = 0;
        while (index > 0) {
            y += this.computePoolHeight(pools.get(index - 1)) + 50;
            --index;
        }
        return y;
    }

    public BPMNShape create(EObject bonitaElement, String bpmnElementId, Bounds parentBounds) {
        Node node = this.modelExporter.getElementNotationNode(bonitaElement);
        BPMNShape elementShape = DiFactory.eINSTANCE.createBPMNShape();
        if (bonitaElement instanceof SubProcessEvent) {
            elementShape.setIsExpanded(((Boolean)node.getPersistedChildren().stream().filter(BasicCompartment.class::isInstance).map(BasicCompartment.class::cast).findFirst().map(compartment -> !((BasicCompartment)compartment).isCollapsed()).orElse(true)).booleanValue());
        }
        elementShape.setBpmnElement(QName.valueOf(bpmnElementId));
        org.eclipse.gmf.runtime.notation.Bounds bounds = this.modelExporter.getBounds(node);
        Bounds elementBounds = DcFactory.eINSTANCE.createBounds();
        elementBounds.setHeight((double)bounds.getHeight());
        elementBounds.setWidth((double)bounds.getWidth());
        elementBounds.setX((double)bounds.getX() + parentBounds.getX());
        elementBounds.setY((double)bounds.getY() + parentBounds.getY());
        elementShape.setBounds(elementBounds);
        elementShape.setId(this.modelExporter.getEObjectID((EObject)node));
        this.attachLabel(node, bonitaElement instanceof Element ? ((Element)bonitaElement).getName() : "", elementShape);
        return elementShape;
    }

    public BPMNShape createLane(String laneId, Lane lane, Bounds parentBounds) {
        BPMNShape laneShape = DiFactory.eINSTANCE.createBPMNShape();
        laneShape.setBpmnElement(QName.valueOf(laneId));
        Node laneNode = this.modelExporter.getElementNotationNode((EObject)lane);
        org.eclipse.gmf.runtime.notation.Bounds bounds = this.modelExporter.getBounds(laneNode);
        Bounds laneBounds = DcFactory.eINSTANCE.createBounds();
        laneBounds.setHeight((double)bounds.getHeight());
        laneBounds.setWidth(parentBounds.getWidth() - 30.0);
        laneBounds.setX(parentBounds.getX() + 30.0);
        laneBounds.setY(parentBounds.getY() + (double)this.computeLaneY(this.modelExporter.getLanes(this.modelExporter.getParentPool(lane)), lane, this.modelExporter));
        laneShape.setBounds(laneBounds);
        laneShape.setId(this.modelExporter.getEObjectID((EObject)laneNode));
        laneShape.setIsHorizontal(true);
        return laneShape;
    }

    private int computeLaneY(List<Lane> lanes, Lane lane, IBonitaModelExporter modelExporter) {
        int index = lanes.indexOf(lane);
        int y = 0;
        while (index > 0) {
            y += modelExporter.getBounds(modelExporter.getElementNotationNode((EObject)lanes.get(index - 1))).getHeight();
            --index;
        }
        return y;
    }

    public BPMNShape createBoundary(BoundaryEvent boundaryEvent, TBoundaryEvent bpmnBoundary, Bounds parentBounds) {
        int yOffset;
        BPMNShape boundaryShape = DiFactory.eINSTANCE.createBPMNShape();
        Node boundaryNode = this.modelExporter.getElementNotationNode((EObject)boundaryEvent);
        boundaryShape.setBpmnElement(QName.valueOf(bpmnBoundary.getId()));
        org.eclipse.gmf.runtime.notation.Bounds bounds = this.modelExporter.getBounds(boundaryNode);
        int xOffset = bounds.getX();
        if (xOffset == 0) {
            xOffset = 20;
        }
        if ((yOffset = bounds.getY()) == 0) {
            yOffset = (int)parentBounds.getHeight() - bounds.getHeight() / 2;
        }
        Bounds boundaryBounds = DcFactory.eINSTANCE.createBounds();
        boundaryBounds.setHeight((double)bounds.getHeight());
        boundaryBounds.setWidth((double)bounds.getWidth());
        boundaryBounds.setX(parentBounds.getX() + (double)xOffset);
        boundaryBounds.setY(parentBounds.getY() + (double)yOffset);
        boundaryShape.setBounds(boundaryBounds);
        boundaryShape.setId(this.modelExporter.getEObjectID((EObject)boundaryNode));
        this.attachLabel(boundaryNode, boundaryEvent.getName(), boundaryShape);
        return boundaryShape;
    }

    private void attachLabel(Node node, String labelText, BPMNShape elementShape) {
        Font font = this.createFont((View)node);
        if (font != null && labelText != null && !labelText.isBlank()) {
            BPMNLabel label = DiFactory.eINSTANCE.createBPMNLabel();
            BPMNLabelStyle labelStyle = this.getLabelStyle(font);
            label.setId(EcoreUtil.generateUUID());
            label.setLabelStyle(QName.valueOf(labelStyle.getId()));
            node.getPersistedChildren().stream().filter(DecorationNode.class::isInstance).map(DecorationNode.class::cast).filter(n -> ((DecorationNode)n).isVisible()).findFirst().ifPresent(labelNode -> {
                Location offsetLocation = this.modelExporter.getLocation((Node)labelNode);
                if (offsetLocation != null) {
                    org.eclipse.gmf.runtime.notation.Bounds absoluteBounds = NotationFactory.eINSTANCE.createBounds();
                    Dimension dimension = new Dimension((int)((double)labelText.length() * 7.42), 17);
                    absoluteBounds.setWidth(dimension.width);
                    absoluteBounds.setHeight(dimension.height);
                    org.eclipse.draw2d.geometry.Point location = this.toRectangle(elementShape.getBounds()).getBottom().getTranslated(new org.eclipse.draw2d.geometry.Point(offsetLocation.getX(), offsetLocation.getY()));
                    location.translate(-dimension.width / 2, 0);
                    absoluteBounds.setY(location.y);
                    absoluteBounds.setX(location.x);
                    Bounds elementBounds = DcFactory.eINSTANCE.createBounds();
                    elementBounds.setX((double)absoluteBounds.getX());
                    elementBounds.setY((double)absoluteBounds.getY());
                    elementBounds.setHeight((double)absoluteBounds.getHeight());
                    elementBounds.setWidth((double)absoluteBounds.getWidth());
                    label.setBounds(elementBounds);
                    elementShape.setBPMNLabel(label);
                }
            });
        }
    }

    private BPMNLabelStyle getLabelStyle(Font font) {
        Comparator fontComparator = (font1, font2) -> {
            for (EStructuralFeature f : DcPackage.Literals.FONT.getEStructuralFeatures()) {
                if (font1.eGet(f).equals(font2.eGet(f))) continue;
                return 1;
            }
            return 0;
        };
        for (BPMNLabelStyle style : this.bpmnDiagram.getBPMNLabelStyle()) {
            if (fontComparator.compare(style.getFont(), font) != 0) continue;
            return style;
        }
        BPMNLabelStyle labelStyle = DiFactory.eINSTANCE.createBPMNLabelStyle();
        labelStyle.setFont(font);
        labelStyle.setId(EcoreUtil.generateUUID());
        this.bpmnDiagram.getBPMNLabelStyle().add((Object)labelStyle);
        return labelStyle;
    }

    private Font createFont(View shape) {
        FontStyle fontStyle = (FontStyle)shape.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (fontStyle != null) {
            Font font = DcFactory.eINSTANCE.createFont();
            font.setIsBold(fontStyle.isBold());
            font.setIsItalic(fontStyle.isItalic());
            font.setIsStrikeThrough(fontStyle.isStrikeThrough());
            font.setIsUnderline(fontStyle.isUnderline());
            font.setName(fontStyle.getFontName());
            font.setSize((double)fontStyle.getFontHeight());
            return font;
        }
        return null;
    }

    public BPMNEdge createBPMNEdge(String bpmnFlowId, EObject semanticElement) {
        Edge bonitaEdge = this.modelExporter.getElementNotationEdge(semanticElement);
        if (bonitaEdge != null) {
            BPMNEdge edge = DiFactory.eINSTANCE.createBPMNEdge();
            edge.setBpmnElement(QName.valueOf(bpmnFlowId));
            edge.setId(this.modelExporter.getEObjectID((EObject)bonitaEdge));
            PolylineConnection conn = this.createConnectorFigure(bonitaEdge, semanticElement);
            PointList points = conn.getPoints();
            int i = 0;
            while (i < points.size()) {
                Point sourcePoint = DcFactory.eINSTANCE.createPoint();
                org.eclipse.draw2d.geometry.Point point = points.getPoint(i);
                sourcePoint.setX((double)point.x);
                sourcePoint.setY((double)point.y);
                edge.getWaypoint().add((Object)sourcePoint);
                ++i;
            }
            if (semanticElement instanceof SequenceFlow) {
                bonitaEdge.getPersistedChildren().stream().filter(DecorationNode.class::isInstance).filter(decoNode -> ((DecorationNode)decoNode).isVisible()).findFirst().ifPresent(decorationNode -> this.attachEdgeLabel((DecorationNode)decorationNode, edge, ((SequenceFlow)semanticElement).getName(), bonitaEdge));
            }
            return edge;
        }
        return null;
    }

    private void attachEdgeLabel(DecorationNode decorationNode, BPMNEdge edge, String labelText, Edge bonitaEdge) {
        Font font = this.createFont((View)bonitaEdge);
        if (font != null && labelText != null && !labelText.isBlank()) {
            BPMNLabel label = DiFactory.eINSTANCE.createBPMNLabel();
            Location relativeLocation = (Location)decorationNode.getLayoutConstraint();
            org.eclipse.draw2d.geometry.Point offSet = new org.eclipse.draw2d.geometry.Point(relativeLocation.getX(), relativeLocation.getY());
            org.eclipse.gmf.runtime.notation.Bounds absoluteBounds = NotationFactory.eINSTANCE.createBounds();
            PointList pList = new PointList();
            edge.getWaypoint().stream().map(wayPoint -> new PrecisionPoint(wayPoint.getX(), wayPoint.getY())).forEach(arg_0 -> ((PointList)pList).addPoint(arg_0));
            org.eclipse.draw2d.geometry.Point referencePoint = PointListUtilities.calculatePointRelativeToLine((PointList)pList, (int)0, (int)50, (boolean)true);
            org.eclipse.draw2d.geometry.Point location = LabelHelper.calculatePointRelativeToPointOnLine(pList, referencePoint, offSet);
            Dimension dimension = new Dimension((int)((double)labelText.length() * 7.42), 17);
            absoluteBounds.setWidth(dimension.width);
            absoluteBounds.setHeight(dimension.height);
            location.translate(-1 * dimension.width / 2, -1 * dimension.height / 2);
            absoluteBounds.setWidth(dimension.width);
            absoluteBounds.setHeight(dimension.height);
            absoluteBounds.setX(location.x);
            absoluteBounds.setY(location.y);
            Bounds elementBounds = DcFactory.eINSTANCE.createBounds();
            elementBounds.setX((double)absoluteBounds.getX());
            elementBounds.setY((double)absoluteBounds.getY());
            elementBounds.setHeight((double)absoluteBounds.getHeight());
            elementBounds.setWidth((double)absoluteBounds.getWidth());
            label.setBounds(elementBounds);
            edge.setBPMNLabel(label);
        }
    }

    private PolylineConnection createConnectorFigure(Edge bonitaEdge, EObject bonitaConnection) {
        PolylineConnection conn = new PolylineConnection();
        ObliqueRouter router = bonitaConnection instanceof TextAnnotationAttachment ? new ObliqueRouter() : new CustomRectilinearRouter();
        conn.setConnectionRouter((ConnectionRouter)router);
        SourceElement source = null;
        if (bonitaConnection instanceof Connection) {
            source = ((Connection)bonitaConnection).getSource();
        } else if (bonitaConnection instanceof TextAnnotationAttachment) {
            source = ((TextAnnotationAttachment)bonitaConnection).getSource();
        }
        TargetElement target = null;
        if (bonitaConnection instanceof Connection) {
            target = ((Connection)bonitaConnection).getTarget();
        } else if (bonitaConnection instanceof TextAnnotationAttachment) {
            target = ((TextAnnotationAttachment)bonitaConnection).getTarget();
        }
        IFigure sourceFigure = this.createAnchorFigure(this.toRectangle(this.getBPMNShapeBounds(this.modelExporter.getEObjectID((EObject)bonitaEdge.getSource()))), (EObject)source);
        IFigure targetFigure = this.createAnchorFigure(this.toRectangle(this.getBPMNShapeBounds(this.modelExporter.getEObjectID((EObject)bonitaEdge.getTarget()))), (EObject)target);
        List pointList = ((RelativeBendpoints)bonitaEdge.getBendpoints()).getPoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < pointList.size()) {
            org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint relativeBendpoint = (org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint)pointList.get(i);
            Anchor sourceAnchor = bonitaEdge.getSourceAnchor();
            if (sourceAnchor instanceof IdentityAnchor) {
                PrecisionPoint referencePoint = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)sourceAnchor).getId());
                conn.setSourceAnchor((ConnectionAnchor)new CustomAnchor(sourceFigure, referencePoint));
            } else {
                conn.setSourceAnchor((ConnectionAnchor)new CustomAnchor(sourceFigure));
            }
            Anchor targetAnchor = bonitaEdge.getTargetAnchor();
            if (targetAnchor instanceof IdentityAnchor) {
                PrecisionPoint referencePoint = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)targetAnchor).getId());
                conn.setTargetAnchor((ConnectionAnchor)new CustomAnchor(targetFigure, referencePoint));
            } else {
                conn.setTargetAnchor((ConnectionAnchor)new CustomAnchor(targetFigure));
            }
            RelativeBendpoint rbp = new RelativeBendpoint((org.eclipse.draw2d.Connection)conn);
            rbp.setRelativeDimensions(new Dimension(relativeBendpoint.getSourceX(), relativeBendpoint.getSourceY()), new Dimension(relativeBendpoint.getTargetX(), relativeBendpoint.getTargetY()));
            if (pointList.size() == 1) {
                rbp.setWeight(0.5f);
            } else {
                rbp.setWeight((float)i / ((float)pointList.size() - 1.0f));
            }
            figureConstraint.add(rbp);
            ++i;
        }
        conn.setRoutingConstraint(figureConstraint);
        router.route((org.eclipse.draw2d.Connection)conn);
        return conn;
    }

    private IFigure createAnchorFigure(Rectangle bounds, EObject semanticElement) {
        if (semanticElement instanceof BoundaryEvent) {
            return this.createBoundaryEventFigure(bounds);
        }
        if (semanticElement instanceof Event) {
            return this.createEventFigure(bounds);
        }
        if (semanticElement instanceof Gateway) {
            return this.createGatewayFigure(bounds);
        }
        Figure anchorFigure = new Figure();
        anchorFigure.setBounds(bounds);
        return anchorFigure;
    }

    private NodeFigure createEventFigure(final Rectangle nodeFigureBound) {
        return new DefaultSizeNodeFigure(30, 30){

            public Rectangle getHandleBounds() {
                return nodeFigureBound;
            }

            public PointList getPolygonPoints() {
                Rectangle anchRect = this.getHandleBounds();
                return BPMNShapeFactory.circlePointList(anchRect);
            }
        };
    }

    private NodeFigure createBoundaryEventFigure(final Rectangle nodeFigureBound) {
        return new DefaultSizeNodeFigure(25, 25){

            public Rectangle getHandleBounds() {
                return nodeFigureBound;
            }

            public PointList getPolygonPoints() {
                Rectangle anchRect = this.getHandleBounds();
                return BPMNShapeFactory.circlePointList(anchRect);
            }
        };
    }

    private NodeFigure createGatewayFigure(final Rectangle nodeFigureBound) {
        return new DefaultSizeNodeFigure(43, 43){

            public Rectangle getHandleBounds() {
                return nodeFigureBound;
            }

            public PointList getPolygonPoints() {
                PointList points = new PointList(5);
                Rectangle anchRect = this.getHandleBounds();
                points.addPoint(anchRect.x + anchRect.width / 2, anchRect.y);
                points.addPoint(anchRect.x + anchRect.width, anchRect.y + anchRect.height / 2);
                points.addPoint(anchRect.x + anchRect.width / 2, anchRect.y + anchRect.height);
                points.addPoint(anchRect.x, anchRect.y + anchRect.height / 2);
                points.addPoint(anchRect.x + anchRect.width / 2, anchRect.y);
                return points;
            }
        };
    }

    private Rectangle toRectangle(Bounds bounds) {
        return new PrecisionRectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private Bounds getBPMNShapeBounds(String shapeUUID) {
        return this.bpmnDiagram.getBPMNPlane().getDiagramElement().stream().filter(BPMNShape.class::isInstance).map(BPMNShape.class::cast).filter(shape -> Objects.equals(shape.getId(), shapeUUID)).map(Shape::getBounds).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No shape found with id %s", shapeUUID)));
    }

    static PointList circlePointList(Rectangle anchRect) {
        PointList points = new PointList(50);
        double angle = 0.12566370614359174;
        org.eclipse.draw2d.geometry.Point center = anchRect.getCenter();
        int centerX = center.x;
        int centerY = center.y;
        int halfWidth = anchRect.width / 2;
        int halfHeight = anchRect.height / 2;
        double angleT = 0.0;
        while (angleT < Math.PI * 2) {
            points.addPoint((int)((double)halfWidth * Math.cos(angleT) + (double)centerX), (int)((double)halfHeight * Math.sin(angleT) + (double)centerY));
            angleT += 0.12566370614359174;
        }
        points.addPoint((int)((double)halfWidth * Math.cos(0.0) + (double)centerX), (int)((double)halfHeight * Math.sin(0.0) + (double)centerY));
        return points;
    }
}

