/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo.data;

import java.util.Objects;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.bonitasoft.bonita2bpmn.transfo.data.XMLNamespaceResolver;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.XMLData;
import org.bonitasoft.bpm.model.process.util.DataUtil;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.omg.spec.bpmn.model.ModelFactory;
import org.omg.spec.bpmn.model.TDefinitions;
import org.omg.spec.bpmn.model.TDocumentation;
import org.omg.spec.bpmn.model.TItemDefinition;

public class ItemDefinitionFunction
implements Function<Data, TItemDefinition> {
    private final TDefinitions bpmnDefinitions;
    private final XMLNamespaceResolver xmlNamespaceResolver;
    private IModelSearch modelSearch;

    public ItemDefinitionFunction(TDefinitions bpmnDefinitions, XMLNamespaceResolver xmlNamespaceResolver, IModelSearch modelSearch) {
        this.modelSearch = modelSearch;
        this.bpmnDefinitions = Objects.requireNonNull(bpmnDefinitions);
        this.xmlNamespaceResolver = Objects.requireNonNull(xmlNamespaceResolver);
    }

    @Override
    public TItemDefinition apply(Data sourceElement) {
        ModelFactory modelFactory = ModelFactory.eINSTANCE;
        TItemDefinition dataItemDefinition = modelFactory.createTItemDefinition();
        dataItemDefinition.setId(this.modelSearch.getEObjectID((EObject)sourceElement));
        String documentation = sourceElement.getDocumentation();
        if (documentation != null && !documentation.isEmpty()) {
            TDocumentation doc = modelFactory.createTDocumentation();
            FeatureMapUtil.addText((FeatureMap)doc.getMixed(), (String)documentation);
            dataItemDefinition.getDocumentation().add((Object)doc);
        }
        dataItemDefinition.setStructureRef(this.getStructureRef(sourceElement));
        this.bpmnDefinitions.getRootElement().add((Object)dataItemDefinition);
        return dataItemDefinition;
    }

    private QName getStructureRef(Data data) {
        if (data instanceof XMLData) {
            XMLData xmlData = (XMLData)data;
            String xmlnsDataType = this.xmlNamespaceResolver.resolveNamespacePrefix(xmlData);
            return QName.valueOf(xmlnsDataType + ":" + xmlData.getType());
        }
        String qualifiedClassName = DataUtil.getTechnicalTypeFor((Data)data);
        return QName.valueOf("java:" + qualifiedClassName);
    }
}

