/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.bonitasoft.bonita2bpmn.extension.IBonitaModelExporter;
import org.bonitasoft.bonita2bpmn.transfo.BPMNShapeFactory;
import org.bonitasoft.bonita2bpmn.transfo.ConnectorDefinitionTransformer;
import org.bonitasoft.bonita2bpmn.transfo.ConnectorTransformationXSLProvider;
import org.bonitasoft.bonita2bpmn.transfo.ModelRegistry;
import org.bonitasoft.bonita2bpmn.transfo.TFlowElementSwitch;
import org.bonitasoft.bonita2bpmn.transfo.data.DataIOTransformer;
import org.bonitasoft.bonita2bpmn.transfo.data.DataScope;
import org.bonitasoft.bonita2bpmn.transfo.data.ItemDefinitionFunction;
import org.bonitasoft.bonita2bpmn.transfo.data.XMLNamespaceResolver;
import org.bonitasoft.bonita2bpmn.transfo.expression.FormalExpressionFunctionFactory;
import org.bonitasoft.bonita2bpmn.util.Strings;
import org.bonitasoft.bpm.connector.model.definition.ConnectorDefinition;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.process.AbstractTimerEvent;
import org.bonitasoft.bpm.model.process.Activity;
import org.bonitasoft.bpm.model.process.Actor;
import org.bonitasoft.bpm.model.process.BoundaryEvent;
import org.bonitasoft.bpm.model.process.BoundaryMessageEvent;
import org.bonitasoft.bpm.model.process.BoundarySignalEvent;
import org.bonitasoft.bpm.model.process.BoundaryTimerEvent;
import org.bonitasoft.bpm.model.process.CatchLinkEvent;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.DataAware;
import org.bonitasoft.bpm.model.process.Element;
import org.bonitasoft.bpm.model.process.FlowElement;
import org.bonitasoft.bpm.model.process.IntermediateErrorCatchEvent;
import org.bonitasoft.bpm.model.process.Lane;
import org.bonitasoft.bpm.model.process.LinkEvent;
import org.bonitasoft.bpm.model.process.MainProcess;
import org.bonitasoft.bpm.model.process.MessageFlow;
import org.bonitasoft.bpm.model.process.NonInterruptingBoundaryTimerEvent;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.SequenceFlow;
import org.bonitasoft.bpm.model.process.SignalEvent;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.process.TextAnnotation;
import org.bonitasoft.bpm.model.process.TextAnnotationAttachment;
import org.bonitasoft.bpm.model.process.ThrowLinkEvent;
import org.bonitasoft.bpm.model.process.XMLData;
import org.bonitasoft.bpm.model.process.XMLType;
import org.bonitasoft.bpm.model.process.util.DataUtil;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.ElementHandlerImpl;
import org.omg.spec.bpmn.di.BPMNDiagram;
import org.omg.spec.bpmn.di.BPMNEdge;
import org.omg.spec.bpmn.di.BPMNPlane;
import org.omg.spec.bpmn.di.BPMNShape;
import org.omg.spec.bpmn.di.DiFactory;
import org.omg.spec.bpmn.di.util.DiResourceFactoryImpl;
import org.omg.spec.bpmn.model.DocumentRoot;
import org.omg.spec.bpmn.model.ModelFactory;
import org.omg.spec.bpmn.model.TActivity;
import org.omg.spec.bpmn.model.TAssignment;
import org.omg.spec.bpmn.model.TAssociation;
import org.omg.spec.bpmn.model.TBaseElement;
import org.omg.spec.bpmn.model.TBoundaryEvent;
import org.omg.spec.bpmn.model.TCallableElement;
import org.omg.spec.bpmn.model.TCollaboration;
import org.omg.spec.bpmn.model.TComplexGateway;
import org.omg.spec.bpmn.model.TDataInput;
import org.omg.spec.bpmn.model.TDataInputAssociation;
import org.omg.spec.bpmn.model.TDataObject;
import org.omg.spec.bpmn.model.TDefinitions;
import org.omg.spec.bpmn.model.TDocumentation;
import org.omg.spec.bpmn.model.TErrorEventDefinition;
import org.omg.spec.bpmn.model.TExclusiveGateway;
import org.omg.spec.bpmn.model.TExpression;
import org.omg.spec.bpmn.model.TFlowElement;
import org.omg.spec.bpmn.model.TFormalExpression;
import org.omg.spec.bpmn.model.TInclusiveGateway;
import org.omg.spec.bpmn.model.TInputOutputSpecification;
import org.omg.spec.bpmn.model.TInputSet;
import org.omg.spec.bpmn.model.TItemDefinition;
import org.omg.spec.bpmn.model.TLane;
import org.omg.spec.bpmn.model.TLaneSet;
import org.omg.spec.bpmn.model.TLinkEventDefinition;
import org.omg.spec.bpmn.model.TMessageEventDefinition;
import org.omg.spec.bpmn.model.TMessageFlow;
import org.omg.spec.bpmn.model.TOutputSet;
import org.omg.spec.bpmn.model.TParticipant;
import org.omg.spec.bpmn.model.TProcess;
import org.omg.spec.bpmn.model.TProperty;
import org.omg.spec.bpmn.model.TSequenceFlow;
import org.omg.spec.bpmn.model.TSignal;
import org.omg.spec.bpmn.model.TSubProcess;
import org.omg.spec.bpmn.model.TText;
import org.omg.spec.bpmn.model.TTextAnnotation;
import org.omg.spec.bpmn.model.util.ModelResourceFactoryImpl;
import org.omg.spec.dd.dc.Bounds;
import org.omg.spec.dd.di.Shape;

@Creatable
public class BonitaToBPMNExporter {
    private static final String JAVA_XMLNS = "java";
    private final Map<Element, TFlowElement> mapping = new HashMap<Element, TFlowElement>();
    private final Map<Actor, TParticipant> participantMapping = new HashMap<Actor, TParticipant>();
    private BPMNPlane bpmnPlane;
    private TCollaboration collaboration;
    private DocumentRoot root;
    private XMLNamespaceResolver xmlNamespaceResolver;
    private final FormalExpressionFunctionFactory formalExpressionTransformerFactory = new FormalExpressionFunctionFactory();
    private IModelSearch modelSearch;
    private MultiStatus status;
    private TFlowElementSwitch flowElementSwitch;
    private ModelRegistry modelRegistry;

    public void export(IBonitaModelExporter modelExporter, IModelSearch modelSearch, Supplier<List<ConnectorDefinition>> connectorDefContextProvider, File destFile, ConnectorTransformationXSLProvider connectorXSLProvider, String currentVersion) {
        this.modelSearch = modelSearch;
        MainProcess mainProcess = modelExporter.getMainProcess();
        this.initializeDocumentRoot();
        TDefinitions definitions = ModelFactory.eINSTANCE.createTDefinitions();
        definitions.setExpressionLanguage("http://groovy.apache.org/");
        this.collaboration = ModelFactory.eINSTANCE.createTCollaboration();
        this.setCommonAttributes((Element)mainProcess, (TBaseElement)this.collaboration);
        definitions.getRootElement().add((Object)this.collaboration);
        BPMNDiagram bpmnDiagram = DiFactory.eINSTANCE.createBPMNDiagram();
        bpmnDiagram.setName(mainProcess.getName());
        this.bpmnPlane = DiFactory.eINSTANCE.createBPMNPlane();
        bpmnDiagram.setBPMNPlane(this.bpmnPlane);
        QName rootQNameIDValue = QName.valueOf(this.collaboration.getId());
        this.bpmnPlane.setBpmnElement(rootQNameIDValue);
        this.bpmnPlane.setId("plane_" + this.collaboration.getId());
        definitions.getBPMNDiagram().add((Object)bpmnDiagram);
        definitions.setTargetNamespace("http://bonitasoft.com/" + String.valueOf(rootQNameIDValue));
        definitions.setExporter("BonitaSoft");
        definitions.setExporterVersion(currentVersion);
        DataScope dataScope = new DataScope(new ItemDefinitionFunction(definitions, this.xmlNamespaceResolver, modelSearch));
        this.modelRegistry = new ModelRegistry(definitions, dataScope);
        this.modelRegistry.addError("Forms and other resources are not exported.");
        ConnectorDefinitionTransformer connectorDefinitionTransformer = new ConnectorDefinitionTransformer(destFile.toPath().getParent().resolve("connectorDefs"), connectorDefContextProvider, connectorXSLProvider, this.modelRegistry);
        this.configureNamespaces();
        this.flowElementSwitch = new TFlowElementSwitch(modelSearch, connectorDefinitionTransformer, this.formalExpressionTransformerFactory, this.modelRegistry);
        BPMNShapeFactory shapeFactory = new BPMNShapeFactory(modelExporter, bpmnDiagram);
        modelExporter.getPools().stream().forEach(pool -> this.processPool(shapeFactory, (Pool)pool, definitions, this.collaboration));
        this.populateWithMessageFlow(mainProcess);
        this.populateWithSignals(definitions);
        this.handleLinkEvents();
        this.handleMessageEvents();
        this.root.setDefinitions(definitions);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(".bpmn", new ModelResourceFactoryImpl());
        if (destFile.exists()) {
            try {
                Files.delete(destFile.toPath());
            }
            catch (IOException e) {
                this.status = this.createErrorStatus(e);
                return;
            }
        }
        Resource resource = new DiResourceFactoryImpl().createResource(URI.createFileURI((String)destFile.getAbsolutePath()));
        resourceSet.getResources().add((Object)resource);
        resource.getContents().add((Object)this.root);
        try {
            try {
                HashMap<String, Object> saveOptions = new HashMap<String, Object>();
                saveOptions.put("ELEMENT_HANDLER", new ElementHandlerImpl(false));
                saveOptions.put("ENCODING", "UTF-8");
                resource.save(saveOptions);
                this.status = this.createOKStatus();
            }
            catch (Exception ex) {
                this.status = this.createErrorStatus(ex);
                resource.unload();
            }
        }
        finally {
            resource.unload();
        }
    }

    private void handleMessageEvents() {
        this.modelRegistry.getMessages().stream().map(event -> {
            TMessageEventDefinition message = ModelFactory.eINSTANCE.createTMessageEventDefinition();
            message.setId(event);
            return message;
        }).forEach(arg_0 -> this.modelRegistry.getDefinitions().getRootElement().add(arg_0));
    }

    private void handleLinkEvents() {
        for (Map.Entry<LinkEvent, TLinkEventDefinition> entry : this.modelRegistry.getLinkEvents().entrySet()) {
            TLinkEventDefinition eventDefinition;
            if (entry.getKey() instanceof ThrowLinkEvent) {
                ThrowLinkEvent throwLink = (ThrowLinkEvent)entry.getKey();
                eventDefinition = entry.getValue();
                if (throwLink.getTo() == null) continue;
                eventDefinition.setName(Strings.slugify(throwLink.getTo().getName()));
                continue;
            }
            if (!(entry.getKey() instanceof CatchLinkEvent)) continue;
            CatchLinkEvent catchLink = (CatchLinkEvent)entry.getKey();
            eventDefinition = entry.getValue();
            for (ThrowLinkEvent from : catchLink.getFrom()) {
                TLinkEventDefinition sourceEvent = this.modelRegistry.getLinkEvents().get(from);
                eventDefinition.getSource().add((Object)QName.valueOf(sourceEvent.getId()));
            }
        }
    }

    private void configureNamespaces() {
        this.root.getXMLNSPrefixMap().put((Object)JAVA_XMLNS, (Object)"http://jcp.org/en/jsr/detail?id=270");
        this.root.getXMLNSPrefixMap().put((Object)"bonitaConnector", (Object)"http://www.bonitasoft.org/studio/connector/definition/6.0");
        this.root.getXMLNSPrefixMap().put((Object)"xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        this.root.getXSISchemaLocation().put((Object)"schemaLocation", (Object)"http://www.omg.org/spec/BPMN/20100524/MODEL schemas/BPMN20.xsd");
    }

    private void initializeDocumentRoot() {
        this.root = ModelFactory.eINSTANCE.createDocumentRoot();
        this.xmlNamespaceResolver = new XMLNamespaceResolver(this.root);
    }

    private void setCommonAttributes(Element bonitaElement, TBaseElement bpmnElement) {
        bpmnElement.setId(this.modelSearch.getEObjectID((EObject)bonitaElement));
        if (bpmnElement instanceof TFlowElement) {
            ((TFlowElement)bpmnElement).setName(bonitaElement.getName());
        } else if (bpmnElement instanceof TProcess) {
            ((TProcess)bpmnElement).setName(bonitaElement.getName());
        } else if (bpmnElement instanceof TParticipant) {
            ((TParticipant)bpmnElement).setName(bonitaElement.getName());
        }
        String documentation = bonitaElement.getDocumentation();
        if (documentation != null && !documentation.isEmpty()) {
            TDocumentation doc = ModelFactory.eINSTANCE.createTDocumentation();
            FeatureMapUtil.addCDATA((FeatureMap)doc.getMixed(), (String)documentation);
            bpmnElement.getDocumentation().add((Object)doc);
        }
    }

    private void populateWithMessageFlow(MainProcess mainProcess) {
        for (MessageFlow messageFlow : mainProcess.getMessageConnections()) {
            TMessageFlow bpmnMessageFlow = ModelFactory.eINSTANCE.createTMessageFlow();
            this.setCommonAttributes((Element)messageFlow, (TBaseElement)bpmnMessageFlow);
            TFlowElement source = this.mapping.get(messageFlow.getSource());
            bpmnMessageFlow.setSourceRef(QName.valueOf(source.getId()));
            TFlowElement target = this.mapping.get(messageFlow.getTarget());
            bpmnMessageFlow.setTargetRef(QName.valueOf(target.getId()));
            this.collaboration.getMessageFlow().add((Object)bpmnMessageFlow);
        }
    }

    private void processPool(BPMNShapeFactory shapeFactory, Pool pool, TDefinitions definitions, TCollaboration collaboration) {
        TProcess bpmnProcess = ModelFactory.eINSTANCE.createTProcess();
        this.setCommonAttributes((Element)pool, (TBaseElement)bpmnProcess);
        definitions.getRootElement().add((Object)bpmnProcess);
        TParticipant participant = ModelFactory.eINSTANCE.createTParticipant();
        participant.setProcessRef(QName.valueOf(bpmnProcess.getId()));
        participant.setName(bpmnProcess.getName());
        participant.setId(EcoreUtil.generateUUID());
        collaboration.getParticipant().add((Object)participant);
        for (Actor actor : pool.getActors()) {
            TParticipant actorParticipant = ModelFactory.eINSTANCE.createTParticipant();
            this.setCommonAttributes((Element)actor, (TBaseElement)actorParticipant);
            collaboration.getParticipant().add((Object)actorParticipant);
            this.participantMapping.put(actor, actorParticipant);
        }
        BPMNShape processShape = shapeFactory.createPool(participant.getId(), pool);
        this.bpmnPlane.getDiagramElement().add((Object)processShape);
        this.populateWithData(pool, bpmnProcess);
        this.populate(shapeFactory, pool, this.modelSearch.getAllItemsOfType((EObject)pool, Lane.class), bpmnProcess, processShape.getBounds());
        this.populateWithSequenceFlow(shapeFactory, pool, bpmnProcess);
        this.populateWithTextAnnotation(shapeFactory, pool, bpmnProcess, processShape.getBounds());
    }

    private void populateWithTextAnnotation(BPMNShapeFactory shapeFactory, Pool pool, TProcess bpmnProcess, Bounds processBounds) {
        bpmnProcess.getArtifact().addAll((Collection)this.modelSearch.getAllItemsOfType((EObject)pool, TextAnnotation.class).stream().map(source -> this.createAnnotation(shapeFactory, pool, bpmnProcess, processBounds, (TextAnnotation)source)).collect(Collectors.toList()));
    }

    private TTextAnnotation createAnnotation(BPMNShapeFactory shapeFactory, Pool pool, TProcess bpmnProcess, Bounds processBounds, TextAnnotation source) {
        TTextAnnotation annotation = ModelFactory.eINSTANCE.createTTextAnnotation();
        TText text = ModelFactory.eINSTANCE.createTText();
        FeatureMapUtil.addCDATA((FeatureMap)text.getMixed(), (String)source.getText());
        annotation.setText(text);
        annotation.setId(EcoreUtil.generateUUID());
        List textAnnotationAttachments = this.modelSearch.getAllItemsOfType((EObject)pool, TextAnnotationAttachment.class);
        EObject eContainer = source.eContainer() instanceof SubProcessEvent ? source.eContainer().eContainer() : source.eContainer();
        String containerId = this.modelSearch.getEObjectID(eContainer);
        Bounds containerBounds = this.bpmnPlane.getDiagramElement().stream().filter(BPMNShape.class::isInstance).map(BPMNShape.class::cast).filter(shape -> Objects.equals(shape.getBpmnElement().getLocalPart(), containerId)).findFirst().map(Shape::getBounds).orElseGet(() -> processBounds);
        BPMNShape elementShape = shapeFactory.create((EObject)source, annotation.getId(), containerBounds);
        this.bpmnPlane.getDiagramElement().add((Object)elementShape);
        for (TextAnnotationAttachment attachement : textAnnotationAttachments) {
            TFlowElement tFlowElement;
            if (!Objects.equals(attachement.getSource(), source) || (tFlowElement = this.mapping.get(attachement.getTarget())) == null || !Strings.hasText(tFlowElement.getId())) continue;
            TAssociation association = ModelFactory.eINSTANCE.createTAssociation();
            association.setId(EcoreUtil.generateUUID());
            association.setSourceRef(QName.valueOf(annotation.getId()));
            association.setTargetRef(QName.valueOf(this.mapping.get(attachement.getTarget()).getId()));
            bpmnProcess.getArtifact().add((Object)association);
            BPMNEdge edge = shapeFactory.createBPMNEdge(association.getId(), (EObject)attachement);
            if (edge == null) continue;
            this.bpmnPlane.getDiagramElement().add((Object)edge);
        }
        return annotation;
    }

    private void populateWithSignals(TDefinitions definitions) {
        definitions.getRootElement().addAll(this.modelRegistry.getSignals());
    }

    private void populateWithData(Pool pool, TProcess bpmnProcess) {
        DataScope dataScope = this.modelRegistry.getDataScope();
        dataScope.initializeContext((DataAware)pool);
        for (Data bonitaData : pool.getData()) {
            TItemDefinition dataItemDefinition = dataScope.get(bonitaData);
            QName dataItemDefinitionIdAsQname = QName.valueOf(dataItemDefinition.getId());
            TDataObject dataObject = this.createDataObject(bpmnProcess, bonitaData, dataItemDefinitionIdAsQname);
            TDataInput tDataInput = DataIOTransformer.fillIOSpecification((TCallableElement)bpmnProcess, dataItemDefinitionIdAsQname);
            Expression defaultValue = bonitaData.getDefaultValue();
            if (defaultValue == null) continue;
            TDataInputAssociation tDataInputAssociation = this.createDataInputAssociation(tDataInput, defaultValue);
            dataObject.setItemSubjectRef(dataItemDefinitionIdAsQname);
            tDataInputAssociation.getAnyAttribute();
        }
        TInputOutputSpecification ioSpecification = bpmnProcess.getIoSpecification();
        if (ioSpecification == null) {
            ioSpecification = ModelFactory.eINSTANCE.createTInputOutputSpecification();
            ioSpecification.setId(EcoreUtil.generateUUID());
            bpmnProcess.setIoSpecification(ioSpecification);
        }
        if (ioSpecification.getInputSet().isEmpty()) {
            TInputSet createTInputSet = ModelFactory.eINSTANCE.createTInputSet();
            createTInputSet.setId(EcoreUtil.generateUUID());
            ioSpecification.getInputSet().add((Object)createTInputSet);
        }
        if (ioSpecification.getOutputSet().isEmpty()) {
            TOutputSet createTOutputSet = ModelFactory.eINSTANCE.createTOutputSet();
            createTOutputSet.setId(EcoreUtil.generateUUID());
            ioSpecification.getOutputSet().add((Object)createTOutputSet);
        }
    }

    private TDataInputAssociation createDataInputAssociation(TDataInput tDataInput, Expression defaultValue) {
        TDataInputAssociation tDataInputAssociation = ModelFactory.eINSTANCE.createTDataInputAssociation();
        tDataInputAssociation.setId(EcoreUtil.generateUUID());
        tDataInputAssociation.setTargetRef(tDataInput.getId());
        EList assignment = tDataInputAssociation.getAssignment();
        TAssignment tAssignment = ModelFactory.eINSTANCE.createTAssignment();
        TFormalExpression toExpression = ModelFactory.eINSTANCE.createTFormalExpression();
        toExpression.setId(EcoreUtil.generateUUID());
        FeatureMapUtil.addText((FeatureMap)toExpression.getMixed(), (String)tDataInput.getId());
        tAssignment.setTo((TExpression)toExpression);
        TFormalExpression fromExpression = this.convertExpression(defaultValue);
        tAssignment.setFrom((TExpression)fromExpression);
        assignment.add((Object)tAssignment);
        return tDataInputAssociation;
    }

    private TDataObject createDataObject(TProcess bpmnProcess, Data bonitaData, QName dataItemDefinitionIdAsQname) {
        TDataObject bpmnData = ModelFactory.eINSTANCE.createTDataObject();
        bpmnData.setItemSubjectRef(dataItemDefinitionIdAsQname);
        this.setCommonAttributes((Element)bonitaData, (TBaseElement)bpmnData);
        bpmnData.setName(bonitaData.getName());
        bpmnData.setId("DataObject" + EcoreUtil.generateUUID() + bpmnData.getId());
        bpmnProcess.getFlowElement().add((Object)bpmnData);
        bpmnData.setIsCollection(bonitaData.isMultiple());
        return bpmnData;
    }

    private TItemDefinition createDataItemDefinition(Data bonitaData) {
        TItemDefinition dataItemDefinition = ModelFactory.eINSTANCE.createTItemDefinition();
        this.setCommonAttributes((Element)bonitaData, (TBaseElement)dataItemDefinition);
        dataItemDefinition.setStructureRef(this.getStructureRef(bonitaData));
        this.modelRegistry.getDefinitions().getRootElement().add((Object)dataItemDefinition);
        return dataItemDefinition;
    }

    private TFormalExpression convertExpression(Expression bonitaExpression) {
        return this.formalExpressionTransformerFactory.newFormalExpressionFunction(this.modelRegistry.getDataScope(), bonitaExpression.getType(), this.modelSearch).apply(bonitaExpression);
    }

    private QName getStructureRef(Data data) {
        if (data.getDataType() instanceof XMLType) {
            String xmlnsDataType = this.xmlNamespaceResolver.resolveNamespacePrefix((XMLData)data);
            return QName.valueOf(xmlnsDataType + ":" + ((XMLData)data).getType());
        }
        String technicalTypeFor = DataUtil.getTechnicalTypeFor((Data)data);
        return QName.valueOf("java:" + technicalTypeFor);
    }

    private void populateWithSequenceFlow(BPMNShapeFactory shapeFactory, Pool pool, TProcess bpmnProcess) {
        this.modelSearch.getAllItemsOfType((EObject)pool, SequenceFlow.class).stream().forEach(bonitaFlow -> this.handleSequenceFlow(shapeFactory, bpmnProcess, (SequenceFlow)bonitaFlow));
    }

    private void handleSequenceFlow(BPMNShapeFactory shapeFactory, TProcess bpmnProcess, SequenceFlow bonitaFlow) {
        TFlowElement source;
        TSequenceFlow bpmnFlow = ModelFactory.eINSTANCE.createTSequenceFlow();
        this.setCommonAttributes((Element)bonitaFlow, (TBaseElement)bpmnFlow);
        if (!bonitaFlow.isIsDefault() && bonitaFlow.getCondition() != null && bonitaFlow.getCondition().hasContent()) {
            bpmnFlow.setConditionExpression((TExpression)this.convertExpression(bonitaFlow.getCondition()));
        }
        if ((source = this.mapping.get(bonitaFlow.getSource())) != null) {
            bpmnFlow.setSourceRef(source.getId());
            TFlowElement target = this.mapping.get(bonitaFlow.getTarget());
            if (target != null) {
                this.createSequenceFlow(shapeFactory, bpmnProcess, bonitaFlow, bpmnFlow, source, target);
            }
        }
    }

    private void createSequenceFlow(BPMNShapeFactory shapeFactory, TProcess bpmnProcess, SequenceFlow bonitaFlow, TSequenceFlow bpmnFlow, TFlowElement source, TFlowElement target) {
        BPMNEdge edge;
        bpmnFlow.setTargetRef(target.getId());
        bpmnProcess.getFlowElement().add((Object)bpmnFlow);
        if (bonitaFlow.isIsDefault() && bonitaFlow instanceof SequenceFlow) {
            if (source instanceof TInclusiveGateway) {
                ((TInclusiveGateway)source).setDefault(bpmnFlow.getId());
            } else if (source instanceof TExclusiveGateway) {
                ((TExclusiveGateway)source).setDefault(bpmnFlow.getId());
            } else if (source instanceof TComplexGateway) {
                ((TComplexGateway)source).setDefault(bpmnFlow.getId());
            } else if (source instanceof TActivity) {
                ((TActivity)source).setDefault(bpmnFlow.getId());
            }
        }
        if ((edge = shapeFactory.createBPMNEdge(bpmnFlow.getId(), (EObject)bonitaFlow)) != null) {
            this.bpmnPlane.getDiagramElement().add((Object)edge);
        }
    }

    private void populate(BPMNShapeFactory shapeFactory, Pool pool, List<Lane> lanes, TProcess bpmnProcess, Bounds poolBounds) {
        if (lanes.isEmpty()) {
            this.populateContainer(shapeFactory, (EObject)pool, bpmnProcess, null, poolBounds);
        } else {
            TLaneSet laneSet = ModelFactory.eINSTANCE.createTLaneSet();
            laneSet.setId(Strings.slugify(bpmnProcess.getName()) + "_laneSet");
            bpmnProcess.getLaneSet().add((Object)laneSet);
            lanes.stream().forEach(lane -> {
                TLane bpmnLane = ModelFactory.eINSTANCE.createTLane();
                bpmnLane.setName(lane.getName());
                bpmnLane.setId(lane.getName());
                this.setCommonAttributes((Element)lane, (TBaseElement)bpmnLane);
                laneSet.getLane().add((Object)bpmnLane);
                BPMNShape laneShape = shapeFactory.createLane(bpmnLane.getId(), (Lane)lane, poolBounds);
                this.bpmnPlane.getDiagramElement().add((Object)laneShape);
                this.populateContainer(shapeFactory, (EObject)lane, bpmnProcess, bpmnLane, laneShape.getBounds());
            });
        }
    }

    private void populateContainer(BPMNShapeFactory shapeFactory, EObject container, TProcess bpmnProcess, TLane bpmnParentLane, Bounds parentBounds) {
        HashMap localDataMap = new HashMap();
        container.eAllContents().forEachRemaining(element -> {
            if (element instanceof FlowElement && Objects.equals(container, element.eContainer())) {
                FlowElement bonitaElement = (FlowElement)element;
                TFlowElement bpmnElement = this.createTFlowElement((Element)bonitaElement);
                bpmnProcess.getFlowElement().add((Object)bpmnElement);
                if (bpmnParentLane != null) {
                    bpmnParentLane.getFlowNodeRef().add((Object)bpmnElement.getId());
                }
                this.mapping.put((Element)bonitaElement, bpmnElement);
                this.populateDataOnActivity(bpmnProcess, localDataMap, (EObject)bonitaElement, bpmnElement);
                BPMNShape elementShape = shapeFactory.create((EObject)bonitaElement, bpmnElement.getId(), parentBounds);
                this.bpmnPlane.getDiagramElement().add((Object)elementShape);
                if (bonitaElement instanceof Activity) {
                    this.createBoundaries(shapeFactory, bpmnProcess, (Activity)bonitaElement, bpmnElement, elementShape);
                }
            } else if (element instanceof SubProcessEvent) {
                SubProcessEvent subProcEvent = (SubProcessEvent)element;
                TSubProcess bpmnSubProcess = (TSubProcess)this.createTFlowElement((Element)subProcEvent);
                bpmnProcess.getFlowElement().add((Object)bpmnSubProcess);
                if (bpmnParentLane != null) {
                    bpmnParentLane.getFlowNodeRef().add((Object)bpmnSubProcess.getId());
                }
                this.mapping.put((Element)subProcEvent, (TFlowElement)bpmnSubProcess);
                BPMNShape elementShape = shapeFactory.create((EObject)subProcEvent, bpmnSubProcess.getId(), parentBounds);
                this.bpmnPlane.getDiagramElement().add((Object)elementShape);
                this.populateContainer(shapeFactory, subProcEvent, bpmnSubProcess, parentBounds);
            }
        });
    }

    private void createBoundaries(BPMNShapeFactory shapeFactory, TProcess bpmnProcess, Activity activity, TFlowElement bpmnElement, BPMNShape parentShape) {
        for (BoundaryEvent boundaryEvent : activity.getBoundaryIntermediateEvents()) {
            this.createBoundaryEvent(shapeFactory, bpmnProcess, bpmnElement, parentShape, boundaryEvent);
        }
    }

    private void createBoundaryEvent(BPMNShapeFactory shapeFactory, TProcess bpmnProcess, TFlowElement bpmnElement, BPMNShape parentShape, BoundaryEvent boundaryEvent) {
        TBoundaryEvent bpmnBoundary = ModelFactory.eINSTANCE.createTBoundaryEvent();
        this.setCommonAttributes((Element)boundaryEvent, (TBaseElement)bpmnBoundary);
        if (boundaryEvent instanceof IntermediateErrorCatchEvent) {
            TErrorEventDefinition errorventDef = ModelFactory.eINSTANCE.createTErrorEventDefinition();
            errorventDef.setId("eventdef-" + boundaryEvent.getName() + EcoreUtil.generateUUID());
            String errorCode = ((IntermediateErrorCatchEvent)boundaryEvent).getErrorCode();
            if (errorCode != null && errorCode.length() != 0) {
                errorventDef.setErrorRef(QName.valueOf(errorCode));
            }
            bpmnBoundary.getEventDefinition().add((Object)errorventDef);
        } else if (boundaryEvent instanceof BoundarySignalEvent) {
            eventDef = ModelFactory.eINSTANCE.createTSignalEventDefinition();
            eventDef.setId("eventdef-" + boundaryEvent.getName() + EcoreUtil.generateUUID());
            TSignal tSignal = this.flowElementSwitch.getOrCreateTSignal((SignalEvent)boundaryEvent);
            if (tSignal != null) {
                eventDef.setSignalRef(QName.valueOf(tSignal.getId()));
            }
            bpmnBoundary.getEventDefinition().add((Object)eventDef);
        } else if (boundaryEvent instanceof BoundaryMessageEvent) {
            String eventCaught = ((BoundaryMessageEvent)boundaryEvent).getEvent();
            String eventId = eventCaught != null && !eventCaught.isBlank() ? eventCaught : EcoreUtil.generateUUID();
            bpmnBoundary.getEventDefinitionRef().add((Object)QName.valueOf(eventId));
            this.modelRegistry.addMessage(eventId);
        } else if (boundaryEvent instanceof BoundaryTimerEvent) {
            eventDef = this.flowElementSwitch.createTimerEventDef((AbstractTimerEvent)boundaryEvent);
            bpmnBoundary.getEventDefinition().add((Object)eventDef);
        }
        bpmnBoundary.setCancelActivity(!(boundaryEvent instanceof NonInterruptingBoundaryTimerEvent));
        bpmnBoundary.setAttachedToRef(QName.valueOf(bpmnElement.getId()));
        bpmnProcess.getFlowElement().add((Object)bpmnBoundary);
        this.mapping.put((Element)boundaryEvent, (TFlowElement)bpmnBoundary);
        BPMNShape boundaryShape = shapeFactory.createBoundary(boundaryEvent, bpmnBoundary, parentShape.getBounds());
        this.bpmnPlane.getDiagramElement().add((Object)boundaryShape);
    }

    private void populateContainer(BPMNShapeFactory shapeFactory, SubProcessEvent container, TSubProcess bpmnSubProcess, Bounds parentBounds) {
        container.eAllContents().forEachRemaining(element -> {
            if (element instanceof FlowElement) {
                FlowElement bonitaElement = (FlowElement)element;
                TFlowElement bpmnElement = this.createTFlowElement((Element)bonitaElement);
                bpmnSubProcess.getFlowElement().add((Object)bpmnElement);
                this.mapping.put((Element)bonitaElement, bpmnElement);
                BPMNShape elementShape = shapeFactory.create((EObject)bonitaElement, bpmnElement.getId(), parentBounds);
                this.bpmnPlane.getDiagramElement().add((Object)elementShape);
            }
        });
    }

    private void populateDataOnActivity(TProcess bpmnProcess, Map<Data, TItemDefinition> localDataMap, EObject resolvedSemanticElement, TFlowElement bpmnElement) {
        if (resolvedSemanticElement instanceof DataAware && bpmnElement instanceof TActivity) {
            for (Data bonitaData : ((DataAware)resolvedSemanticElement).getData()) {
                TItemDefinition dataItemDefinition = this.createDataItemDefinition(bonitaData);
                localDataMap.put(bonitaData, dataItemDefinition);
                QName dataItemDefinitionIdAsQname = QName.valueOf(dataItemDefinition.getId());
                if (!bonitaData.isTransient()) {
                    this.createDataObject(bpmnProcess, bonitaData, dataItemDefinitionIdAsQname);
                } else {
                    TProperty tProperty = ModelFactory.eINSTANCE.createTProperty();
                    tProperty.setId(EcoreUtil.generateUUID());
                    tProperty.setName(bonitaData.getName());
                    tProperty.setItemSubjectRef(dataItemDefinitionIdAsQname);
                    ((TActivity)bpmnElement).getProperty().add((Object)tProperty);
                }
                TDataInput tDataInput = DataIOTransformer.fillIOSpecificationWithNewDataInput((TActivity)bpmnElement, dataItemDefinitionIdAsQname);
                if (bonitaData.getDefaultValue() == null || bonitaData.getDefaultValue().getName() == null) continue;
                EList dataInputAssociation = ((TActivity)bpmnElement).getDataInputAssociation();
                dataInputAssociation.add(this.createDataInputAssociation(tDataInput, bonitaData.getDefaultValue()));
            }
        }
    }

    private TFlowElement createTFlowElement(Element child) {
        TFlowElement flowElement = (TFlowElement)this.flowElementSwitch.doSwitch((EObject)child);
        if (flowElement == null) {
            this.modelRegistry.addError(String.format("Could not find a valuable replacement for %s. Put an activity instead.", child.getName()));
            flowElement = ModelFactory.eINSTANCE.createTTask();
        }
        this.setCommonAttributes(child, (TBaseElement)flowElement);
        return flowElement;
    }

    private MultiStatus createErrorStatus(Throwable t) {
        MultiStatus multiStatus = new MultiStatus(BonitaToBPMNExporter.class, 0, null, null);
        multiStatus.add((IStatus)new Status(4, BonitaToBPMNExporter.class, t.getMessage(), t));
        this.exportLimitations().stream().forEach(arg_0 -> ((MultiStatus)multiStatus).add(arg_0));
        return multiStatus;
    }

    private MultiStatus createOKStatus() {
        MultiStatus multiStatus = new MultiStatus(BonitaToBPMNExporter.class, 0, null, null);
        this.exportLimitations().stream().forEach(arg_0 -> ((MultiStatus)multiStatus).add(arg_0));
        return multiStatus;
    }

    private List<IStatus> exportLimitations() {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        this.modelRegistry.getErrors().stream().map(message -> new Status(1, BonitaToBPMNExporter.class, message)).forEach(result::add);
        return result;
    }

    public MultiStatus getStatus() {
        return this.status;
    }
}

