/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class LabelHelper {
    private LabelHelper() {
    }

    public static Point calculatePointRelativeToPointOnLine(PointList ptLst, Point ptOnLine, Point offset) {
        if (ptLst.size() == 1) {
            return ptLst.getFirstPoint().getTranslated(offset);
        }
        if (ptLst.size() >= 2) {
            int index = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)ptLst, (Point)ptOnLine);
            if (index < 1) {
                return ptLst.getFirstPoint().getTranslated(offset);
            }
            LineSeg segment = (LineSeg)PointListUtilities.getLineSegments((PointList)ptLst).get(index - 1);
            if (segment != null) {
                return LabelHelper.calculateFromSegment(ptOnLine, offset, segment);
            }
        }
        return null;
    }

    private static Point calculateFromSegment(Point ptOnLine, Point offset, LineSeg segment) {
        if (segment.isHorizontal()) {
            if (segment.getOrigin().x > segment.getTerminus().x) {
                return ptOnLine.getTranslated(offset.getNegated());
            }
            return ptOnLine.getTranslated(offset);
        }
        if (segment.isVertical()) {
            if (segment.getOrigin().y > segment.getTerminus().y) {
                return ptOnLine.getTranslated(offset.getCopy().scale(-1.0, 1.0).transpose());
            }
            return ptOnLine.getTranslated(offset.getCopy().scale(1.0, -1.0).transpose());
        }
        double slope = segment.slope();
        double theta = Math.atan(slope);
        Point normalizedOffset = new Point(offset);
        if (segment.getOrigin().x > segment.getTerminus().x) {
            normalizedOffset = offset.getCopy().scale(-1.0, -1.0);
        }
        PrecisionPoint calculatedOffset = new PrecisionPoint((double)normalizedOffset.x * Math.cos(theta) - (double)normalizedOffset.y * Math.sin(theta), (double)normalizedOffset.x * Math.sin(theta) + (double)normalizedOffset.y * Math.cos(theta));
        return ptOnLine.getTranslated((Point)calculatedOffset);
    }
}

