/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.transfo.data;

import java.util.Map;
import java.util.Objects;
import org.bonitasoft.bpm.model.process.XMLData;
import org.eclipse.emf.common.util.EMap;
import org.omg.spec.bpmn.model.DocumentRoot;

public class XMLNamespaceResolver {
    private int cuurentNamespaceCounter;
    private final EMap<String, String> namespacePrefixRegistry;

    public XMLNamespaceResolver(DocumentRoot documentRoot) {
        this.namespacePrefixRegistry = Objects.requireNonNull(documentRoot).getXMLNSPrefixMap();
    }

    public String resolveNamespacePrefix(XMLData data) {
        String dataTypeNamespace = Objects.requireNonNull(data).getNamespace();
        Object resolvedNSPrefix = this.findExistingNSPrefix(data.getNamespace());
        if (resolvedNSPrefix == null) {
            resolvedNSPrefix = "n" + this.cuurentNamespaceCounter;
            ++this.cuurentNamespaceCounter;
            this.namespacePrefixRegistry.put(resolvedNSPrefix, (Object)dataTypeNamespace);
        }
        return resolvedNSPrefix;
    }

    private String findExistingNSPrefix(String dataTypeNamespace) {
        for (Map.Entry prefixMap : this.namespacePrefixRegistry.entrySet()) {
            String value = (String)prefixMap.getValue();
            if (value == null || !value.equals(dataTypeNamespace)) continue;
            return (String)prefixMap.getKey();
        }
        return null;
    }
}

