/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bpmn.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bpmn.extension.IBonitaModelExporter;
import org.bonitasoft.bpm.model.process.Activity;
import org.bonitasoft.bpm.model.process.Container;
import org.bonitasoft.bpm.model.process.FlowElement;
import org.bonitasoft.bpm.model.process.Gateway;
import org.bonitasoft.bpm.model.process.Lane;
import org.bonitasoft.bpm.model.process.MainProcess;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.process.TextAnnotation;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;

public class BonitaModelExporterImpl
implements IBonitaModelExporter {
    private Resource resource;
    private IModelSearch modelSearch;

    public BonitaModelExporterImpl(Resource resource, IModelSearch modelSearch) {
        this.resource = Objects.requireNonNull(resource);
        if (!resource.isLoaded()) {
            throw new IllegalStateException("Resource must be loaded first before export.");
        }
        if (!EnvironmentUtil.isOSGi() && this.getDiagramOpt().isEmpty()) {
            if (resource.getContents().stream().anyMatch(AnyType.class::isInstance)) {
                throw new IllegalStateException("The GMF Notation package was not registered before model was loaded.\nExecute 'EPackage.Registry.INSTANCE.put(NotationPackage.eNS_URI, NotationPackage.eINSTANCE);' before loading the model with org.bonitasoft.bpm.model.util.ModelLoader.");
            }
        }
        this.modelSearch = modelSearch;
    }

    @Override
    public MainProcess getMainProcess() {
        return this.resource.getContents().stream().filter(MainProcess.class::isInstance).map(MainProcess.class::cast).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No MainProcess found in resource %s", this.resource)));
    }

    @Override
    public Diagram getDiagram() {
        return this.getDiagramOpt().orElseThrow(() -> new IllegalStateException(String.format("No Diagram found in resource %s", this.resource)));
    }

    private Optional<Diagram> getDiagramOpt() {
        return this.resource.getContents().stream().filter(Diagram.class::isInstance).map(Diagram.class::cast).findFirst();
    }

    @Override
    public List<Pool> getPools() {
        return this.getMainProcess().getElements().stream().filter(Pool.class::isInstance).map(Pool.class::cast).collect(Collectors.toList());
    }

    public List<FlowElement> getFlowElements(Container container) {
        return this.modelSearch.getAllItemsOfType((EObject)container, FlowElement.class);
    }

    @Override
    public List<Lane> getLanes(Pool pool) {
        return this.modelSearch.getAllItemsOfType((EObject)pool, Lane.class);
    }

    @Override
    public Node getElementNotationNode(EObject modelElement) {
        ArrayList views = new ArrayList();
        TreeIterator iterator = this.getDiagram().eAllContents();
        iterator.forEachRemaining(notationElement -> {
            if (notationElement instanceof Node && Objects.equals(((Node)notationElement).getElement(), modelElement)) {
                views.add((Node)notationElement);
                iterator.prune();
            }
        });
        if (views.isEmpty()) {
            throw new IllegalStateException(String.format("No view found for %s", modelElement));
        }
        return (Node)views.get(0);
    }

    @Override
    public Bounds getBounds(Node view) {
        LayoutConstraint layoutConstraint = view.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            bounds.setHeight(((Bounds)layoutConstraint).getHeight());
            bounds.setWidth(((Bounds)layoutConstraint).getWidth());
            bounds.setX(((Bounds)layoutConstraint).getX());
            bounds.setY(((Bounds)layoutConstraint).getY());
            Dimension defaultSize = this.getDefaultSize(view);
            if (bounds.getHeight() == -1) {
                bounds.setHeight(defaultSize.height);
            }
            if (bounds.getWidth() == -1) {
                bounds.setWidth(defaultSize.width);
            }
            return bounds;
        }
        return null;
    }

    private Dimension getDefaultSize(Node node) {
        EObject modelElement = node.getElement();
        if (modelElement instanceof Pool) {
            return new Dimension(1000, 250);
        }
        if (modelElement instanceof Lane) {
            return new Dimension(975, 250);
        }
        if (modelElement instanceof Activity || modelElement instanceof TextAnnotation || modelElement instanceof SubProcessEvent) {
            return new Dimension(100, 50);
        }
        if (modelElement instanceof Gateway) {
            return new Dimension(43, 43);
        }
        return new Dimension(30, 30);
    }

    @Override
    public Location getLocation(Node view) {
        LayoutConstraint layoutConstraint = view.getLayoutConstraint();
        if (layoutConstraint instanceof Location) {
            return (Location)layoutConstraint;
        }
        return null;
    }

    @Override
    public Edge getElementNotationEdge(EObject connection) {
        return this.getDiagram().getPersistedEdges().stream().filter(edge -> Objects.equals(((Edge)edge).getElement(), connection)).findFirst().orElse(null);
    }

    @Override
    public String getEObjectID(EObject eObject) {
        return this.modelSearch.getEObjectID(eObject);
    }

    @Override
    public Pool getParentPool(Lane lane) {
        return (Pool)this.modelSearch.getDirectParentOfType((EObject)lane, Pool.class);
    }
}

