/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration;

import org.bonitasoft.bpm.migration.utils.DeadlineMigrationStore;
import org.bonitasoft.bpm.migration.utils.DeadlineStore;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class DeadlineToNonInterruptingEventMigration
extends CustomMigration {
    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance task : model.getAllInstances("process.Task")) {
            if (!DeadlineMigrationStore.hasDeadline(task.getUuid())) continue;
            this.addNonInterrutongTimerEvent(model, task);
        }
        for (Instance callactivity : model.getAllInstances("process.CallActivity")) {
            if (!DeadlineMigrationStore.hasDeadline(callactivity.getUuid())) continue;
            this.addNonInterrutongTimerEvent(model, callactivity);
        }
    }

    protected void addNonInterrutongTimerEvent(Model model, Instance task) {
        for (DeadlineStore deadline : DeadlineMigrationStore.getDeadlines(task.getUuid())) {
            Instance instance = model.newInstance("process.NonInterruptingBoundaryTimerEvent");
            instance.set("name", (Object)deadline.getName());
            Instance exp = new StringToExpressionConverter(model, task).parse(deadline.getCondition(), Long.class.getName(), false);
            instance.set("condition", (Object)exp);
            task.add("BoundaryIntermediateEvents", (Object)instance);
        }
    }
}

