/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class ConnectorIgnoreErrorMigration
extends CustomMigration {
    private Map<String, Boolean> ignoreValue = new HashMap<String, Boolean>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance connectorInstance : model.getAllInstances("process.Connector")) {
            this.ignoreValue.put(connectorInstance.getUuid(), (Boolean)connectorInstance.get("ignoreErrors"));
        }
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance connectorInstance : model.getAllInstances("process.Connector")) {
            Boolean value = this.ignoreValue.get(connectorInstance.getUuid());
            connectorInstance.unset((EStructuralFeature)ProcessPackage.Literals.CONNECTOR__IGNORE_ERRORS);
            connectorInstance.set("ignoreErrors", (Object)value);
        }
    }
}

