/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import java.util.List;
import java.util.Objects;
import org.bonitasoft.bpm.migration.custom.migration.connector.AbstractUpdateConnectorDefinitionMigration;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UpdateDeprecatedGroovyConnector
extends AbstractUpdateConnectorDefinitionMigration {
    private static final String DEPRECATED_GROOVY_DEF_ID = "scripting-groovy";
    private static final String DEPRECATED_GROOVY_DEF_VERSION = "1.0.2";
    private static final String CURRENT_GROOVY_DEF_ID = "scripting-groovy-script";
    private static final String CURRENT_GROOVY_DEF_VERSION = "1.0.1";

    @Override
    public String getNewDefinitionVersion() {
        return CURRENT_GROOVY_DEF_VERSION;
    }

    @Override
    public String getOldDefinitionVersion() {
        return DEPRECATED_GROOVY_DEF_VERSION;
    }

    @Override
    public String getNewDefinitionId() {
        return CURRENT_GROOVY_DEF_ID;
    }

    @Override
    public boolean shouldUpdateVersion(String defId) {
        return Objects.equals(defId, DEPRECATED_GROOVY_DEF_ID);
    }

    @Override
    public boolean shouldUpdateId(String defId) {
        return Objects.equals(defId, DEPRECATED_GROOVY_DEF_ID);
    }

    @Override
    protected void updateConfiguration(Instance connectorConfigInstance, Model model) {
        super.updateConfiguration(connectorConfigInstance, model);
        List parameters = (List)connectorConfigInstance.get("parameters");
        parameters.stream().filter(p -> Objects.equals(p.get("key"), "script")).forEach(p -> p.set("key", (Object)"fakeScriptExpression"));
        Instance scriptParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
        scriptParameter.set("key", (Object)"script");
        parameters.add(scriptParameter);
        Instance variableParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
        variableParameter.set("key", (Object)"variables");
        parameters.add(variableParameter);
    }
}

