/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import java.util.List;
import java.util.Objects;
import org.bonitasoft.bpm.migration.custom.migration.connector.AbstractUpdateConnectorDefinitionMigration;
import org.bonitasoft.bpm.migration.utils.CustomMigrationUtil;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UpdateEmailConnectorVersionTo110
extends AbstractUpdateConnectorDefinitionMigration {
    private static final String EMAIL_CONNECTOR_DEFINITION = "email";

    @Override
    public String getNewDefinitionVersion() {
        return "1.1.0";
    }

    @Override
    public String getOldDefinitionVersion() {
        return "1.0.0";
    }

    @Override
    public boolean shouldUpdateVersion(String defId) {
        return Objects.equals(EMAIL_CONNECTOR_DEFINITION, defId);
    }

    @Override
    protected void updateConfiguration(Instance connectorConfigInstance, Model model) {
        super.updateConfiguration(connectorConfigInstance, model);
        List parameters = (List)connectorConfigInstance.get("parameters");
        parameters.stream().filter(p -> Objects.equals(p.get("key"), "from") && p.get("expression") != null).findFirst().ifPresent(fromParameter -> {
            Instance returnPathParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
            returnPathParameter.set("key", (Object)"returnPath");
            Instance fromExpression = (Instance)fromParameter.get("expression");
            Instance copy = CustomMigrationUtil.deepCopy(fromExpression);
            returnPathParameter.set("expression", (Object)copy);
            parameters.add(returnPathParameter);
        });
    }
}

