/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.bpm.migration.custom.migration.connector.AbstractUpdateConnectorDefinitionMigration;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UpdateGoogleCalendarDefinitionTo110
extends AbstractUpdateConnectorDefinitionMigration {
    private static final Set<String> GOOGLE_CALENDAR_DEFINITIONS = new HashSet<String>();

    static {
        GOOGLE_CALENDAR_DEFINITIONS.add("google-calendar-v3-create-event");
        GOOGLE_CALENDAR_DEFINITIONS.add("google-calendar-v3-get-event");
        GOOGLE_CALENDAR_DEFINITIONS.add("google-calendar-v3-delete-event");
        GOOGLE_CALENDAR_DEFINITIONS.add("google-calendar-v3-move-event");
        GOOGLE_CALENDAR_DEFINITIONS.add("google-calendar-v3-update-event");
    }

    @Override
    public String getNewDefinitionVersion() {
        return "1.1.0";
    }

    @Override
    public String getOldDefinitionVersion() {
        return "1.0.0";
    }

    @Override
    public boolean shouldUpdateVersion(String defId) {
        return GOOGLE_CALENDAR_DEFINITIONS.contains(defId);
    }

    @Override
    protected void updateConfiguration(Instance connectorConfigInstance, Model model) {
        super.updateConfiguration(connectorConfigInstance, model);
        List parameters = (List)connectorConfigInstance.get("parameters");
        Instance authModeParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
        authModeParameter.set("key", (Object)"authMode");
        authModeParameter.set("expression", (Object)StringToExpressionConverter.createExpressionInstance(model, "P12", "P12", String.class.getName(), "TYPE_CONSTANT", true));
        parameters.add(authModeParameter);
    }
}

