/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import java.util.List;
import org.bonitasoft.bpm.migration.custom.migration.connector.AbstractUpdateConnectorDefinitionMigration;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UpdateLDAPConnectorVersionTo110
extends AbstractUpdateConnectorDefinitionMigration {
    private static final String DEFAULT_PAGE_SIZE = "500";
    private static final String LDAP_CONNECTOR_DEFINITION = "ldap";

    @Override
    public String getNewDefinitionVersion() {
        return "1.1.0";
    }

    @Override
    public String getOldDefinitionVersion() {
        return "1.0.0";
    }

    @Override
    public boolean shouldUpdateVersion(String defId) {
        return LDAP_CONNECTOR_DEFINITION.equals(defId);
    }

    @Override
    protected void updateConfiguration(Instance connectorConfigInstance, Model model) {
        super.updateConfiguration(connectorConfigInstance, model);
        List parameters = (List)connectorConfigInstance.get("parameters");
        Instance pageSizeParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
        pageSizeParameter.set("key", (Object)"pageSize");
        pageSizeParameter.set("expression", (Object)StringToExpressionConverter.createExpressionInstance(model, DEFAULT_PAGE_SIZE, DEFAULT_PAGE_SIZE, Long.class.getName(), "TYPE_CONSTANT", true));
        parameters.add(pageSizeParameter);
    }
}

