/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.form;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class FormMappingCustomMigration
extends CustomMigration {
    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        List pageFlows = model.getAllInstances("process.PageFlow").stream().filter(this.withoutFormMapping((EStructuralFeature)ProcessPackage.Literals.PAGE_FLOW__FORM_MAPPING)).collect(Collectors.toList());
        for (Instance instance : pageFlows) {
            this.instantiateFormMapping(instance, model, "formMapping");
        }
        List recapFlows = model.getAllInstances("process.RecapFlow").stream().filter(this.withoutFormMapping((EStructuralFeature)ProcessPackage.Literals.RECAP_FLOW__OVERVIEW_FORM_MAPPING)).collect(Collectors.toList());
        for (Instance instance : recapFlows) {
            this.instantiateFormMapping(instance, model, "overviewFormMapping");
        }
    }

    private Predicate<Instance> withoutFormMapping(EStructuralFeature feature) {
        return input -> !input.isSet(feature);
    }

    private void instantiateFormMapping(Instance input, Model model, String featureName) {
        Instance newInstance = model.newInstance("process.FormMapping");
        Instance targetFormExpression = this.newTargetFormExpressionInstance(model);
        newInstance.set("targetForm", (Object)targetFormExpression);
        newInstance.set("type", (Object)model.getMetamodel().getEEnum("process.FormMappingType").getEEnumLiteral("INTERNAL"));
        input.set(featureName, (Object)newInstance);
    }

    private Instance newTargetFormExpressionInstance(Model model) {
        Instance targetFormExpression = model.newInstance("expression.Expression");
        targetFormExpression.set("name", (Object)"");
        targetFormExpression.set("content", (Object)"");
        targetFormExpression.set("returnType", (Object)String.class.getName());
        targetFormExpression.set("type", (Object)"FORM_REFERENCE_TYPE");
        targetFormExpression.set("returnTypeFixed", (Object)true);
        return targetFormExpression;
    }
}

