/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.utils;

import java.util.Calendar;
import java.util.Date;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.process.StartTimerEvent;

public class LegacyTimerExpressionGenerator {
    private static final String CRON_EVERY = "*/";
    public static final String GROOVY_PREFIX = "${";
    public static final String GROOVY_SUFFIX = "}";
    private static final String CRON_WILDCARD = "*";
    private static final String CRON_NOT_SET = "?";
    private static final String CRON_DAY_OF_MONTH = "#";

    public String getTimerExpressionContent(StartTimerEvent item) {
        switch (item.getScriptType()) {
            case GROOVY: {
                return this.conditionExpressionContent(item);
            }
            case YEARLY_DAY_OF_MONTH: {
                return this.yearlyDayOfMonthCron(item);
            }
            case YEARLY_DAY_OF_YEAR: {
                return this.yearlyDayOfYearCron(item);
            }
            case MONTHLY_DAY_NUMBER: {
                return this.monthlyDayNumberCron(item);
            }
            case MONTHLY_DAY_OF_WEEK: {
                return this.monthlyDayOfWeekCron(item);
            }
            case WEEKLY: {
                return this.weeklyCron(item);
            }
            case DAILY: {
                return this.dailyCron(item);
            }
            case HOURLY: {
                return this.generateCronExpression(CRON_WILDCARD, CRON_EVERY + item.getHours(), CRON_WILDCARD, CRON_WILDCARD, CRON_NOT_SET);
            }
            case MINUTELY: {
                return this.generateCronExpression(CRON_EVERY + item.getMinutes(), CRON_WILDCARD, CRON_WILDCARD, CRON_WILDCARD, CRON_NOT_SET);
            }
            case CONSTANT: {
                return LegacyTimerExpressionGenerator.generateConstant(item.getAt());
            }
        }
        throw new IllegalArgumentException("Timer type" + String.valueOf(item.getScriptType()) + " is not supported.");
    }

    protected String dailyCron(StartTimerEvent item) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(item.getAt());
        return this.generateCronExpression(String.valueOf(calendar.get(12)), String.valueOf(calendar.get(11)), CRON_WILDCARD, CRON_WILDCARD, CRON_NOT_SET);
    }

    protected String weeklyCron(StartTimerEvent item) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(item.getAt());
        return this.generateCronExpression(String.valueOf(calendar.get(12)), String.valueOf(calendar.get(11)), CRON_NOT_SET, CRON_WILDCARD, String.valueOf(item.getDay()));
    }

    protected String monthlyDayOfWeekCron(StartTimerEvent item) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(item.getAt());
        return this.generateCronExpression(String.valueOf(calendar.get(12)), String.valueOf(calendar.get(11)), CRON_NOT_SET, CRON_WILDCARD, item.getDay() + CRON_DAY_OF_MONTH + item.getDayNumber());
    }

    protected String monthlyDayNumberCron(StartTimerEvent item) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(item.getAt());
        return this.generateCronExpression(String.valueOf(calendar.get(12)), String.valueOf(calendar.get(11)), String.valueOf(item.getDayNumber()), CRON_WILDCARD, CRON_NOT_SET);
    }

    protected String yearlyDayOfYearCron(StartTimerEvent item) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(item.getAt());
        calendar.set(6, item.getDayNumber());
        return this.generateCronExpression(String.valueOf(calendar.get(12)), String.valueOf(calendar.get(11)), String.valueOf(calendar.get(5)), String.valueOf(calendar.get(2) + 1), CRON_NOT_SET);
    }

    protected String yearlyDayOfMonthCron(StartTimerEvent item) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(item.getAt());
        return this.generateCronExpression(String.valueOf(calendar.get(12)), String.valueOf(calendar.get(11)), String.valueOf(item.getDayNumber()), String.valueOf(item.getMonth() + 1), CRON_NOT_SET);
    }

    protected String conditionExpressionContent(StartTimerEvent item) {
        Expression condition = item.getCondition();
        if (condition != null) {
            return condition.getContent();
        }
        return null;
    }

    public static boolean isCycle(StartTimerEvent item) {
        switch (item.getScriptType()) {
            case YEARLY_DAY_OF_MONTH: 
            case YEARLY_DAY_OF_YEAR: 
            case MONTHLY: 
            case MONTHLY_DAY_NUMBER: 
            case MONTHLY_DAY_OF_WEEK: 
            case WEEKLY: 
            case DAILY: 
            case HOURLY: 
            case MINUTELY: {
                return true;
            }
            case GROOVY: 
            case CONSTANT: {
                return false;
            }
        }
        throw new IllegalArgumentException("Timer type" + String.valueOf(item.getScriptType()) + " is not supported.");
    }

    private String generateCronExpression(String min, String hour, String dayOfMonth, String month, String dayOfWeek) {
        StringBuilder sb = new StringBuilder();
        sb.append("0");
        sb.append(' ');
        sb.append(min);
        sb.append(' ');
        sb.append(hour);
        sb.append(' ');
        sb.append(dayOfMonth);
        sb.append(' ');
        sb.append(month);
        sb.append(' ');
        sb.append(dayOfWeek);
        return sb.toString();
    }

    public static String generateConstant(Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("return new Date(");
        stringBuilder.append(date.getTime());
        stringBuilder.append(");");
        return stringBuilder.toString();
    }
}

