/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import org.bonitasoft.bpm.migration.custom.migration.connector.UpdateConnectorDefinitionMigration;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public abstract class AbstractUpdateConnectorDefinitionMigration
extends CustomMigration
implements UpdateConnectorDefinitionMigration {
    protected static final String VERSION_FEATURE_NAME = "version";
    protected static final String DEFINITION_VERSION_FEATURE_NAME = "definitionVersion";
    protected static final String DEFINITION_ID_FEATURE_NAME = "definitionId";

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance connectorInstance : model.getAllInstances("process.Connector")) {
            String defId = (String)connectorInstance.get(DEFINITION_ID_FEATURE_NAME);
            if (this.shouldUpdateId(defId)) {
                String newDefinitionId = this.getNewDefinitionId();
                if (newDefinitionId == null) {
                    throw new IllegalStateException(String.format("A new definition id must be provided to migrate '%s'", defId));
                }
                connectorInstance.set(DEFINITION_ID_FEATURE_NAME, (Object)newDefinitionId);
            }
            if (!this.shouldUpdateVersion(defId)) continue;
            this.updateVersion(connectorInstance);
        }
        for (Instance connectorConfigInstance : model.getAllInstances("connectorconfiguration.ConnectorConfiguration")) {
            this.migrateConnectorConfiguration(model, connectorConfigInstance);
        }
    }

    private void migrateConnectorConfiguration(Model model, Instance connectorConfigInstance) {
        String defId = (String)connectorConfigInstance.get(DEFINITION_ID_FEATURE_NAME);
        if (this.shouldUpdateId(defId)) {
            String newDefinitionId = this.getNewDefinitionId();
            if (newDefinitionId == null) {
                throw new IllegalStateException(String.format("A new definition id must be provided to migrate '%s'", defId));
            }
            connectorConfigInstance.set(DEFINITION_ID_FEATURE_NAME, (Object)newDefinitionId);
        }
        if (this.shouldUpdateVersion(defId)) {
            this.updateConfigVersion(connectorConfigInstance);
            this.updateConfiguration(connectorConfigInstance, model);
        }
    }

    protected void updateConfiguration(Instance connectorConfigInstance, Model model) {
    }

    private void updateVersion(Instance connectorInstance) {
        String previousDefinitionVersion;
        String defVersion = (String)connectorInstance.get(DEFINITION_VERSION_FEATURE_NAME);
        if (defVersion.equals(previousDefinitionVersion = this.getOldDefinitionVersion())) {
            connectorInstance.set(DEFINITION_VERSION_FEATURE_NAME, (Object)this.getNewDefinitionVersion());
        }
    }

    private void updateConfigVersion(Instance connectorConfigInstance) {
        String previousDefinitionVersion;
        String defVersion = (String)connectorConfigInstance.get(VERSION_FEATURE_NAME);
        if (defVersion.equals(previousDefinitionVersion = this.getOldDefinitionVersion())) {
            connectorConfigInstance.set(VERSION_FEATURE_NAME, (Object)this.getNewDefinitionVersion());
        }
    }
}

