/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import java.util.List;
import java.util.Optional;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UpdateCMISConnectorVersionCustomMigration
extends CustomMigration {
    public static final String WEBSERVICES_OBJECT_SERVICE = "wsObjectServiceUrl";
    public static final String WEBSERVICES_REPOSITORY_SERVICE = "wsRepositoryServiceUrl";
    public static final String WEBSERVICES_VERSIONING_SERVICE = "wsVersioningServiceUrl";
    public static final String WEBSERVICES_NAVIGATION_SERVICE = "wsNavigationServiceUrl";
    private static final String VERSIONING_SERVICE_WSDL = "VersioningService?wsdl";
    private static final String OBJECT_SERVICE_WSDL = "ObjectService?wsdl";
    private static final String REPOSITORY_SERVICE_WSDL = "RepositoryService?wsdl";
    private static final String NAVIGATION_SERVICE_WSDL = "NavigationService?wsdl";

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance connectorInstance : model.getAllInstances("process.Connector")) {
            String defId = (String)connectorInstance.get("definitionId");
            String defVersion = (String)connectorInstance.get("definitionVersion");
            if (!this.isProvidedCMISConnectorDef(defId) || !defVersion.equals("1.0.0")) continue;
            connectorInstance.set("definitionVersion", (Object)"2.0.1");
            Instance connectorConfigInstance = (Instance)connectorInstance.get("configuration");
            if (connectorConfigInstance != null) {
                connectorConfigInstance.set("version", (Object)"2.0.1");
                if (this.isWebserviceBinding(connectorConfigInstance) && this.isSupportedURLExpression(connectorConfigInstance)) {
                    Instance urlExpression;
                    this.addServiceURL(connectorConfigInstance, model, WEBSERVICES_OBJECT_SERVICE, this.createURLValueExpression(model, connectorConfigInstance, OBJECT_SERVICE_WSDL));
                    this.addServiceURL(connectorConfigInstance, model, WEBSERVICES_REPOSITORY_SERVICE, this.createURLValueExpression(model, connectorConfigInstance, REPOSITORY_SERVICE_WSDL));
                    if (defId.equals("cmis-deleteversionofdocument")) {
                        this.addServiceURL(connectorConfigInstance, model, WEBSERVICES_VERSIONING_SERVICE, this.createURLValueExpression(model, connectorConfigInstance, VERSIONING_SERVICE_WSDL));
                        this.addServiceURL(connectorConfigInstance, model, WEBSERVICES_NAVIGATION_SERVICE, this.createURLValueExpression(model, connectorConfigInstance, NAVIGATION_SERVICE_WSDL));
                    }
                    if ((urlExpression = this.getURLExpression(connectorConfigInstance)) != null) {
                        model.delete(urlExpression);
                    }
                }
            }
            if (!defId.equals("cmis-downloaddocument")) continue;
            this.updateConnectorOuputName(connectorInstance);
        }
    }

    private boolean isSupportedURLExpression(Instance connectorConfigInstance) {
        Instance urlExpression = this.getURLExpression(connectorConfigInstance);
        return urlExpression != null && (this.isConstantExpression(urlExpression) || this.isVariableExpression(urlExpression));
    }

    private Instance createURLValueExpression(Model model, Instance connectorConfigInstance, String wsdlPath) {
        Instance urlExpression = this.getURLExpression(connectorConfigInstance);
        if (urlExpression != null) {
            if (this.isConstantExpression(urlExpression)) {
                return this.transformConstantExpression(model, wsdlPath, urlExpression);
            }
            if (this.isVariableExpression(urlExpression)) {
                return this.transformVariableExpression(model, wsdlPath, urlExpression);
            }
        }
        return null;
    }

    private Instance transformVariableExpression(Model model, String wsdlPath, Instance urlExpression) {
        String variableName = (String)urlExpression.get("content");
        Instance scriptExpressionInstance = StringToExpressionConverter.createExpressionInstance(model, wsdlPath, variableName + " + \"/" + wsdlPath + "\"", String.class.getName(), "TYPE_READ_ONLY_SCRIPT", true);
        Instance dependency = this.createExpressionDependencyFrom(urlExpression);
        if (dependency != null) {
            scriptExpressionInstance.add("referencedElements", (Object)dependency);
        }
        return scriptExpressionInstance;
    }

    private Instance createExpressionDependencyFrom(Instance urlExpression) {
        List dependencies = (List)urlExpression.get("referencedElements");
        if (!dependencies.isEmpty()) {
            return ((Instance)dependencies.get(0)).copy();
        }
        return null;
    }

    private boolean isVariableExpression(Instance urlExpression) {
        String expType = (String)urlExpression.get("type");
        return "TYPE_VARIABLE".equals(expType) || "TYPE_PARAMETER".equals(expType);
    }

    private Instance transformConstantExpression(Model model, String wsdlPath, Instance urlExpression) {
        Object serverUrl = (String)urlExpression.get("content");
        if (!((String)serverUrl).endsWith("/")) {
            serverUrl = (String)serverUrl + "/";
        }
        String newInputValue = (String)serverUrl + wsdlPath;
        return StringToExpressionConverter.createExpressionInstance(model, newInputValue, newInputValue, String.class.getName(), "TYPE_CONSTANT", true);
    }

    private boolean isConstantExpression(Instance urlExpression) {
        return "TYPE_CONSTANT".equals(urlExpression.get("type"));
    }

    private Instance getURLExpression(Instance connectorConfigInstance) {
        Instance urlParameter = this.getConnectorParameter("url", connectorConfigInstance);
        Optional<Instance> urlExpression = Optional.ofNullable(urlParameter).map(p -> (Instance)p.get("expression"));
        return urlExpression.orElse(null);
    }

    private void addServiceURL(Instance connectorConfigInstance, Model model, String newInputName, Instance valueExpression) {
        Instance newParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
        newParameter.set("key", (Object)newInputName);
        newParameter.set("expression", (Object)valueExpression);
        connectorConfigInstance.add("parameters", (Object)newParameter);
    }

    private boolean isWebserviceBinding(Instance connectorConfigInstance) {
        Instance bindingParameter = this.getConnectorParameter("binding_type", connectorConfigInstance);
        if (bindingParameter != null) {
            Instance exp = (Instance)bindingParameter.get("expression");
            String bindingValue = (String)exp.get("content");
            return bindingValue.equals("webservices");
        }
        return false;
    }

    private Instance getConnectorParameter(String inputName, Instance connectorConfiguration) {
        List connectorParameterInstances = (List)connectorConfiguration.get("parameters");
        for (Instance connectorParameter : connectorParameterInstances) {
            String input = (String)connectorParameter.get("key");
            if (!inputName.equals(input)) continue;
            return connectorParameter;
        }
        return null;
    }

    private void updateConnectorOuputName(Instance connectorInstance) {
        List outputOperationInstances = (List)connectorInstance.get("outputs");
        block2: for (Instance operation : outputOperationInstances) {
            Instance rightOperandExpression = (Instance)operation.get("rightOperand");
            String expContent = (String)rightOperandExpression.get("content");
            if (expContent.contains("documentOuput")) {
                expContent = expContent.replace("documentOuput", "documentOutput");
                rightOperandExpression.set("content", (Object)expContent);
            }
            List referencedElementInstances = (List)rightOperandExpression.get("referencedElements");
            for (Instance ref : referencedElementInstances) {
                try {
                    String name = (String)ref.get("name");
                    if (!"documentOuput".equals(name)) continue;
                    ref.set("name", (Object)"documentOutput");
                    continue block2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isProvidedCMISConnectorDef(String defId) {
        return defId.equals("cmis-createfolder") || defId.equals("cmis-deletedocument") || defId.equals("cmis-deletefolder") || defId.equals("cmis-deleteversionofdocument") || defId.equals("cmis-downloaddocument") || defId.equals("cmis-uploadnewdocument") || defId.equals("cmis-uploadnewversionofdocument");
    }
}

