/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.expression;

import java.util.List;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class CleanReferenceMigration
extends CustomMigration {
    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        super.migrateAfter(model, metamodel);
        for (Instance operation : model.getAllInstances("expression.Operation")) {
            boolean hasAddedAreference;
            Instance expression = (Instance)operation.get("leftOperand");
            if (!this.isExpressionOfVariableType(expression) && !this.isExpressionOfConstantType(expression) || !this.isNoneReferencedElements(expression) || !(hasAddedAreference = new StringToExpressionConverter(model, this.getScope(expression)).resolveDataDependencies(expression)) || !this.isExpressionOfConstantType(expression)) continue;
            expression.set("type", (Object)"TYPE_VARIABLE");
        }
    }

    private boolean isExpressionOfConstantType(Instance expression) {
        return expression != null && "TYPE_CONSTANT".equals(expression.get("type"));
    }

    private boolean isNoneReferencedElements(Instance expression) {
        Object referencedElements = expression.get("referencedElements");
        return referencedElements instanceof List && ((List)expression.get("referencedElements")).isEmpty();
    }

    private boolean isExpressionOfVariableType(Instance expression) {
        return expression != null && "TYPE_VARIABLE".equals(expression.get("type"));
    }

    protected Instance getScope(Instance element) {
        Instance container = element;
        while (container != null && !container.instanceOf("process.AbstractProcess")) {
            container = container.getContainer();
        }
        return container;
    }
}

