/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.multiinstance;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.bpm.migration.custom.migration.multiinstance.MultiInstanceMigrator;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class MultiInstanceCustomMigration
extends CustomMigration {
    private final Map<String, MultiInstanceMigrator> multiInstanceMigrators = new HashMap<String, MultiInstanceMigrator>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance activityInstance : model.getAllInstances("process.Activity")) {
            MultiInstanceMigrator multiInstanceMigrator = new MultiInstanceMigrator(activityInstance);
            multiInstanceMigrator.save(model);
            this.multiInstanceMigrators.put(activityInstance.getUuid(), multiInstanceMigrator);
        }
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance activityInstance : model.getAllInstances("process.Activity")) {
            if (!this.multiInstanceMigrators.containsKey(activityInstance.getUuid())) continue;
            this.multiInstanceMigrators.get(activityInstance.getUuid()).migrate(activityInstance, metamodel);
        }
    }
}

