/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.searchIndex;

import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class SearchIndexMigration
extends CustomMigration {
    private static final int MAX = 5;

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance pool : model.getAllInstances("process.Pool")) {
            int i = 0;
            while (i < 5) {
                pool.add("searchIndexes", (Object)this.createSearchIndex(model));
                ++i;
            }
        }
    }

    private Instance createSearchIndex(Model model) {
        Instance searchIndex = model.newInstance("process.SearchIndex");
        Instance nameExpression = StringToExpressionConverter.createExpressionInstance(model, "", "", String.class.getName(), "TYPE_CONSTANT", true);
        searchIndex.set("name", (Object)nameExpression);
        Instance valueExpression = StringToExpressionConverter.createExpressionInstance(model, "", "", String.class.getName(), "TYPE_CONSTANT", true);
        searchIndex.set("value", (Object)valueExpression);
        return searchIndex;
    }
}

