/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.expression;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class PatternExpressionMigration
extends CustomMigration {
    private final Map<String, String> expressions = new HashMap<String, String>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance expression : model.getAllInstances("expression.Expression")) {
            String content;
            if (!"TYPE_PATTERN".equals(expression.get("type")) || (content = (String)expression.get("content")) == null || content.isEmpty()) continue;
            this.expressions.put(expression.getUuid(), content);
        }
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance expression : model.getAllInstances("expression.Expression")) {
            if (!this.expressions.containsKey(expression.getUuid())) continue;
            expression.set("content", (Object)this.replaceSpecialCharacter(this.expressions.get(expression.getUuid())));
        }
    }

    private String replaceSpecialCharacter(String content) {
        return content.replace("&nbsp;", " ");
    }
}

