/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.multiinstance;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class CallActivityInputMappingCustomMigration
extends CustomMigration {
    private final Map<String, Instance> dataInstances = new HashMap<String, Instance>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        Iterable instancesWithProcessSource = model.getAllInstances("process.InputMapping").stream().filter(this.withProcessSource()).collect(Collectors.toList());
        for (Instance instance : instancesWithProcessSource) {
            this.dataInstances.put(instance.getUuid(), ((Instance)instance.get(ProcessPackage.Literals.INPUT_MAPPING__PROCESS_SOURCE.getName())).copy());
        }
    }

    private Predicate<Instance> withProcessSource() {
        return inputMappingInstance -> inputMappingInstance.get("processSource") instanceof Instance;
    }

    protected Map<String, Instance> getDataInstances() {
        return this.dataInstances;
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        Iterable instancesToMigrate = model.getAllInstances("process.InputMapping").stream().filter(this.matchingUUID()).collect(Collectors.toList());
        for (Instance instance : instancesToMigrate) {
            this.convertDataToExpression(model, instance);
        }
    }

    private void convertDataToExpression(Model model, Instance inputMappingInstance) {
        Instance dataInstance = this.dataInstances.get(inputMappingInstance.getUuid());
        String name = (String)dataInstance.get("name");
        Instance defaultValueExpression = (Instance)dataInstance.get("defaultValue");
        if (defaultValueExpression != null) {
            model.delete(defaultValueExpression);
        }
        Instance expressionInstance = StringToExpressionConverter.createExpressionInstanceWithDependency(model, name, name, StringToExpressionConverter.getDataReturnType(dataInstance), "TYPE_VARIABLE", false, dataInstance);
        model.delete(dataInstance);
        inputMappingInstance.set("processSource", (Object)expressionInstance);
    }

    private Predicate<Instance> matchingUUID() {
        return inputMappingInstance -> this.dataInstances.containsKey(inputMappingInstance.getUuid());
    }
}

