/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.subprocessevent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bonitasoft.bpm.migration.custom.migration.NotationPackageLoader;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class SubprocessEventMigration
extends CustomMigration {
    private final Map<String, List<Instance>> connectionsMap = new HashMap<String, List<Instance>>();
    private final Map<String, List<Instance>> elementsMap = new HashMap<String, List<Instance>>();
    private final Map<String, Instance> elementsByUUID = new HashMap<String, Instance>();
    private final Map<String, Instance> elementsMapping = new HashMap<String, Instance>();
    private final Map<String, String> subprocNames = new HashMap<String, String>();
    private final Map<String, String> subprocDescription = new HashMap<String, String>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance subprocessevent : model.getAllInstances("process.SubProcessEvent")) {
            this.subprocNames.put(subprocessevent.getUuid(), (String)subprocessevent.get("name"));
            this.subprocDescription.put(subprocessevent.getUuid(), (String)subprocessevent.get("documentation"));
            Instance process = this.getParentProcess(subprocessevent);
            if (process == null) {
                throw new MigrationException("No parent process found for subprocess event " + String.valueOf(subprocessevent.get("name")), null);
            }
            for (Instance data : (List)subprocessevent.get("data")) {
                process.add("data", (Object)data.copy());
            }
            ArrayList<Instance> elements = new ArrayList<Instance>();
            for (Instance element : (List)subprocessevent.get("elements")) {
                subprocessevent.remove("elements", (Object)element);
                process.add("elements", (Object)element);
                Instance copy = element;
                copy.setUuid(element.getUuid());
                Optional<EClass> viewEC = NotationPackageLoader.getInstance().getView();
                if (viewEC.isPresent()) {
                    for (Instance view : model.getAllInstances(viewEC.get())) {
                        Instance elem = (Instance)view.get("element");
                        if (elem == null || !elem.getUuid().equals(element.getUuid())) continue;
                        this.elementsMapping.put(element.getUuid(), view);
                    }
                }
                this.elementsByUUID.put(element.getUuid(), copy);
                elements.add(copy);
            }
            this.elementsMap.put(subprocessevent.getUuid(), elements);
            for (Instance connection : (List)subprocessevent.get("connections")) {
                subprocessevent.remove("connections", (Object)connection);
                process.add("connections", (Object)connection);
            }
        }
    }

    private Instance getParentProcess(Instance subprocessevent) {
        Instance current = subprocessevent;
        while (current != null && (current.equals(subprocessevent) || !current.instanceOf("process.AbstractProcess"))) {
            current = current.getContainer();
        }
        return current;
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance subprocessevent : model.getAllInstances("process.SubProcessEvent")) {
            List<Instance> connections;
            subprocessevent.set("name", (Object)this.subprocNames.get(subprocessevent.getUuid()));
            subprocessevent.set("documentation", (Object)this.subprocDescription.get(subprocessevent.getUuid()));
            Instance process = this.getParentProcess(subprocessevent);
            if (process == null) {
                throw new MigrationException("No parent process found for subprocess event " + String.valueOf(subprocessevent.get("name")), null);
            }
            List<Instance> elements = this.elementsMap.get(subprocessevent.getUuid());
            if (elements != null) {
                for (Instance element : elements) {
                    process.remove("elements", (Object)element);
                    subprocessevent.add("elements", (Object)element);
                    if (!this.elementsMapping.containsKey(element.getUuid())) continue;
                    this.elementsMapping.get(element.getUuid()).set("element", (Object)element);
                }
            }
            if ((connections = this.connectionsMap.get(subprocessevent.getUuid())) == null) continue;
            List procConnections = (List)process.get("connections");
            for (Instance connection : connections) {
                procConnections.add(connection);
                if (!this.elementsMapping.containsKey(connection.getUuid())) continue;
                this.elementsMapping.get(connection.getUuid()).set("element", (Object)connection);
            }
        }
    }
}

