/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class DependenciesCopyCustomMigration
extends CustomMigration {
    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        ArrayList allReferencesToBeDeleted = new ArrayList();
        for (Instance expInstance : model.getAllInstances("expression.Expression")) {
            String content;
            List referencedElements = (List)expInstance.get("referencedElements");
            ArrayList<Instance> newReferencedElements = new ArrayList<Instance>();
            ArrayList<Instance> referencesToBeDeleted = new ArrayList<Instance>();
            if (referencedElements.isEmpty() && "TYPE_VARIABLE".equals(expInstance.get("type")) && (content = (String)expInstance.get("content")) != null && !content.isEmpty()) {
                new StringToExpressionConverter(model, this.getScope(expInstance)).resolveDataDependencies(expInstance);
            }
            if (referencedElements.isEmpty() && "TYPE_PARAMETER".equals(expInstance.get("type")) && (content = (String)expInstance.get("content")) != null && !content.isEmpty()) {
                new StringToExpressionConverter(model, this.getScope(expInstance)).resolveParameterDependencies(expInstance);
            }
            for (Instance refElement : referencedElements) {
                Instance newCleanedDependency = null;
                if (refElement.instanceOf("process.Data")) {
                    newCleanedDependency = this.newCleaneDataDependency(refElement);
                    referencesToBeDeleted.add(refElement);
                } else if (refElement.instanceOf("process.Document")) {
                    newCleanedDependency = this.newCleanedDocumentDependency(refElement, model);
                    referencesToBeDeleted.add(refElement);
                } else if (model.getMetamodel().getEClass("process.ContractInput") != null && refElement.instanceOf("process.ContractInput")) {
                    newCleanedDependency = this.newCleanedContractInputDependency(refElement, model);
                    referencesToBeDeleted.add(refElement);
                }
                if (newCleanedDependency == null) continue;
                newReferencedElements.add(newCleanedDependency);
            }
            for (Instance instanceToDelete : referencesToBeDeleted) {
                expInstance.remove("referencedElements", (Object)instanceToDelete);
            }
            allReferencesToBeDeleted.addAll(referencesToBeDeleted);
            for (Instance newInstance : newReferencedElements) {
                expInstance.add("referencedElements", (Object)newInstance);
            }
        }
        for (Instance instance : allReferencesToBeDeleted) {
            model.delete(instance);
        }
        allReferencesToBeDeleted.clear();
        for (Instance expInstance : model.getAllInstances("expression.Expression")) {
            if (expInstance.getContainer() != null) continue;
            allReferencesToBeDeleted.add(expInstance);
        }
        for (Instance instance : allReferencesToBeDeleted) {
            model.delete(instance);
        }
        allReferencesToBeDeleted.clear();
    }

    private Instance newCleanedContractInputDependency(Instance refElement, Model model) {
        Instance newInstance = refElement.copy();
        ((List)newInstance.get("inputs")).stream().forEach(arg_0 -> ((Model)model).delete(arg_0));
        return newInstance;
    }

    protected Instance newCleanedDocumentDependency(Instance refElement, Model model) {
        Instance newInstance = model.newInstance(refElement.getEClass());
        newInstance.set("name", refElement.get("name"));
        if (newInstance.getEClass().getEStructuralFeature("multiple") != null) {
            newInstance.set("multiple", refElement.get("multiple"));
        }
        return newInstance;
    }

    protected Instance newCleaneDataDependency(Instance refElement) {
        Instance newInstance = refElement.copy();
        newInstance.set("defaultValue", null);
        return newInstance;
    }

    protected Instance getScope(Instance element) {
        Instance container = element;
        while (container != null && !container.instanceOf("process.AbstractProcess")) {
            container = container.getContainer();
        }
        return container;
    }
}

