/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connector;

import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UpdateAlfrescoConnectorDefinitionsMigration
extends CustomMigration {
    private static final String VERSION_2_0_0 = "2.0.0";
    protected static final String VERSION_FEATURE_NAME = "version";
    protected static final String DEFINITION_VERSION_FEATURE_NAME = "definitionVersion";
    protected static final String DEFINITION_ID_FEATURE_NAME = "definitionId";

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        String defId;
        for (Instance connectorInstance : model.getAllInstances("process.Connector")) {
            defId = (String)connectorInstance.get(DEFINITION_ID_FEATURE_NAME);
            if (this.isCreateFolderByPathDef(defId)) {
                this.updateConnector(connectorInstance, "AlfrescoCreateFolderByPath", VERSION_2_0_0);
            }
            if (this.isDeleteFolderByPathDef(defId)) {
                this.updateConnector(connectorInstance, "AlfrescoDeleteFileByPath", VERSION_2_0_0);
            }
            if (this.isDeleteDeleteItemByIdDef(defId)) {
                this.updateConnector(connectorInstance, "AlfrescoDeleteItemById", VERSION_2_0_0);
            }
            if (!this.isUploadFileByPathDef(defId)) continue;
            this.updateConnector(connectorInstance, "AlfrescoUploadFileByPath", VERSION_2_0_0);
        }
        for (Instance connectorInstance : model.getAllInstances("connectorconfiguration.ConnectorConfiguration")) {
            defId = (String)connectorInstance.get(DEFINITION_ID_FEATURE_NAME);
            if (this.isCreateFolderByPathDef(defId)) {
                this.updateConfig(connectorInstance, "AlfrescoCreateFolderByPath", VERSION_2_0_0);
            }
            if (this.isDeleteFolderByPathDef(defId)) {
                this.updateConfig(connectorInstance, "AlfrescoDeleteFileByPath", VERSION_2_0_0);
            }
            if (this.isDeleteDeleteItemByIdDef(defId)) {
                this.updateConfig(connectorInstance, "AlfrescoDeleteItemById", VERSION_2_0_0);
            }
            if (!this.isUploadFileByPathDef(defId)) continue;
            this.updateConfig(connectorInstance, "AlfrescoUploadFileByPath", VERSION_2_0_0);
        }
    }

    private boolean isCreateFolderByPathDef(String defId) {
        return "Alfresco34CreateFolderByPath".equals(defId) || "Alfresco42CreateFolderByPath".equals(defId);
    }

    private boolean isDeleteFolderByPathDef(String defId) {
        return "Alfresco34DeleteFileByPath".equals(defId) || "Alfresco42DeleteFileByPath".equals(defId);
    }

    private boolean isDeleteDeleteItemByIdDef(String defId) {
        return "Alfresco34DeleteItemById".equals(defId) || "Alfresco42DeleteItemById".equals(defId);
    }

    private boolean isUploadFileByPathDef(String defId) {
        return "Alfresco34UploadFileByPath".equals(defId) || "Alfresco42UploadFileByPath".equals(defId);
    }

    private void updateConnector(Instance connectorInstance, String newDefId, String newVersion) {
        connectorInstance.set(DEFINITION_VERSION_FEATURE_NAME, (Object)newVersion);
        connectorInstance.set(DEFINITION_ID_FEATURE_NAME, (Object)newDefId);
    }

    private void updateConfig(Instance connectorConfigInstance, String newDefId, String newVersion) {
        connectorConfigInstance.set(VERSION_FEATURE_NAME, (Object)newVersion);
        connectorConfigInstance.set(DEFINITION_ID_FEATURE_NAME, (Object)newDefId);
    }
}

