/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.multiinstance;

import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.bonitasoft.bpm.model.process.MultiInstanceType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class MultiInstanceMigrator {
    private static final String MULTI_INSTANTIATION_FEATURE_NAME = "multiInstantiation";
    private final Instance sourceInstance;
    private boolean isLoop;
    private boolean testBefore;
    private boolean useCardinality;
    private boolean isMulti;
    private boolean isSequential;
    private Instance cardinalityExpression;
    private Instance iteratorExpression;
    private Instance collectionDataToMultiInstantiate;
    private Instance outputData;
    private Instance listDataContainingOutputResults;
    private Instance completionCondition;
    private Instance loopCondition;
    private Instance loopMaximum;

    public MultiInstanceMigrator(Instance sourceInstance) {
        this.sourceInstance = sourceInstance;
    }

    public void save(Model model) {
        this.isLoop = this.isStandardLoop();
        this.testBefore = this.isTestBefore();
        this.useCardinality = this.useCardinality();
        this.isMulti = this.isMultiInstantiated();
        this.isSequential = this.isSequential();
        this.cardinalityExpression = this.getCardinalityExpression(model);
        this.iteratorExpression = this.getIteratorExpression(model);
        this.collectionDataToMultiInstantiate = this.getInputList();
        this.outputData = this.getOutputData();
        this.listDataContainingOutputResults = this.getOutputList();
        this.completionCondition = this.getCompletionCondition(model);
        this.loopCondition = this.getLoopCondition(model);
        this.loopMaximum = this.getLoopMaximum(model);
    }

    public void migrate(Instance targetInstance, Metamodel metamodel) {
        targetInstance.set("type", this.getType(metamodel));
        targetInstance.set("testBefore", (Object)this.testBefore);
        targetInstance.set("loopCondition", (Object)this.loopCondition);
        targetInstance.set("loopMaximum", (Object)this.loopMaximum);
        targetInstance.set("useCardinality", (Object)this.useCardinality);
        targetInstance.set("cardinalityExpression", (Object)this.cardinalityExpression);
        targetInstance.set("collectionDataToMultiInstantiate", (Object)this.collectionDataToMultiInstantiate);
        targetInstance.set("iteratorExpression", (Object)this.iteratorExpression);
        targetInstance.set("outputData", (Object)this.outputData);
        targetInstance.set("listDataContainingOutputResults", (Object)this.listDataContainingOutputResults);
        targetInstance.set("completionCondition", (Object)this.completionCondition);
        targetInstance.set("storeOutput", (Object)(this.listDataContainingOutputResults != null || this.outputData != null ? 1 : 0));
    }

    private Instance getOutputList() {
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        if (multiInstantiationInstance != null) {
            return (Instance)multiInstantiationInstance.get("listDataContainingOutputResults");
        }
        return null;
    }

    private Instance getOutputData() {
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        if (multiInstantiationInstance != null) {
            return (Instance)multiInstantiationInstance.get("outputData");
        }
        return null;
    }

    private Instance getInputList() {
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        if (multiInstantiationInstance != null) {
            return (Instance)multiInstantiationInstance.get("collectionDataToMultiInstantiate");
        }
        return null;
    }

    private Instance getIteratorExpression(Model model) {
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        if (multiInstantiationInstance != null && multiInstantiationInstance.get("inputData") != null) {
            Instance dataInstance = (Instance)multiInstantiationInstance.get("inputData");
            String dataName = (String)dataInstance.get("name");
            return StringToExpressionConverter.createExpressionInstance(model, dataName, dataName, StringToExpressionConverter.getDataReturnType(dataInstance), "MULTIINSTANCE_ITERATOR_TYPE", false);
        }
        return StringToExpressionConverter.createExpressionInstance(model, "multiInstanceIterator", "multiInstanceIterator", Object.class.getName(), "MULTIINSTANCE_ITERATOR_TYPE", false);
    }

    private Instance getCompletionCondition(Model model) {
        Instance originalInstance;
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        Instance expressionInstance = null;
        if (multiInstantiationInstance != null && (originalInstance = (Instance)multiInstantiationInstance.get("completionCondition")) != null) {
            expressionInstance = originalInstance.copy();
            model.delete(originalInstance);
        }
        if (expressionInstance == null) {
            expressionInstance = StringToExpressionConverter.createExpressionInstance(model, "", "", Boolean.class.getName(), "TYPE_CONSTANT", true);
        }
        return expressionInstance;
    }

    private Instance getCardinalityExpression(Model model) {
        Instance originalInstance;
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        Instance expressionInstance = null;
        if (multiInstantiationInstance != null && (originalInstance = (Instance)multiInstantiationInstance.get("cardinality")) != null) {
            expressionInstance = originalInstance.copy();
            model.delete(originalInstance);
        }
        if (expressionInstance == null) {
            expressionInstance = StringToExpressionConverter.createExpressionInstance(model, "", "", Integer.class.getName(), "TYPE_CONSTANT", true);
        }
        return expressionInstance;
    }

    private boolean useCardinality() {
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        if (multiInstantiationInstance != null) {
            return (Boolean)multiInstantiationInstance.get("useCardinality");
        }
        return true;
    }

    private Instance getLoopMaximum(Model model) {
        Instance expressionInstance = (Instance)this.sourceInstance.get("loopMaximum");
        if (expressionInstance == null) {
            expressionInstance = StringToExpressionConverter.createExpressionInstance(model, "", "", Integer.class.getName(), "TYPE_CONSTANT", true);
        }
        return expressionInstance;
    }

    private Instance getLoopCondition(Model model) {
        Instance expressionInstance = (Instance)this.sourceInstance.get("loopCondition");
        if (expressionInstance == null) {
            expressionInstance = StringToExpressionConverter.createExpressionInstance(model, "", "", Boolean.class.getName(), "TYPE_CONSTANT", true);
        }
        return expressionInstance;
    }

    private boolean isTestBefore() {
        return (Boolean)this.sourceInstance.get("testBefore");
    }

    private Object getType(Metamodel metamodel) {
        EEnum multiInstanceType = metamodel.getEEnum("process.MultiInstanceType");
        if (this.isLoop) {
            return multiInstanceType.getEEnumLiteral(MultiInstanceType.STANDARD.name());
        }
        if (this.isParallelMultiInstantiation()) {
            return multiInstanceType.getEEnumLiteral(MultiInstanceType.PARALLEL.name());
        }
        if (this.isSequentialMultiInstantiation()) {
            return multiInstanceType.getEEnumLiteral(MultiInstanceType.SEQUENTIAL.name());
        }
        return multiInstanceType.getEEnumLiteral(MultiInstanceType.NONE.name());
    }

    private boolean isParallelMultiInstantiation() {
        return this.isMulti && !this.isSequential;
    }

    private boolean isSequential() {
        Instance multiInstantiationInstance = (Instance)this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME);
        if (multiInstantiationInstance != null) {
            return (Boolean)multiInstantiationInstance.get("sequential");
        }
        return false;
    }

    private Boolean isMultiInstantiated() {
        if (((Boolean)this.sourceInstance.get("isMultiInstance")).booleanValue() && this.sourceInstance.get(MULTI_INSTANTIATION_FEATURE_NAME) != null) {
            return true;
        }
        return false;
    }

    private boolean isSequentialMultiInstantiation() {
        return this.isMulti && this.isSequential;
    }

    private boolean isStandardLoop() {
        return (Boolean)this.sourceInstance.get("isLoop");
    }
}

