/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.spi.migration.Instance;

public class CustomMigrationUtil {
    private CustomMigrationUtil() {
    }

    public static Instance deepCopy(Instance instance) {
        HashMap<Instance, Instance> map = new HashMap<Instance, Instance>();
        return CustomMigrationUtil.copyTree(instance, map);
    }

    private static Instance copyTree(Instance original, Map<Instance, Instance> map) {
        EClass eClass = original.getEClass();
        Instance copi = original.getType().getModel().newInstance(eClass);
        for (EReference reference : eClass.getEAllReferences()) {
            Instance ref2;
            if (reference.isContainment()) {
                Instance child2;
                if (reference.isMany()) {
                    for (Instance child2 : original.getLinks(reference)) {
                        copi.add((EStructuralFeature)reference, (Object)CustomMigrationUtil.copyTree(child2, map));
                    }
                    continue;
                }
                child2 = (Instance)original.get((EStructuralFeature)reference);
                if (child2 == null) continue;
                copi.set((EStructuralFeature)reference, (Object)CustomMigrationUtil.copyTree(child2, map));
                continue;
            }
            if (reference.isMany()) {
                if (reference.getEOpposite() != null && !reference.getEOpposite().isMany()) continue;
                for (Instance ref2 : original.getLinks(reference)) {
                    if (map.get(ref2) != null) {
                        ref2 = map.get(ref2);
                    }
                    copi.add((EStructuralFeature)reference, (Object)ref2);
                }
                continue;
            }
            if (reference.getEOpposite() != null && reference.getEOpposite().isContainment() || (ref2 = (Instance)original.get((EStructuralFeature)reference)) == null) continue;
            if (map.get(ref2) != null) {
                ref2 = map.get(ref2);
            }
            copi.set((EStructuralFeature)reference, (Object)ref2);
        }
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            copi.set((EStructuralFeature)attribute, original.get((EStructuralFeature)attribute));
        }
        map.put(original, copi);
        return copi;
    }
}

