/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class ExpectedDurationMigration
extends CustomMigration {
    protected Map<String, String> taskDurations = new HashMap<String, String>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance task : model.getAllInstances("process.Task")) {
            String duration = (String)task.get("duration");
            if (duration == null) continue;
            this.taskDurations.put(task.getUuid(), duration);
        }
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance task : model.getAllInstances("process.Task")) {
            String duration;
            Instance expression = (Instance)task.get("expectedDuration");
            if (expression == null && (duration = this.taskDurations.get(task.getUuid())) != null) {
                expression = StringToExpressionConverter.createExpressionInstance(model, duration, duration, Long.class.getName(), "TYPE_CONSTANT", true);
            }
            task.set("expectedDuration", (Object)expression);
        }
    }
}

