/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class Removev6FromCustomMigration
extends CustomMigration {
    private Map<String, String> names = new HashMap<String, String>();
    private Map<String, String> documentations = new HashMap<String, String>();
    private Map<String, Object> textAnnotationAttachments = new HashMap<String, Object>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance absractProcess : model.getAllInstances("process.AbstractProcess")) {
            this.store(absractProcess);
        }
        for (Instance flowElement : model.getAllInstances("process.FlowElement")) {
            this.store(flowElement);
        }
    }

    private void store(Instance instance) {
        this.names.put(instance.getUuid(), (String)instance.get("name"));
        this.documentations.put(instance.getUuid(), (String)instance.get("documentation"));
        List attachments = (List)instance.get("textAnnotationAttachment");
        ArrayList<Instance> newList = new ArrayList<Instance>();
        for (Instance attacment : attachments) {
            newList.add(attacment.copy());
        }
        this.textAnnotationAttachments.put(instance.getUuid(), newList);
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance absractProcess : model.getAllInstances("process.AbstractProcess")) {
            this.write(absractProcess);
        }
        for (Instance flowElement : model.getAllInstances("process.FlowElement")) {
            this.write(flowElement);
        }
        for (Instance instance : model.getAllInstances("process.MainProcess")) {
            Instance overviewFormMapping;
            Instance formMapping = (Instance)instance.get("formMapping");
            if (formMapping != null) {
                model.delete(formMapping);
            }
            if ((overviewFormMapping = (Instance)instance.get("overviewFormMapping")) == null) continue;
            model.delete(overviewFormMapping);
        }
    }

    private void write(Instance instance) {
        instance.set("name", (Object)this.names.get(instance.getUuid()));
        instance.set("documentation", (Object)this.documentations.get(instance.getUuid()));
        List attachements = (List)this.textAnnotationAttachments.get(instance.getUuid());
        for (Instance attachement : attachements) {
            instance.add("textAnnotationAttachment", (Object)attachement);
        }
    }
}

