/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.connectorconfiguration;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class UIPathConnectorDefinitionMigration
extends CustomMigration {
    private static final String UIPATH_STARTJOB_ID = "uipath-startjob";
    private static final Set<String> UI_PATH_DEFINITIONS_IDS = new HashSet<String>();
    private static final String SOURCE_DEFINITION_VERSION = "2.0.0";
    private static final String TARGET_DEFINITION_VERSION = "2.1.0";
    private static final String ORGANIZATION_UNIT_ID_INPUT = "organizationUnitId";
    private static final String RUNTIME_TYPE_INPUT = "runtimeType";
    private static final String SOURCE_INPUT = "source";

    static {
        UI_PATH_DEFINITIONS_IDS.add("uipath-getjob");
        UI_PATH_DEFINITIONS_IDS.add(UIPATH_STARTJOB_ID);
        UI_PATH_DEFINITIONS_IDS.add("uipath-add-queueItem");
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance configuration : model.getAllInstances("connectorconfiguration.ConnectorConfiguration")) {
            Instance container;
            if (!UI_PATH_DEFINITIONS_IDS.contains(configuration.get("definitionId")) || !SOURCE_DEFINITION_VERSION.equals(configuration.get("version"))) continue;
            EList parameters = configuration.getLinks("parameters");
            parameters.add(this.createParamenter(model, ORGANIZATION_UNIT_ID_INPUT, "", String.class.getName()));
            if (UIPATH_STARTJOB_ID.equals(configuration.get("definitionId"))) {
                parameters.add(this.createParamenter(model, RUNTIME_TYPE_INPUT, "Development", String.class.getName()));
                parameters.add(this.createParamenter(model, SOURCE_INPUT, "Manual", String.class.getName()));
            }
            if ((container = configuration.getContainer()).instanceOf("process.Connector")) {
                container.set("definitionVersion", (Object)TARGET_DEFINITION_VERSION);
            }
            configuration.set("version", (Object)TARGET_DEFINITION_VERSION);
        }
    }

    private Instance createParamenter(Model model, String key, String value, String returnType) {
        Instance connectorParameter = model.newInstance("connectorconfiguration.ConnectorParameter");
        connectorParameter.set("key", (Object)key);
        connectorParameter.set("expression", (Object)this.createConstantExpression(model, value, returnType));
        return connectorParameter;
    }

    private Instance createConstantExpression(Model model, String content, String returnClassName) {
        Instance exp = model.newInstance("expression.Expression");
        exp.set("type", (Object)"TYPE_CONSTANT");
        exp.set("name", (Object)content);
        exp.set("content", (Object)content);
        exp.set("returnType", (Object)returnClassName);
        return exp;
    }
}

