/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.decision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.bpm.migration.utils.StringToExpressionConverter;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class DecisionTableMigration
extends CustomMigration {
    Map<String, List<Instance>> map = new HashMap<String, List<Instance>>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance instance : model.getAllInstances("process.decision.DecisionTableLine")) {
            ArrayList<Instance> list = new ArrayList<Instance>();
            List listCondition = (List)instance.get("conditions");
            for (Instance condition : listCondition) {
                String op1 = (String)condition.get("operand1");
                String operator = (String)condition.get("operator");
                String op2 = (String)condition.get("operand2");
                String s = op1 + operator + op2;
                Instance exp = StringToExpressionConverter.createExpressionInstance(model, s, s, Boolean.class.getName(), "TYPE_CONDITION", true);
                this.getConverter(model, this.getScope(condition)).resolveDataDependencies(exp);
                list.add(exp);
                model.delete(condition);
            }
            this.map.put(instance.getUuid(), list);
        }
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance instance : model.getAllInstances("process.decision.DecisionTableLine")) {
            List listCondition = (List)instance.get("conditions");
            listCondition.addAll((Collection)this.map.get(instance.getUuid()));
        }
    }

    public StringToExpressionConverter getConverter(Model model, Instance container) {
        return new StringToExpressionConverter(model, container);
    }

    protected Instance getScope(Instance element) {
        Instance container = element;
        while (container != null && !container.instanceOf("process.AbstractProcess")) {
            container = container.getContainer();
        }
        return container;
    }
}

