/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.document;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class DocumentTypeMigration
extends CustomMigration {
    private final Map<String, Integer> list = new HashMap<String, Integer>();

    public void migrateBefore(Model model, Metamodel metamodel) throws MigrationException {
        EList documents = model.getAllInstances("process.Document");
        for (Instance inst : documents) {
            Integer documentType = this.retrieveNewDocumentType(inst);
            this.list.put(inst.getUuid(), documentType);
        }
    }

    private Integer retrieveNewDocumentType(Instance inst) {
        boolean isDocumentInternal = (Boolean)inst.get("isInternal");
        return isDocumentInternal ? this.retriveNewDocumentTypeForOldInternalType(inst) : this.retrieveNewDocumentTypeForOldExternalType(inst);
    }

    private Integer retrieveNewDocumentTypeForOldExternalType(Instance inst) {
        Instance urlExpression = (Instance)inst.get("url");
        if (this.isEmptyUrlExpression(urlExpression)) {
            return 0;
        }
        return 2;
    }

    private Integer retriveNewDocumentTypeForOldInternalType(Instance inst) {
        String defaultValueId = (String)inst.get("defaultValueIdOfDocumentStore");
        if (defaultValueId == null || defaultValueId.isEmpty()) {
            return 0;
        }
        return 1;
    }

    private boolean isEmptyUrlExpression(Instance urlExpression) {
        if (urlExpression != null) {
            String content = (String)urlExpression.get("content");
            return content == null || content.isEmpty();
        }
        return true;
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        EList documents = model.getAllInstances("process.Document");
        for (Instance inst : documents) {
            int newDocumentType = this.list.get(inst.getUuid());
            EEnum eEnum = metamodel.getEEnum("process.DocumentType");
            inst.set("documentType", (Object)eEnum.getEEnumLiteral(newDocumentType));
        }
    }
}

