/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.custom.migration.timer;

import java.util.Date;
import org.bonitasoft.bpm.migration.utils.LegacyTimerExpressionGenerator;
import org.bonitasoft.bpm.model.process.ProcessFactory;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.bonitasoft.bpm.model.process.StartTimerEvent;
import org.bonitasoft.bpm.model.process.StartTimerScriptType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class StartTimerConditionCustomMigration
extends CustomMigration {
    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        for (Instance startTimer : model.getAllInstances("process.StartTimerEvent")) {
            EEnumLiteral scriptType = (EEnumLiteral)startTimer.get("scriptType");
            StartTimerEvent event = ProcessFactory.eINSTANCE.createStartTimerEvent();
            event.setAt((Date)startTimer.get("at"));
            event.setFrom((Date)startTimer.get("from"));
            event.setMonth(((Integer)startTimer.get("month")).intValue());
            event.setDay(((Integer)startTimer.get("day")).intValue());
            event.setHours(((Integer)startTimer.get("hours")).intValue());
            event.setDayNumber(((Integer)startTimer.get("dayNumber")).intValue());
            event.setMinutes(((Integer)startTimer.get("minutes")).intValue());
            event.setSeconds(((Integer)startTimer.get("seconds")).intValue());
            event.setScriptType(StartTimerScriptType.valueOf((String)scriptType.getLiteral()));
            if (LegacyTimerExpressionGenerator.isCycle(event)) {
                this.migrateCycleCondition(model, startTimer, event);
                continue;
            }
            if (event.getScriptType() != StartTimerScriptType.CONSTANT || event.getAt() == null) continue;
            this.migrateConstantCondition(model, startTimer);
        }
    }

    private void migrateConstantCondition(Model model, Instance startTimer) {
        Instance condition = (Instance)startTimer.get("condition");
        if (condition != null) {
            model.delete(condition);
        }
        condition = model.newInstance("expression.Expression");
        condition.set("name", (Object)"fixedDate");
        condition.set("content", (Object)LegacyTimerExpressionGenerator.generateConstant((Date)startTimer.get("at")));
        condition.set("returnType", (Object)Date.class.getName());
        condition.set("type", (Object)"TYPE_READ_ONLY_SCRIPT");
        condition.set("interpreter", (Object)"GROOVY");
        startTimer.set("condition", (Object)condition);
    }

    private void migrateCycleCondition(Model model, Instance startTimer, StartTimerEvent event) {
        LegacyTimerExpressionGenerator timerExpressionGenerator = new LegacyTimerExpressionGenerator();
        String cron = timerExpressionGenerator.getTimerExpressionContent(event);
        if (cron != null) {
            Instance condition = (Instance)startTimer.get(ProcessPackage.Literals.ABSTRACT_TIMER_EVENT__CONDITION.getName());
            if (condition != null) {
                model.delete(condition);
            }
            condition = model.newInstance("expression.Expression");
            condition.set("name", (Object)cron);
            condition.set("content", (Object)cron);
            condition.set("returnType", (Object)String.class.getName());
            condition.set("type", (Object)"TYPE_CONSTANT");
            startTimer.set(ProcessPackage.Literals.ABSTRACT_TIMER_EVENT__CONDITION.getName(), (Object)condition);
        }
    }
}

