/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.migration.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.bpm.connector.model.definition.ConnectorDefinitionPackage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.w3c.dom.Document;

public class StringToExpressionConverter {
    private static final String GROOVY_SUFFIX = "}";
    private static final String GROOVY_PREFIX = "${";
    private static final String FIELD_PREFIX = "field_";
    private final Model model;
    private final Map<String, Instance> data = new HashMap<String, Instance>();
    private final Map<String, Instance> parameters = new HashMap<String, Instance>();
    private final Map<String, Instance> widget = new HashMap<String, Instance>();
    private final Map<String, Instance> documents = new HashMap<String, Instance>();
    private String dataNameToIgnore;

    public StringToExpressionConverter(Model model, Instance container) {
        Assert.isNotNull((Object)model);
        this.model = model;
        this.initDataWithProcessData(model, container);
        this.initParameters(model, container);
        for (Instance widgetInstance : model.getAllInstances("form.Widget")) {
            if (!StringToExpressionConverter.isInScope(container, widgetInstance)) continue;
            this.widget.put(FIELD_PREFIX + String.valueOf(widgetInstance.get("name")), widgetInstance);
        }
        for (Instance document : model.getAllInstances("process.Document")) {
            if (!StringToExpressionConverter.isInScope(container, document)) continue;
            this.documents.put((String)document.get("name"), document);
        }
    }

    private void initDataWithProcessData(Model model, Instance container) {
        for (Instance dataInstance : model.getAllInstances("process.Data")) {
            if (!StringToExpressionConverter.isInScope(container, dataInstance) || dataInstance.get("dataType") == null) continue;
            this.data.put((String)dataInstance.get("name"), dataInstance);
        }
    }

    private void initParameters(Model model, Instance container) {
        for (Instance parameter : model.getAllInstances("parameter.Parameter")) {
            if (!StringToExpressionConverter.isInScope(container, parameter)) continue;
            this.parameters.put((String)parameter.get("name"), parameter);
        }
    }

    public static boolean isInScope(Instance container, Instance element) {
        Instance current = element;
        while (container != null && current != null && !container.equals(current.getContainer())) {
            current = current.getContainer();
        }
        return container != null && current != null && container.equals(current.getContainer());
    }

    public Instance parseOperation(Instance groovyScriptInstance, String returnType, boolean fixedReturnType) {
        Object expressionScript = (String)groovyScriptInstance.get("exprScript");
        String setVarScript = (String)groovyScriptInstance.get("setVarScript");
        if ((expressionScript == null || ((String)expressionScript).trim().isEmpty()) && setVarScript != null && !setVarScript.trim().isEmpty()) {
            Instance parentWidet = this.getParentWidget(groovyScriptInstance);
            String widgetName = setVarScript;
            if (parentWidet != null) {
                widgetName = (String)parentWidet.get("name");
            }
            expressionScript = "${field_" + widgetName + GROOVY_SUFFIX;
        }
        return this.parseOperation(returnType, fixedReturnType, (String)expressionScript, setVarScript);
    }

    public Instance parseOperation(String returnType, boolean fixedReturnType, String expressionScript, String setVarScript) {
        return this.parseOperation(returnType, fixedReturnType, expressionScript, setVarScript, null);
    }

    public Instance parseOperation(String returnType, boolean fixedReturnType, String expressionScript, String setVarScript, String outputType) {
        Instance operation = this.model.newInstance("expression.Operation");
        Instance actionExpression = this.parse(expressionScript, returnType, fixedReturnType, outputType);
        operation.set("rightOperand", (Object)actionExpression);
        Instance leftOperand = null;
        boolean isJavaSetter = false;
        String methodCalled = null;
        if (setVarScript != null) {
            int lastIndexOf;
            String varName = setVarScript;
            Instance dataInstance = this.data.get(varName);
            if (dataInstance == null && varName.contains("#")) {
                varName = varName.substring(0, varName.indexOf("#"));
                dataInstance = this.data.get(varName);
                isJavaSetter = true;
            }
            if (dataInstance != null) {
                String dataReturnType = StringToExpressionConverter.getDataReturnType(dataInstance);
                leftOperand = this.parse(GROOVY_PREFIX + varName + GROOVY_SUFFIX, dataReturnType, false);
                if (!isJavaSetter) {
                    actionExpression.set("returnType", (Object)dataReturnType);
                }
            }
            if (isJavaSetter && (lastIndexOf = setVarScript.lastIndexOf("#")) != -1 && lastIndexOf + 1 < setVarScript.length()) {
                methodCalled = setVarScript.substring(lastIndexOf + 1, setVarScript.length());
            }
        }
        if (leftOperand == null) {
            leftOperand = StringToExpressionConverter.createExpressionInstance(this.model, "", "", String.class.getName(), String.class.getName(), false);
        }
        operation.set("leftOperand", leftOperand);
        Instance operator = this.model.newInstance("expression.Operator");
        if (methodCalled != null) {
            operator.set("type", (Object)"JAVA_METHOD");
            operator.set("expression", methodCalled);
            operator.set("inputTypes", this.getInputTypes((String)actionExpression.get("returnType")));
        } else {
            operator.set("type", (Object)"ASSIGNMENT");
        }
        operation.set("operator", (Object)operator);
        return operation;
    }

    private List<String> getInputTypes(String returnType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(returnType);
        return result;
    }

    public static Instance createOperation(Model model, Instance leftOperand, Instance operator, Instance rightOperand) {
        Instance op = model.newInstance("expression.Operation");
        op.set("rightOperand", (Object)rightOperand);
        op.set("operator", (Object)operator);
        op.set("leftOperand", (Object)leftOperand);
        return op;
    }

    private Instance getParentWidget(Instance groovyScriptInstance) {
        Instance current = groovyScriptInstance;
        while (current != null && !current.instanceOf("form.Widget")) {
            current = current.getContainer();
        }
        return current;
    }

    public Instance parse(String stringToParse, String returnType, boolean fixedReturnType) {
        return this.parse(stringToParse, returnType, fixedReturnType, null);
    }

    public Instance parse(String stringToParse, String returnType, boolean fixedReturnType, String expressionType) {
        String content;
        String originalReturnType = returnType;
        if (returnType == null || returnType.isEmpty()) {
            returnType = String.class.getName();
        }
        if (stringToParse == null || stringToParse.isEmpty()) {
            return StringToExpressionConverter.createExpressionInstance(this.model, null, null, returnType, "TYPE_CONSTANT", fixedReturnType);
        }
        stringToParse = stringToParse.trim();
        if (expressionType == null) {
            expressionType = this.guessExpressionType(stringToParse);
        }
        if (this.isAGroovyString(content = stringToParse)) {
            content = content.substring(2, content.length() - 1);
        }
        if ("TYPE_READ_ONLY_SCRIPT".equals(expressionType)) {
            if (originalReturnType == null) {
                returnType = Object.class.getName();
            }
            Instance expression = StringToExpressionConverter.createExpressionInstance(this.model, "migratedScript", content, returnType, "TYPE_READ_ONLY_SCRIPT", fixedReturnType);
            this.resolveScriptDependencies(expression);
            return expression;
        }
        if ("TYPE_PATTERN".equals(expressionType)) {
            Instance expression = StringToExpressionConverter.createExpressionInstance(this.model, content, content, returnType, "TYPE_PATTERN", fixedReturnType);
            this.resolvePatternDependencies(expression);
            return expression;
        }
        if ("CONNECTOR_OUTPUT_TYPE".equals(expressionType)) {
            Instance expression = StringToExpressionConverter.createExpressionInstance(this.model, content, content, returnType, "CONNECTOR_OUTPUT_TYPE", fixedReturnType);
            this.resolveOutputDependencies(expression, content, returnType);
            return expression;
        }
        Instance exp = StringToExpressionConverter.createExpressionInstance(this.model, content, content, returnType, expressionType, fixedReturnType);
        if ("TYPE_VARIABLE".equals(expressionType)) {
            this.resolveDataDependencies(exp);
        } else if ("DOCUMENT_REF_TYPE".equals(expressionType)) {
            this.resolveDocumentDependencies(exp);
        }
        return exp;
    }

    private void resolveOutputDependencies(Instance expression, String name, String returnType) {
        Instance instance = this.model.newInstance(ConnectorDefinitionPackage.Literals.OUTPUT);
        instance.set("name", (Object)name);
        instance.set("type", (Object)returnType);
        expression.add("referencedElements", (Object)instance);
    }

    public void resolveDocumentDependencies(Instance expression) {
        String content = (String)expression.get("content");
        for (Map.Entry<String, Instance> document : this.documents.entrySet()) {
            String documentName = document.getKey();
            if (!content.contains(documentName)) continue;
            int index = content.indexOf(documentName);
            boolean validPrefix = this.isValidPrefix(content, index);
            boolean validSuffix = this.isValidSuffix(content, documentName, index);
            if (!validPrefix || !validSuffix) continue;
            Instance dependencyInstance = this.documents.get(documentName).copy();
            List instList = (List)expression.get("referencedElements");
            if (this.dependancyAlreadyExists(instList, dependencyInstance)) continue;
            expression.add("referencedElements", (Object)dependencyInstance);
        }
    }

    public void resolvePatternDependencies(Instance expression) {
        this.resolvePatternDataDependencies(expression);
        this.resolvePatternWidgetDependencies(expression);
    }

    private void resolvePatternWidgetDependencies(Instance expression) {
        String content = (String)expression.get("content");
        for (Map.Entry<String, Instance> widgetRef : this.widget.entrySet()) {
            String widgetName = widgetRef.getKey();
            if (!content.contains(GROOVY_PREFIX + widgetName + GROOVY_SUFFIX)) continue;
            Instance dependencyInstance = this.createFormFieldDependencyInstance(this.widget.get(widgetName));
            expression.add("referencedElements", (Object)dependencyInstance);
        }
    }

    private void resolvePatternDataDependencies(Instance expression) {
        String content = (String)expression.get("content");
        for (Map.Entry<String, Instance> dataRef : this.data.entrySet()) {
            String dataName = dataRef.getKey();
            if (!content.contains(GROOVY_PREFIX + dataName + GROOVY_SUFFIX)) continue;
            Instance dependencyInstance = this.createVariableDependencyInstance(this.data.get(dataName));
            List instList = (List)expression.get("referencedElements");
            if (this.dependancyAlreadyExists(instList, dependencyInstance)) continue;
            expression.add("referencedElements", (Object)dependencyInstance);
        }
    }

    public void resolveScriptDependencies(Instance expression) {
        this.resolveDataDependencies(expression);
        this.resolveWidgetDependencies(expression);
    }

    public void resolveWidgetDependencies(Instance expression) {
        String content = (String)expression.get("content");
        for (Map.Entry<String, Instance> widgetRef : this.widget.entrySet()) {
            String widgetName = widgetRef.getKey();
            if (!content.contains(widgetName)) continue;
            int index = content.indexOf(widgetName);
            boolean validPrefix = this.isValidWidgetPrefix(content, index);
            boolean validSuffix = this.isValidSuffix(content, widgetName, index);
            if (!validPrefix || !validSuffix) continue;
            Instance dependencyInstance = this.createFormFieldDependencyInstance(this.widget.get(widgetName));
            expression.add("referencedElements", (Object)dependencyInstance);
        }
    }

    private boolean isValidWidgetPrefix(String content, int index) {
        boolean validPrefix = false;
        if (index > 0) {
            String prefix = content.substring(index - 1, index);
            if (!Character.isLetter(prefix.toCharArray()[0])) {
                validPrefix = true;
            }
        } else if (index == 0) {
            validPrefix = true;
        }
        return validPrefix;
    }

    public boolean resolveDataDependencies(Instance expression) {
        boolean hasAdded = false;
        String currentDataName = (String)expression.get("content");
        if (currentDataName == null) {
            currentDataName = (String)expression.get("name");
        }
        if (currentDataName != null) {
            for (Map.Entry<String, Instance> dataRef : this.data.entrySet()) {
                String dataName = dataRef.getKey();
                if (!currentDataName.contains(dataName) || dataName.equals(this.dataNameToIgnore)) continue;
                int index = currentDataName.indexOf(dataName);
                boolean validPrefix = this.isValidPrefix(currentDataName, index);
                boolean validSuffix = this.isValidSuffix(currentDataName, dataName, index);
                if (!validPrefix || !validSuffix) continue;
                Instance dependencyInstance = this.createVariableDependencyInstance(this.data.get(dataName));
                List instList = (List)expression.get("referencedElements");
                if (this.dependancyAlreadyExists(instList, dependencyInstance)) continue;
                expression.add("referencedElements", (Object)dependencyInstance);
                hasAdded = true;
            }
        }
        return hasAdded;
    }

    public boolean resolveParameterDependencies(Instance expression) {
        boolean hasAdded = false;
        String currentParamName = (String)expression.get("content");
        if (currentParamName == null) {
            currentParamName = (String)expression.get("name");
        }
        if (currentParamName != null) {
            for (Map.Entry<String, Instance> paramRef : this.parameters.entrySet()) {
                String paramName = paramRef.getKey();
                if (!currentParamName.contains(paramName)) continue;
                int index = currentParamName.indexOf(paramName);
                boolean validPrefix = this.isValidPrefix(currentParamName, index);
                boolean validSuffix = this.isValidSuffix(currentParamName, paramName, index);
                if (!validPrefix || !validSuffix) continue;
                Instance dependencyInstance = this.parameters.get(paramName).copy();
                List instList = (List)expression.get("referencedElements");
                if (this.dependancyAlreadyExists(instList, dependencyInstance)) continue;
                expression.add("referencedElements", (Object)dependencyInstance);
                hasAdded = true;
            }
        }
        return hasAdded;
    }

    private boolean isValidSuffix(String currentDataName, String dataName, int index) {
        boolean validSuffix = false;
        if (index + dataName.length() < currentDataName.length()) {
            String suffix = currentDataName.substring(index + dataName.length(), index + dataName.length() + 1);
            if (!Character.isLetter(suffix.toCharArray()[0])) {
                validSuffix = true;
            }
        } else if (index + dataName.length() == currentDataName.trim().length()) {
            validSuffix = true;
        }
        return validSuffix;
    }

    private boolean isValidPrefix(String currentDataName, int index) {
        boolean validPrefix = false;
        if (index > 0) {
            String prefix = currentDataName.substring(index - 1, index);
            char previousChar = prefix.toCharArray()[0];
            if (!Character.isLetter(previousChar) && '_' != previousChar) {
                validPrefix = true;
            }
        } else if (index == 0) {
            validPrefix = true;
        }
        return validPrefix;
    }

    private boolean dependancyAlreadyExists(List<Instance> instList, Instance dependencyInstance) {
        String dataName = (String)dependencyInstance.get("name");
        for (Instance instance : instList) {
            if (!instance.get("name").equals(dataName)) continue;
            return true;
        }
        return false;
    }

    private Instance createFormFieldDependencyInstance(Instance widgetInstance) {
        Instance widgetCopy = widgetInstance.copy();
        for (Instance content : widgetCopy.getContents()) {
            this.model.delete(content);
        }
        widgetCopy.set("dependOn", Collections.emptyList());
        return widgetCopy;
    }

    private Instance createVariableDependencyInstance(Instance dataInstance) {
        Object defaultValue;
        Instance copy = dataInstance.copy();
        if (copy.instanceOf("process.Data") && (defaultValue = copy.get("defaultValue")) instanceof Instance && ((Instance)defaultValue).instanceOf("expression.Expression")) {
            this.model.delete((Instance)defaultValue);
            copy.set("defaultValue", null);
        }
        return copy;
    }

    private String guessExpressionType(String stringToParse) {
        if (this.isAGroovyString(stringToParse)) {
            String groovyScript = stringToParse.substring(2, stringToParse.length() - 1);
            if (this.data.containsKey(groovyScript)) {
                return "TYPE_VARIABLE";
            }
            if (this.documents.containsKey(groovyScript)) {
                return "DOCUMENT_REF_TYPE";
            }
            return "TYPE_READ_ONLY_SCRIPT";
        }
        return "TYPE_CONSTANT";
    }

    private boolean isAGroovyString(String stringToParse) {
        return stringToParse.startsWith(GROOVY_PREFIX) && stringToParse.endsWith(GROOVY_SUFFIX);
    }

    public static Instance createExpressionInstance(Model model, String name, String content, String returnType, String expresisonType, boolean fixedReturnType) {
        Instance instance = model.newInstance("expression.Expression");
        instance.set("name", (Object)name);
        instance.set("content", (Object)content);
        instance.set("returnType", (Object)returnType);
        instance.set("returnTypeFixed", (Object)fixedReturnType);
        instance.set("type", (Object)expresisonType);
        if ("TYPE_READ_ONLY_SCRIPT".equals(expresisonType)) {
            instance.set("interpreter", (Object)"GROOVY");
        }
        return instance;
    }

    public static Instance createExpressionInstanceWithDependency(Model model, String name, String content, String returnType, String expresisonType, boolean fixedReturnType, Instance dependency) {
        Instance instance = model.newInstance("expression.Expression");
        instance.set("name", (Object)name);
        instance.set("content", (Object)content);
        instance.set("returnType", (Object)returnType);
        instance.set("returnTypeFixed", (Object)fixedReturnType);
        instance.set("type", (Object)expresisonType);
        if ("TYPE_READ_ONLY_SCRIPT".equals(expresisonType)) {
            instance.set("interpreter", (Object)"GROOVY");
        }
        if (dependency != null) {
            instance.add("referencedElements", (Object)dependency.copy());
        }
        return instance;
    }

    public static String getDataReturnType(Instance data) {
        if (((Boolean)data.get("multiple")).booleanValue()) {
            return List.class.getName();
        }
        Instance dataype = (Instance)data.get("dataType");
        if (dataype == null) {
            return String.class.getName();
        }
        if (dataype.instanceOf("process.IntegerType")) {
            return Integer.class.getName();
        }
        if (dataype.instanceOf("process.BooleanType")) {
            return Boolean.class.getName();
        }
        if (dataype.instanceOf("process.DoubleType")) {
            return Double.class.getName();
        }
        if (dataype.instanceOf("process.FloatType")) {
            return Float.class.getName();
        }
        if (dataype.instanceOf("process.EnumType")) {
            return String.class.getName();
        }
        if (dataype.instanceOf("process.JavaType")) {
            String returnType = (String)data.get("className");
            if (returnType != null && !returnType.isEmpty()) {
                return returnType;
            }
        } else {
            if (dataype.instanceOf("process.LongType")) {
                return Long.class.getName();
            }
            if (dataype.instanceOf("process.XMLType")) {
                return Document.class.getName();
            }
            if (dataype.instanceOf("process.DateType")) {
                return Date.class.getName();
            }
        }
        return String.class.getName();
    }

    public static int getStatusForExpression(Instance expression) {
        return "TYPE_READ_ONLY_SCRIPT".equals(expression.get("type")) ? 2 : 0;
    }

    public void setDataToIgnore(String dataName) {
        this.dataNameToIgnore = dataName;
    }
}

