/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.edit.process;

import java.util.List;
import java.util.Optional;
import org.bonitasoft.bpm.model.edit.ProcessEditPlugin;
import org.bonitasoft.bpm.model.edit.provider.BottomLeftDecoratedImage;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.JavaObjectData;
import org.bonitasoft.bpm.model.process.provider.JavaObjectDataItemProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CustomJavaObjectDataItemProvider
extends JavaObjectDataItemProvider {
    public CustomJavaObjectDataItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        Data d = (Data)object;
        return "Data " + d.getName();
    }

    @Override
    public Object getImage(Object object) {
        Object icon = super.getImage(object);
        if (object instanceof Data) {
            String className;
            boolean formTransient;
            boolean bl = formTransient = ((Data)object).getDatasourceId() != null && ((Data)object).getDatasourceId().equals("PAGEFLOW");
            if (object instanceof JavaObjectData && (className = ((JavaObjectData)object).getClassName()) != null) {
                try {
                    IType t;
                    Optional<IJavaProject> javaProj = this.getJavaProjectIfPossible(((JavaObjectData)object).eResource());
                    IType iType = t = javaProj.isPresent() ? javaProj.get().findType(className) : null;
                    if (t != null && t.isInterface()) {
                        Object mainImage = ProcessEditPlugin.INSTANCE.getImage("int_obj.gif");
                        if (formTransient) {
                            Object formDeco = ProcessEditPlugin.INSTANCE.getImage("form_decorator.png");
                            return new BottomLeftDecoratedImage(List.of(mainImage, formDeco));
                        }
                        return mainImage;
                    }
                    Object mainImage = ProcessEditPlugin.INSTANCE.getImage("class_obj.gif");
                    if (formTransient) {
                        Object formDeco = ProcessEditPlugin.INSTANCE.getImage("form_decorator.png");
                        return new BottomLeftDecoratedImage(List.of(mainImage, formDeco));
                    }
                    return mainImage;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return icon;
    }

    private Optional<IJavaProject> getJavaProjectIfPossible(Resource eResource) {
        if (eResource == null) {
            return Optional.empty();
        }
        URI uri = eResource.getResourceSet().getURIConverter().normalize(eResource.getURI());
        if (uri.isFile()) {
            String fileString = uri.toFileString();
            IPath path = Path.fromOSString((String)fileString);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            return Optional.ofNullable(JavaCore.create((IProject)iFile.getProject()));
        }
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            IPath path = Path.fromPortableString((String)platformString);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            return Optional.ofNullable(JavaCore.create((IProject)iFile.getProject()));
        }
        return Optional.empty();
    }
}

