/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.edit.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.bonitasoft.bpm.model.process.Contract;
import org.bonitasoft.bpm.model.process.ContractInput;
import org.bonitasoft.bpm.model.process.ContractInputType;
import org.bonitasoft.bpm.model.process.ProcessFactory;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.bonitasoft.bpm.model.process.Task;
import org.bonitasoft.bpm.model.process.provider.ContractInputItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

public class CustomContractInputItemProvider
extends ContractInputItemProvider {
    public CustomContractInputItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ContractInput_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ContractInput_type_feature", "_UI_ContractInput_type"), (EStructuralFeature)ProcessPackage.Literals.CONTRACT_INPUT__TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public IItemLabelProvider getLabelProvider(Object object) {
                return new ItemPropertyDescriptor.ItemDelegator(this, this.adapterFactory, this.resourceLocator){

                    public String getText(Object object) {
                        if (object instanceof ContractInputType) {
                            String label = this.getTypeLabel((ContractInputType)object);
                            return String.format("%s - %s", label, CustomContractInputItemProvider.this.javaType((ContractInputType)object));
                        }
                        return super.getText(object);
                    }

                    protected String getTypeLabel(ContractInputType type) {
                        switch (type) {
                            case DATE: {
                                return "DATE (NOT RECOMMENDED)";
                            }
                            case LOCALDATE: {
                                return "DATE ONLY";
                            }
                            case LOCALDATETIME: {
                                return "DATE-TIME (NO TIME ZONE)";
                            }
                            case OFFSETDATETIME: {
                                return "DATE-TIME (TIME ZONE)";
                            }
                        }
                        return super.getText((Object)type);
                    }
                };
            }

            protected Collection<?> getComboBoxObjects(Object object) {
                ArrayList<ContractInputType> comboBoxObjects = new ArrayList<ContractInputType>(Arrays.asList(ContractInputType.BOOLEAN, ContractInputType.COMPLEX, ContractInputType.LOCALDATE, ContractInputType.LOCALDATETIME, ContractInputType.OFFSETDATETIME, ContractInputType.DECIMAL, ContractInputType.FILE, ContractInputType.INTEGER, ContractInputType.LONG, ContractInputType.TEXT, ContractInputType.DATE));
                if (this.getContractContainer((EObject)object) instanceof Task) {
                    comboBoxObjects.remove(ContractInputType.LONG);
                }
                return comboBoxObjects;
            }

            private EObject getContractContainer(EObject object) {
                EObject current = object;
                while (!(current instanceof Contract)) {
                    current = current.eContainer();
                }
                return current.eContainer();
            }
        });
    }

    private String javaType(ContractInputType type) {
        ContractInput contractInput = ProcessFactory.eINSTANCE.createContractInput();
        contractInput.setType(type);
        return contractInput.getJavaType();
    }
}

