/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.simulation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeUnit implements Enumerator
{
    MINUTE(0, "Minute", "Minute"),
    HOUR(1, "Hour", "Hour"),
    DAY(2, "Day", "Day"),
    WEEK(3, "Week", "Week"),
    MONTH(4, "Month", "Month"),
    YEAR(5, "Year", "Year");

    public static final int MINUTE_VALUE = 0;
    public static final int HOUR_VALUE = 1;
    public static final int DAY_VALUE = 2;
    public static final int WEEK_VALUE = 3;
    public static final int MONTH_VALUE = 4;
    public static final int YEAR_VALUE = 5;
    private static final TimeUnit[] VALUES_ARRAY;
    public static final List<TimeUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeUnit[]{MINUTE, HOUR, DAY, WEEK, MONTH, YEAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnit get(int value) {
        switch (value) {
            case 0: {
                return MINUTE;
            }
            case 1: {
                return HOUR;
            }
            case 2: {
                return DAY;
            }
            case 3: {
                return WEEK;
            }
            case 4: {
                return MONTH;
            }
            case 5: {
                return YEAR;
            }
        }
        return null;
    }

    private TimeUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

