/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class EnvironmentUtil {
    private EnvironmentUtil() {
    }

    public static boolean isOSGi() {
        Predicate<Class> isOSGiBundleRef = c -> {
            BiPredicate<BiPredicate, Class> isOSGiBundleRefHelper = (bipredicate, clazz) -> clazz.getName().equals("org.osgi.framework.BundleReference") || Stream.of(clazz.getInterfaces()).anyMatch(i -> bipredicate.test(bipredicate, i)) || clazz.getSuperclass() != null && bipredicate.test(bipredicate, clazz.getSuperclass());
            return isOSGiBundleRefHelper.test(isOSGiBundleRefHelper, (Class)c);
        };
        Optional<Class> classLoaderClass = Optional.ofNullable(EnvironmentUtil.class.getClassLoader()).map(Object::getClass);
        return classLoaderClass.filter(isOSGiBundleRef).isPresent();
    }

    public static boolean isWindows() {
        return Optional.ofNullable(System.getProperty("os.name")).map(os -> os.startsWith("Windows")).orElse(false);
    }
}

