/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContractInputType implements Enumerator
{
    TEXT(0, "TEXT", "TEXT"),
    INTEGER(1, "INTEGER", "INTEGER"),
    DECIMAL(2, "DECIMAL", "DECIMAL"),
    BOOLEAN(3, "BOOLEAN", "BOOLEAN"),
    DATE(4, "DATE", "DATE"),
    COMPLEX(5, "COMPLEX", "COMPLEX"),
    FILE(6, "FILE", "FILE"),
    LONG(7, "LONG", "LONG"),
    LOCALDATE(8, "LOCALDATE", "LOCALDATE"),
    LOCALDATETIME(9, "LOCALDATETIME", "LOCALDATETIME"),
    OFFSETDATETIME(10, "OFFSETDATETIME", "OFFSETDATETIME");

    public static final int TEXT_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int DECIMAL_VALUE = 2;
    public static final int BOOLEAN_VALUE = 3;
    public static final int DATE_VALUE = 4;
    public static final int COMPLEX_VALUE = 5;
    public static final int FILE_VALUE = 6;
    public static final int LONG_VALUE = 7;
    public static final int LOCALDATE_VALUE = 8;
    public static final int LOCALDATETIME_VALUE = 9;
    public static final int OFFSETDATETIME_VALUE = 10;
    private static final ContractInputType[] VALUES_ARRAY;
    public static final List<ContractInputType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContractInputType[]{TEXT, INTEGER, DECIMAL, BOOLEAN, DATE, COMPLEX, FILE, LONG, LOCALDATE, LOCALDATETIME, OFFSETDATETIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContractInputType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractInputType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractInputType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractInputType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractInputType get(int value) {
        switch (value) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return DECIMAL;
            }
            case 3: {
                return BOOLEAN;
            }
            case 4: {
                return DATE;
            }
            case 5: {
                return COMPLEX;
            }
            case 6: {
                return FILE;
            }
            case 7: {
                return LONG;
            }
            case 8: {
                return LOCALDATE;
            }
            case 9: {
                return LOCALDATETIME;
            }
            case 10: {
                return OFFSETDATETIME;
            }
        }
        return null;
    }

    private ContractInputType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

